package com.xunlei.niux.manager.template.builder.gameofficial.thread;


import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.proxy.GameBoxPicProxy;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.GameTemplateUtil;


public class GameTask implements Runnable{
	
	private Games games;
	private boolean isAdd;
	
	public GameTask(Games games,boolean isAdd){
		this.games  = games;
		this.isAdd = isAdd;
	}
	
	@Override
	public void run() {
		//更新缓存
		GameCache.getInstance().updateCache();
		addGameTemplateSchema();
		synchPicToBox(games);
		if(isAdd)
			addTempldate();
	}
	
	private void synchPicToBox(Games games){
		if(games == null)return;
		GameBoxPicProxy.getInstance().synchPic(games.getPicUrl(), "b", games.getGameId(),false);
	}

	private void addGameTemplateSchema(){
		String nowStr=DateUtil.formatNowByDefault();
    	//添加执行计划
		TemplateSchema ts=new TemplateSchema();
		ts.setTemplateid("000007");
		ts.setSchematime(nowStr);
		ts.setIsexecuted(false);
		ts.setInputby("系统");
		ts.setInputtime(nowStr);
		ts.setIspreview(false);
		ts.setExt1("");
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
	}
	
	private void addTempldate(){
		GameTemplateUtil.addGameOfficialTemplateSchema(games.getGameId());
	}
}
