
package com.xunlei.niux.manager.template.builder.gameofficial;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.GameShowCategory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.PageStatisticsJs;
import com.xunlei.niux.data.vipgame.vo.Spreadinfo;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.data.vipgame.vo.version.GameVersion;
import com.xunlei.niux.data.vipgame.vo.version.VersionInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.proxy.SpreadInfoProxy;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

/**
 * 生成游戏官网
 * 
 * @author Administrator
 * 
 */
public class GameOfficialBuilder extends AbstractTemplateBuilder {
	private static SimpleDateFormat sdfshort1 = new SimpleDateFormat("MM月dd日  HH:mm");
	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static  String seo_title = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("seo_title");
	private static  String seo_keywords = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("seo_keywords");
	private static  String seo_description = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("seo_description");
	private Games games = null;
	private VersionInfo version = null;
	private HashMap<String,String> gameCategoryMap;
	//private static final String GE_XING_GAME_ID = "000180";//大圣传奇
	private String indexIntroModName;
    private String templateRoot;
    private String htmlFilePath;
	private static final int defaultWidth = 246;
	private static final int defaultHeight  = 136;

	@Override
	public void executeShcema() throws Exception {
		games = GameCache.getInstance().getGameByGameId(schema.getExt1());
        if(games == null){
            throw new RuntimeException("gameid "+schema.getExt1() +" 对应游戏信息不存在！");
        }
        templateRoot = htmlTemplate.getTemplateroot();
        if(templateRoot.endsWith("/")){
            templateRoot = templateRoot.substring(0,templateRoot.length()-1);
        }
//        if (GE_XING_GAME_ID.equals(games.getGameId())){//大圣传奇
//            templateRoot = templateRoot + "_" + games.getGameNo();
//        }

        htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
        if (htmlFilePath.endsWith("/")) {
            htmlFilePath = htmlFilePath.substring(0, htmlFilePath.length() - 1);
        }

        if(games.getGameNo() != "xyd"){//侠义道
            executeWebGameTemplate();
        }else{
            executeClientGameTemplate();
        }

        buildArticleList(games);
	}
	
	
	
	/**
	 * 官网定制化需求
	 * @param rootMap
	 */
	private void specialModuleTemplate(Map<String, Object> rootMap,String htmlFilePath){
		String versionId = version.getVersionNo();
		LinkInfo query = new LinkInfo();
		query.setLinklocid("824");
		query.setExt2(versionId);
		List<LinkInfo> linkInfoList = FacadeFactory.INSTANCE.getLinkInfoBo().find(query);
		if(CollectionUtils.isEmpty(linkInfoList)){//按默认的模版
			defaultModule(rootMap,htmlFilePath);
		}else{//按定制的模版
			List<LinkInfo> moduleFiles = getModuleFiles();
			if(CollectionUtils.isEmpty(moduleFiles)){
				defaultModule(rootMap,htmlFilePath);
			}else{
				indexIntroModName = moduleFiles.get(0).getExt2();//文件名
				List<LinkInfo> roleList = getRoles();
				if(CollectionUtils.isEmpty(roleList)){
					defaultModule(rootMap,htmlFilePath);
				}else{
					List<Map<String,Object>> result = getResult(rootMap,roleList);
					rootMap.put("roleShowList", result);
					List<String> fileList = getFiles(moduleFiles,linkInfoList);					
					for(String file:fileList){
				        FreemarkerUtil.buildHtml(templateRoot + "/include", file, rootMap,
				        		htmlFilePath + "/include", file);
					}
				}			
			}
		}
	}
	
	private List<Map<String,Object>> getResult(Map<String, Object> rootMap,List<LinkInfo> roleList){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		for(LinkInfo role:roleList){
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("name", role.getLinktitle());
			map.put("partnerList",getPartnerList(role.getDisplaysort(),"001"));	
			result.add(map);
		}
		return result;
	}
	
	private List<LinkInfo> getRoles(){
		LinkInfo query = new LinkInfo();
		query.setLinklocid("826");
		query.setGameid(games.getGameId());
		Page page = new Page();
		page.addOrder("displaysort", OrderType.ESC);
		return FacadeFactory.INSTANCE.getLinkInfoBo().find(query,page);
	}
	
	//模版按大天使的模版
	private void defaultModule(Map<String, Object> rootMap,String htmlFilePath){
	    FreemarkerUtil.buildHtml(templateRoot + "/include", "index_intro_video_role.shtml", rootMap,
	    		htmlFilePath + "/include", "index_intro_video_role.shtml");
	}
	
	private List<String> getFiles(List<LinkInfo> moduleFiles,List<LinkInfo> linkInfoList){
		List<String> list = new ArrayList<String>(linkInfoList.size());
		for(LinkInfo info:linkInfoList){
			for(LinkInfo minfo:moduleFiles){
				if(info.getExt1().trim().equals(minfo.getExt1())){
					list.add(minfo.getExt2());
				}
			}
		}
		return list;
	}
	

	private List<LinkInfo> getModuleFiles(){
		LinkInfo query = new LinkInfo();
		query.setLinklocid("825");
		return FacadeFactory.INSTANCE.getLinkInfoBo().find(query);
	}
	
    private void executeWebGameTemplate(){
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("headMap", getHeadData());// 获取头部信息
        rootMap.put("gameofficial", getGameOfficialInfo());// 获取游戏信息
        rootMap.put("hasRank", "no");// 是否存在排行榜；yes/no，排行榜是否有数据
        rootMap.put("recommendServerMap", getRecommendServerMap());// 获取排行榜信息
        rootMap.put("friendLinkList", getFriendLinkList());// 获取友情链接
        rootMap.put("sliderImgList", getsliderImgList("248"));
        rootMap.put("sliderImgList2", getsliderImgList("285"));
        rootMap.put("gameListMap", getHeaderGames());
        rootMap.put("gamePicList", getgamePicList());// 获取游戏图片
        rootMap.put("topAdMap", getTopAdMap());// 中间小图 + 大图
        rootMap.put("vedioMap", getVedioMap());// 中间视频
        //rootMap.put("partnerList", getPartnerList(0,"001"));// 伙伴展示
        rootMap.put("cooperateMediaList", getCooperateMediaList());// 合作媒体
        rootMap.put("startGameMap", getStartGameMap());// 开始游戏按钮
        rootMap.put("recGongLueList", getRecGongLueList(games.getGameId()));// 推荐攻略
        rootMap.put("allPartnerList", getAllPartnerList());// 可配置的伙伴展示
        rootMap.put("putOnRecord", getPutOnRecord());// 获得备案信息
        
        rootMap.put("teseList", getArticleList("tese", 8));// 特色玩法
        rootMap.put("gaoshouList", getArticleList("gaoshou", 8));// 高手进阶
        rootMap.put("xinshouList", getArticleList("xinshou", 8));// 新手指引
        rootMap.put("zhongjiList", getArticleList("zhongji", 8));// 新手指引
        rootMap.put("gonglueList", getArticleList("gonglue", 9));// 游戏攻略
        rootMap.put("huodongList", getArticleList("huodong", 6));// 活动
        rootMap.put("gonggaoList", getArticleList("gonggao", 6));// 活动
        rootMap.put("newsList", getArticleList("news", 6));// 新闻
        rootMap.put("bbsList", getArticleList("luntan", 8));// 论坛
        rootMap.put("topImg", gettopImgMap());//
        rootMap.put("footerImgList", getFooterImgList());
        rootMap.put("indexLeftTopAdv", getIndexLeftTopAdv());
        rootMap.put("exADList", getMiddleAdv());
        List<Map<String, String>> rightTopAdvList = getRightTopAdv();
        rootMap.put("AD1Map", (rightTopAdvList.size() > 0) ? rightTopAdvList.get(0) : null);
        rootMap.put("AD2Map", (rightTopAdvList.size() > 1) ? rightTopAdvList.get(1) : null);
        rootMap.put("AD3Map", (rightTopAdvList.size() > 2) ? rightTopAdvList.get(2) : null);
        rootMap.put("hotArticleMap", gethotArticleMap());
        rootMap.put("zongheList", getZongHeArticleList("zonghe", 6));
        rootMap.put("rankTypeList", getGameRoleSort());
        rootMap.put("gameList", getAllGames());// 所有游戏
        rootMap.put("recGameList", getrecGameList());
        rootMap.put("giftIntroduction", getNewCardDesc());// 新手卡介绍
        rootMap.put("giftTpyeList", getNewCardTypeList());// 新手卡类别
        rootMap.put("serverList", getNewCardServerList());// 新手卡游戏分区
        rootMap.put("allNewGameList", getAllGameList());   
        rootMap.put("recommendServerList", getrecommendServerList());//
        rootMap.put("serverPageList", getserverPageList());
        rootMap.put("patchList", getpatchList());
        rootMap.put("downloadList", getdownloadList());
        rootMap.put("clientlunboList", getCliectLunBo());
        initNewCard(rootMap);

        String htmlFilePath1 = htmlFilePath + "/tv3/official/" + games.getGameNo();
        
       // if (!GE_XING_GAME_ID.equals(games.getGameId())){//大圣传奇
        String headPath = "/tv3/include3";
        if("tod".equalsIgnoreCase(this.version.getColorCode())){///tod 
        	headPath = "/tv3/include4";
    	}
        
        	 if("V5".equalsIgnoreCase(this.version.getVersionCode())){////V3外网被简版官网占用了，V5表示游戏官网3.0
        		 FreemarkerUtil.buildHtml( templateRoot + "/include", "header.shtml", rootMap,
                         htmlFilePath + headPath, "header.shtml");
        		  //生成定制化模块模版
        	        specialModuleTemplate(rootMap,htmlFilePath1);
        	        
        	 }else{
        		 FreemarkerUtil.buildHtml( templateRoot + "/include", "header.shtml", rootMap,
                         htmlFilePath + "/tv3/include", "header.shtml");
        	 }      	 
     //   }
        rootMap.put("fadvNo", SpreadInfoProxy.getInstance().getAdvNo(games));
        rootMap.put("indexIntroModName", indexIntroModName);
        
        if("tod".equalsIgnoreCase(this.version.getColorCode())){///tod 
            FreemarkerUtil.buildHtml(templateRoot + "/include", "partner.shtml", rootMap,
                    htmlFilePath1 + "/include", "partner.shtml");
    	}
        FreemarkerUtil.buildHtml(templateRoot + "/include", "footer.shtml", rootMap,
                htmlFilePath1 + "/include", "footer.shtml");
        FreemarkerUtil.buildHtml(templateRoot + "/include", "head.shtml", rootMap,
                htmlFilePath1 + "/include", "head.shtml");
        FreemarkerUtil.buildHtml(templateRoot + "/include", "headresource.shtml", rootMap,
                htmlFilePath1 + "/include", "headresource.shtml");
        FreemarkerUtil.buildHtml(templateRoot + "/include", "main_side.shtml", rootMap,
                htmlFilePath1 + "/include", "main_side.shtml");
        FreemarkerUtil.buildHtml(templateRoot + "/include", "main_top.shtml", rootMap,
                htmlFilePath1 + "/include", "main_top.shtml");
        FreemarkerUtil.buildHtml(templateRoot + "/include", "index0_data.shtml", rootMap,
                htmlFilePath1 + "/include", "index0_data.shtml");
        FreemarkerUtil.buildHtml(templateRoot, "index.shtml", rootMap, htmlFilePath1,
                "index.shtml");
        FreemarkerUtil.buildHtml(templateRoot, "download.shtml", rootMap, htmlFilePath1,
                "download.shtml");
        FreemarkerUtil.buildHtml(templateRoot, "newcard.shtml", rootMap, htmlFilePath1,
                "newcard.shtml");
        FreemarkerUtil.buildHtml(templateRoot, "server.shtml", rootMap, htmlFilePath1,
                "server.shtml");
        FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "duanyou_act.ftl", rootMap, htmlFilePath1
                + "/client/js", "act.js");
        FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "duanyou_act.ftl", rootMap, htmlFilePath
                + "/client/" + games.getGameNo() + "/js", "act.js");
        String jsonStr = JsonObjectUtil.getDataJsonObject(getServerJsList());
        jsonStr = "var GAME_SERVER_INFO=" + jsonStr;
        File file = FileUtil.createFile(htmlFilePath + "/tv3/js/fenqu", games.getGameId() + ".js");
        FileUtil.writeByChar(file, jsonStr);
       
        jsonStr=JsonObjectUtil.getDataJsonObject(getBoxNoticeList());
        file = FileUtil.createFile(htmlFilePath + "/microsite", games.getGameId() + ".cfg");
        FileUtil.writeByChar(file, jsonStr);
    }
  
    private String getSpreadInfoAdvNo(){
    	Spreadinfo query = new Spreadinfo();
    	query.setSpreadTab(games.getGameName()+"官网");
    	query.setAdvNo("官网渠道");
    	Spreadinfo info = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    	if(info == null){
    		
    	}
    	return "";
    }
    
    private List<Map<String,Object>> getAllPartnerList(){
    	List<GameShowCategory> categorys = getGameShowCategorys();
    	List<LinkInfo> linkList = getGameShowCategoryList();
    	List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
    	for(LinkInfo info:linkList){
    		String categoryId = info.getLinktitle();
    		String categoryName = getCategoryName(categoryId,categorys);
    		Map<String,Object> data = new HashMap<String,Object>();
    		data.put("partnerListTitle", categoryName);
    		data.put("partnerList", getPartnerList(0,categoryId));
    		result.add(data);
    	}
    	return result;
    }
    
    private String getCategoryName(String categoryId,List<GameShowCategory> categorys){
    	for(GameShowCategory gsc:categorys){
    		if(gsc.getCategoryId().equals(categoryId)){
    			return gsc.getCategoryName();
    		}
    	}
    	return "";
    }
    
    private List<Advice> getAdvices(){
    	Advice query = new Advice();
    	query.setAdviceType("3");
    	query.setPlatformno("huoban");
    	return FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
    }
    
    private List<GameShowCategory> getGameShowCategorys(){
    	return FacadeFactory.INSTANCE.getBaseSo().findObjects(new GameShowCategory(), new Page());
    }
    
    private List<LinkInfo> getGameShowCategoryList(){
    	LinkInfo query = new LinkInfo();
    	query.setLinklocid("827");
    	query.setGameid(games.getGameId());
    	Page page = new Page();
    	page.addOrder("displaysort", OrderType.ESC);
    	List<LinkInfo> linkList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
    	return linkList;
    }
    
    
    private Map<String,String> getStartGameMap(){
	    	Map<String,String> result = new HashMap<String,String>();
	    	List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
					.getGameValidteLinkInfoListByLinkLocId_v2("820", games.getGameId(), 1, isPreView);
	    	if(CollectionUtils.isEmpty(lilist)) return result;
	    	LinkInfo info = lilist.get(0);
	    	String bigSrc = info.getPicurl();
	    	result.put("src", bigSrc);
	    	if(StringTools.isEmpty(info.getExt2())){
	    		result.put("pwidth",defaultWidth+"");
		    	result.put("pheight", defaultHeight+"");
	    	}else{
	    		result.put("pwidth", info.getExt2());
		    	result.put("pheight", info.getExt3());
	    	}
	    	 if(bigSrc.endsWith(".swf")){
	    		result.put("type", "flash");
	    	}else{
	    		result.put("type", "img");
	    	}    		  
	    	return result;
    }
    
    /**
	 * 获得所有游戏信息
	 * @return
	 */
	private List<Map<String,Object>> getAllGameList(){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		Games query = new Games();
		query.setStatus("1");//只展示已经接入的游戏
		Page page = new Page();
		page.addOrder("gameType", OrderType.DESC);
		page.addOrder("recommendIndex", OrderType.DESC);
		List<Games> games = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		Set<String> set = new TreeSet<String>();
		for(Games game:games){
			set.add(game.getGameType());
		}
		HashMap<String,String> gameTypeMap =  getGameCategory();
		Object gameTypes [] = (Object [])set.toArray();
		for(Object type:gameTypes){
			String gameType = (String)type;
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("gameTypeId", gameType);			
			map.put("gameType", gameTypeMap.get(gameType));
			List<Map<String,Object>> gameList = new ArrayList<Map<String,Object>>();
			for(Games game:games){
				if(game.getClientType().intValue()==3)continue;//去掉手游
				if(gameType.equals(game.getGameType())){
					Map<String,Object> gameMap = new HashMap<String,Object>();
					gameMap.put("gameName", game.getGameName());
					gameMap.put("gameOfficalUrl", game.getOfficialWebSite());
					gameMap.put("isHot", game.getIsHot()?1:0);
					gameMap.put("isNew", game.getIsNew()?1:0);
					gameList.add(gameMap);
				}
			}
			map.put("gameList", gameList);
			map.put("gameNum", gameList.size());
			result.add(map);
		}
		return result;
	}
    
	
	public HashMap<String,String> getGameCategory(){
        List datas = LibClassM.getLibClassDList("gamecategory");
        if(gameCategoryMap== null){
        	HashMap<String,String> tempMap = new HashMap<String,String>();
              for(int i = 0; i < datas.size(); i++){
            	  tempMap.put(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname()); 	
              }	   
              gameCategoryMap = tempMap; 
        }                       
		       
		    return gameCategoryMap;
	  }

	
    /**
     * 中间 小素材 + 大素材
     * @return
     */
    private Map<String,String> getTopAdMap(){
    	Map<String,String> result = new HashMap<String,String>();
    	List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("286", games.getGameId(), 1, isPreView);
    	if(CollectionUtils.isEmpty(lilist)) return result;
    	LinkInfo info = lilist.get(0);
    	String smallSrc = info.getSmallpicurl();
    	String bigSrc = info.getPicurl();
    	result.put("smallSrc", smallSrc);
    	result.put("url", info.getLinkurl());
    	 if(smallSrc.endsWith(".swf")){
    		result.put("smallType", "flash");
    	}else{
    		result.put("smallType", "img");
    	}    	
    	result.put("bigSrc", bigSrc);
    	 if(bigSrc.endsWith(".swf")){
    		result.put("bigType", "flash");
    	}else{
    		result.put("bigType", "img");
    	}
    	return result;
    }
    
    
    private List<Map<String,String>> getRecGongLueList(String gameId){
    	List<Map<String,String>> list = new ArrayList<Map<String,String>>();  	
    	LinkInfo query = new LinkInfo();
    	query.setLinklocid("288");
    	query.setIsvalid(true);
    	query.setGameid(gameId);
    	Page page =new Page();
    	page.addOrder("validdatetime", OrderType.DESC);
    	List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(query, page);
    	if(CollectionUtils.isEmpty(lilist)) return list;
    	for(LinkInfo info :lilist){
    		Map<String,String> map = new HashMap<String,String>();
    		map.put("title", info.getLinktitle());    
    		map.put("url",info.getLinkurl());
    		map.put("img",info.getPicurl());
        	list.add(map);
    	}
    	return list;
    }
    
    private List<Map<String,String>> getCooperateMediaList(){
    	List<Map<String,String>> list = new ArrayList<Map<String,String>>();  	
    	List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId("822", games.getGameId(), 20, false);
    	if(CollectionUtils.isEmpty(lilist)) return list;
    	for(LinkInfo info :lilist){
    		Map<String,String> map = new HashMap<String,String>();
    		map.put("title", info.getLinktitle());    
    		map.put("url",info.getLinkurl());
        	list.add(map);
    	}
    	return list;
    }
    
    
    private Map<String,String> getVedioMap(){
    	Map<String,String> result = new HashMap<String,String>();
    	List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("287", games.getGameId(), 1, isPreView);
    	if(CollectionUtils.isEmpty(lilist)) return result;
    	LinkInfo info = lilist.get(0);
    	String smallSrc = info.getSmallpicurl();
    	String bigSrc = info.getPicurl();
    	result.put("img", smallSrc);    
    	result.put("src",bigSrc);
    	return result;
    }
    
    
    private String getBottomPhoto(){
    	List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("821", games.getGameId(), 1, isPreView);
    	if(CollectionUtils.isEmpty(lilist)) return "";
    	LinkInfo info = lilist.get(0);
    	return info.getPicurl();
    }
    
    
    private void executeClientGameTemplate(){
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("gonggaoList", getArticleList("", 8));// 活动

        String htmlFilePath1 = htmlFilePath + "/tv3/official/" + games.getGameNo();

        String indexFileName = "";
        if(games.getGameNo().equals("xyd")){
            indexFileName = "index.html";
        }else {
            indexFileName = "index.shtml";
        }

        FreemarkerUtil.buildHtml(templateRoot, "index.shtml", rootMap, htmlFilePath1,
                indexFileName);
    }

	public List<Map<String, String>> getGameRoleSort() {
		List<Map<String, String>> list = new ArrayList<Map<String, String>>();
		List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("274", games.getGameId(), 20, isPreView);
		for (LinkInfo li : lilist) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("id", li.getExt3() == null ? "" : li.getExt3());
			map.put("text", li.getLinktitle() == null ? "" : li.getLinktitle());
			map.put("item1", li.getExt1() == null ? "" : li.getExt1());
			map.put("item2", li.getExt2() == null ? "" : li.getExt2());
			list.add(map);
		}
		return list;
	}

	private static Map<String,List<Map<String,String>>> getHeaderGames(){
		Map<String,List<Map<String,String>>> map = new TreeMap<String,List<Map<String,String>>>();
		Games games = new Games();
		games.setStatus("1");//已接入的游戏
		Page page = new Page();
		page.addOrder("simpleName", OrderType.ESC);
		List<Games> gameslist = FacadeFactory.INSTANCE.getGamesBo().findGames(games, page);
		for(int i=(int)'A';i<'A'+26;i++){
			char ch = (char)i;
			List<Map<String,String>> list = new ArrayList<Map<String,String>>();
			for(Games game:gameslist){
				if(game.getClientType().intValue()==3)continue;//屏蔽掉手游
				String  simpleName = game.getSimpleName();
				simpleName = simpleName.substring(0,1);//首字母
				if(simpleName.equalsIgnoreCase(""+ch)){
					Map<String,String> gmap = new HashMap<String,String>();
					gmap.put("gameId", game.getGameId());
					gmap.put("name", game.getGameName());
					gmap.put("gameNo", game.getGameNo());
					gmap.put("url", game.getOfficialWebSite());
					list.add(gmap);
				}
			}
			map.put(ch+"", list);
		}
		
		return map;
	}
	
	
	/**
	 * 获取轮播图
	 * 
	 * @return
	 */
	private List<Map<String, String>> getsliderImgList(String linklocId) {
		List<Map<String, String>> list = new ArrayList<Map<String, String>>();
		List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2(linklocId, games.getGameId(), 6, isPreView);
		for (LinkInfo li : lilist) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("url", li.getLinkurl());
			map.put("img", li.getPicurl());
			list.add(map);
		}
		return list;
	}

	private Map<String, String> gethotArticleMap() {
		Map<String, String> hotArticleMap = new HashMap<String, String>();
		LinkInfo li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("259",
				games.getGameId(), isPreView);
		if (li == null) {
			return null;
		}
		hotArticleMap.put("url", li.getLinkurl() == null ? "" : li.getLinkurl());
		hotArticleMap.put("title", li.getLinktitle() == null ? "" : li.getLinktitle());
		hotArticleMap.put("isColor", li.getIsredtitle() ? "yes" : "no");
		hotArticleMap.put("isStrong", li.getIsboldtitle() ? "yes" : "no");

        hotArticleMap.put("subTitle", li.getExt1() == null ? "" : li.getExt1());
        hotArticleMap.put("img", li.getPicurl() == null ? "" : li.getPicurl());
        return hotArticleMap;
	}

	private Map<String, String> getRecommendServerMap() {
		LinkInfo li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("240",
				games.getGameId(), isPreView);
		String fenQuNum = (li == null) ? "" : li.getExt1() + "";
		String fenQuName = "";
		if (!"".equals(fenQuNum)) {
			GameServers qgs = new GameServers();
			qgs.setGameId(games.getGameId());
			qgs.setFenQuNum(Integer.valueOf(fenQuNum));
			List<GameServers> list = FacadeFactory.INSTANCE.getGameServersBo().findGameServers(qgs, 1, 1);
			if (list != null&&list.size()>0) {
				GameServers gs = list.get(0);
				fenQuName = gs.getFenQuName();
			}
		}
		Map<String, String> recommendServerMap = new HashMap<String, String>();
		recommendServerMap.put("serverId", (li == null) ? "" : li.getExt1() + "");
		recommendServerMap.put("serverName", fenQuName);
		return recommendServerMap;
	}

	/**
	 * 获取右上角的广告位
	 * 
	 * @return
	 */
	private List<Map<String, String>> getRightTopAdv() {
		List<Map<String, String>> advList = new ArrayList<Map<String, String>>();
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("246", games.getGameId(), 3, isPreView);
		for (int i = 0; i < list.size(); i++) {
			LinkInfo li = list.get(i);
			Map<String, String> map = new HashMap<String, String>();
			map.put("url", li.getLinkurl() + "");
			map.put("img", li.getPicurl() + "");
			map.put("imgHover", li.getSmallpicurl()+"");
			advList.add(map);
		}
		return advList;
	}

	/**
	 * 获取中间的广告位
	 * 
	 * @return
	 */
	private List<Map<String, String>> getMiddleAdv() {
		List<Map<String, String>> advList = new ArrayList<Map<String, String>>();
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("247", games.getGameId(), 100, isPreView);
		for (int i = 0; i < list.size(); i++) {
			LinkInfo li = list.get(i);
			Map<String, String> map = new HashMap<String, String>();
			map.put("url", li.getLinkurl() + "");
			map.put("img", li.getPicurl() + "");
			advList.add(map);
		}
		return advList;
	}

	/**
	 * 获取头部数据
	 * 
	 * @return
	 */
	private synchronized Map<String, String> getHeadData() {
		Map<String, String> headMap = new HashMap<String, String>();
		headMap.put("gameId", games.getGameId());
		headMap.put("gameNo", games.getGameNo());
		headMap.put("gameName", games.getGameName());
		headMap.put("gameBBSUrl", games.getForumUrl() + "");// 论坛地址
		headMap.put("gameOfficial", games.getOfficialWebSite() + "");// 论坛地址
		GameVersion queryGameVersion=new GameVersion();
		queryGameVersion.setGameId(schema.getExt1());
		GameVersion gameVersion=FacadeFactory.INSTANCE.getBaseSo().findObject(queryGameVersion);
		if(gameVersion==null){
			throw new RuntimeException("未选择游戏官网版本");
		}
		VersionInfo versionInfo=FacadeFactory.INSTANCE.getVersionInfoBo().find(gameVersion.getVersionNo());
		if(versionInfo==null){
			throw new RuntimeException("游戏官网版本["+gameVersion.getVersionNo()+"]不存在");
		}
		this.version = versionInfo;
		// 设置颜色
		if(schema.getExt2()==null||"".equals(schema.getExt2())){			
			headMap.put("skin", versionInfo.getColorCode());
		}else{
			headMap.put("skin", schema.getExt2() + "");
		}		
		headMap.put("ftImg",getBottomPhoto());
		
		// 获取关键字
		LinkInfo linkinfo = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(
				LinkLocationIdConstant.GAME_OFFICIAL_KEYWORD, games.getGameId(), isPreView);
//		headMap.put("title",
//				(linkinfo == null || linkinfo.getLinktitle() == null) ? "" : linkinfo.getLinktitle());
//		headMap.put("description",
//				(linkinfo == null || linkinfo.getLinkdesc() == null) ? "" : linkinfo.getLinkdesc());
//		headMap.put("keywords", (linkinfo == null || linkinfo.getExt1() == null) ? "" : linkinfo.getExt1());
		String title = getContent(linkinfo,1);
        System.out.println("====================title:"+title);
		headMap.put("title",title);
		headMap.put("keywords",getContent(linkinfo,2));
		headMap.put("description",getContent(linkinfo,3));
		LinkInfo li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("255",
				games.getGameId(), isPreView);
        String bgImg = (li == null || li.getPicurl() == null) ? "" : li.getPicurl();
		headMap.put("bgImg", bgImg);
        if(bgImg.endsWith(".swf")){
            headMap.put("bgType","flash");
        }else {
            headMap.put("bgType","img");
        }
		headMap.put("bgColor", (li == null || li.getExt1() == null) ? "" : li.getExt1());
		PageStatisticsJs psjs = getStatisticsJsNo(games.getGameId());
		headMap.put("gsid", (psjs == null || psjs.getStatisticsId() == null) ? "" : psjs.getStatisticsId());
		headMap.put("baiduId", (psjs == null || psjs.getBaiDuId() == null) ? "" : psjs.getBaiDuId());
		// 获取背景图片
		return headMap;
	}
	
	private String getContent(LinkInfo linkinfo ,int type){
		if(linkinfo == null) {
			switch(type){
			    case 1:return seo_title.replaceAll("gameName", games.getGameName());
			    case 2:return seo_keywords.replaceAll("gameName", games.getGameName()); 
			    case 3:return seo_description.replaceAll("gameName", games.getGameName()); 
			}
		}else{
			switch(type){
			    case 1:return (linkinfo.getLinktitle() == null) ? "" : linkinfo.getLinktitle(); 
			    case 2:return (linkinfo.getExt1() == null) ? "" : linkinfo.getExt1(); 
			    case 3:return (linkinfo.getLinkdesc() == null) ? "" : linkinfo.getLinkdesc(); 
		    }
		}
		return "";
	}

	private List<Map<String, String>> getZongHeArticleList(String type, int limitNum) {
		List<Map<String, String>> articleList = new ArrayList<Map<String, String>>();
		Advice advice = new Advice();
		advice.setAdviceType("3");
		advice.setExt1(type);
		advice.setGameId(games.getGameId());
		advice.setLePublishDate(sdf.format(new Date()));
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(limitNum);
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		String nowStr=sdf.format(new Date());
		List<Advice> adviceList = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
		for (Advice ad : adviceList) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("type", ad.getPlatformno());
			map.put("url", ad.getJumpUrl() == null ? "" : ad.getJumpUrl());
			map.put("aid", ad.getSeqId() + "");
			map.put("title", formatTitle(ad.getTitle()));
            boolean isRemoveRedBold=false;
            if(StringUtils.isNotEmpty(ad.getRemoveFlagTime())){
                isRemoveRedBold=nowStr.compareTo(ad.getRemoveFlagTime())>=0;
            }
			map.put("isColor", ad.getRed()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("isStrong", ad.getBold()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("date", ad.getPublishDate().substring(5, 10));
			articleList.add(map);
		}
		return articleList;
	}
	private List<Map<String,String>> getBoxNoticeList(){
    	List<Map<String,String>> tempMapList=getZongHeArticleList("zonghe", 5);
    	List<Map<String,String>> mapList=new ArrayList<Map<String,String>>();
    	for(int i=0;i<tempMapList.size();i++){
    		Map<String,String> tempMap=tempMapList.get(i);
    		Map<String,String> map=new HashMap<String,String>();
    		map.put("adtype", tempMap.get("type").equals("gonggao")?"3":"2");
    		try {
				map.put("title", URLEncoder.encode(tempMap.get("title"),"UTF-8"));
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException(e);
			}
    		map.put("pageurl", tempMap.get("url").replace("/a/", "/gamebox/"));
    		map.put("adddate", tempMap.get("date"));
    		map.put("opentype", "1");
    		if(i==0){
    			map.put("adtype", "1");
    		}
    		mapList.add(map);
    	}
    	return mapList;
	}
	/**
	 * 获取文章
	 * 
	 * @param articleType
	 * @param limitNum
	 * @return
	 */
	private List<Map<String, String>> getArticleList(String articleType, int limitNum) {
		List<Map<String, String>> articleList = new ArrayList<Map<String, String>>();
		Advice advice = new Advice();
		advice.setAdviceType("3");
        if(StringUtils.isNotEmpty(articleType)){
            advice.setPlatformno(articleType);
        }
		advice.setGameId(games.getGameId());
		advice.setLePublishDate(sdf.format(new Date()));
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(limitNum);
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		String nowStr=sdf.format(new Date());
		List<Advice> adviceList = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
		for (Advice ad : adviceList) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("type", ad.getPlatformno());
			map.put("url", ad.getJumpUrl() == null ? "" : ad.getJumpUrl());
			map.put("aid", ad.getSeqId() + "");
			map.put("title", formatTitle(ad.getTitle()));
			boolean isRemoveRedBold=false;
            if(StringUtils.isNotEmpty(ad.getRemoveFlagTime())){
                isRemoveRedBold=nowStr.compareTo(ad.getRemoveFlagTime())>=0;
            }

			map.put("isColor", ad.getRed()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("isStrong", ad.getBold()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("date", ad.getPublishDate().substring(5, 10));
			map.put("hotVlaue", ad.getHotLevel()+"");
			articleList.add(map);
		}
		return articleList;
	}

	private String formatTitle(String title){
		if(StringTools.isEmpty(title))return "";
		return title.replaceAll("\"", "\\\\\"");
	}
	
	
	private List<Map<String, String>> getPartnerList(int displayOrder,String categoryId) {
		List<Map<String, String>> articleList = new ArrayList<Map<String, String>>();
		Advice advice = new Advice();
		advice.setAdviceType("3");
        advice.setPlatformno("huoban");
        if(displayOrder!=0)
           advice.setDisplayOrder(displayOrder);
        if(!StringTools.isEmpty(categoryId)){
        	advice.setRemark(categoryId);
        }
		advice.setGameId(games.getGameId());
		Page page = new Page();
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		List<Advice> adviceList = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
		for (Advice ad : adviceList) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("img", ad.getPhoto());
			map.put("content", ad.getContent());
			map.put("title", formatTitle(ad.getTitle()));
			map.put("link", ad.getRemark());
			articleList.add(map);
		}
		return articleList;
	}
	
	/**
	 * 获取游戏信息
	 * 
	 * @return
	 */
	private Map<String, String> getGameOfficialInfo() {
		Map<String, String> gameofficialMap = new HashMap<String, String>();
		gameofficialMap.put("orderUrl", games.getPayUrl() + "");
		gameofficialMap.put("gameIntroduction", games.getGameDesc() + "");
		gameofficialMap.put("kfUrl", games.getForumUrl());
		LinkInfo li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("241",
				games.getGameId(), isPreView);
		if (li == null) {
			gameofficialMap.put("kfTelephone", "");// 客服电话
			gameofficialMap.put("kfOtherInfo", "");// 客服qq
			gameofficialMap.put("kfFaceImg", "");
		} else {
			gameofficialMap.put("kfTelephone", li.getExt1() + "");// 客服电话
			gameofficialMap.put("kfOtherInfo", li.getLinkcontents() + "");// 客服qq
			gameofficialMap.put("kfFaceImg", li.getPicurl());
		}
		
		// 后去logo
		LinkInfo lilogo = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("254",
				games.getGameId(), isPreView);
		gameofficialMap.put("logo", (lilogo == null) ? "" : lilogo.getPicurl());
		return gameofficialMap;
	}

	/**
	 * 获取游戏图片
	 * 
	 * @return
	 */
	private List<Map<String, Object>> getgamePicList() {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		Map<String, Object> map1 = new HashMap<String, Object>();
		List<Map<String, String>> list1 = getGamePicList("242", 20);
		if (list1.size() > 0) {
			map1.put("typeName", games.getGameName()+"原画");
			map1.put("picList", list1);
			list.add(map1);
		}

		List<Map<String, String>> list2 = getGamePicList("243", 20);
		if (list2.size() > 0) {
			Map<String, Object> map2 = new HashMap<String, Object>();
			map2.put("typeName", "游戏截图");
			map2.put("picList", list2);
			list.add(map2);
		}

		List<Map<String, String>> list3 = getGamePicList("244", 20);
		if (list3.size() > 0) {
			Map<String, Object> map3 = new HashMap<String, Object>();
			map3.put("typeName", "玩家美图");
			map3.put("picList", list3);
			list.add(map3);
		}
		return list;
	}

	/**
	 * 获取游戏图片-单种
	 * 
	 * @param linklocId
	 * @param num
	 *            数量
	 * @return
	 */
	private List<Map<String, String>> getGamePicList(String linklocId, int num) {
		List<Map<String, String>> list = new ArrayList<Map<String, String>>();
		List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2(linklocId, games.getGameId(), num, isPreView);
		for (LinkInfo li : lilist) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("bigImg", li.getPicurl() + "");
			map.put("smallImg", li.getSmallpicurl());
			list.add(map);
		}
		return list;
	}

	/**
	 * 获取友情链接
	 * 
	 * @return
	 */
	private List<Map<String, String>> getFriendLinkList() {
		List<Map<String, String>> friendLinkList = new ArrayList<Map<String, String>>();
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId(
				"303", games.getGameId(), 100, isPreView);
		for (LinkInfo li : list) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("url", li.getLinkurl() + "");
			map.put("title", li.getLinktitle() + "");
			map.put("picurl", li.getPicurl() + "");
			friendLinkList.add(map);
		}
		return friendLinkList;
	}

	private List<Map<String, String>> getAllGames() {
		List<Map<String, String>> allGameList = new ArrayList<Map<String, String>>();
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("203",
				500, isPreView);
		for (LinkInfo li : list) {
			Games game = GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			if (game == null) {
				continue;
			}
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", game.getGameName());
			map.put("url", game.getOfficialWebSite());
			allGameList.add(map);
		}
		return allGameList;
	}

	private List<Map<String, String>> getrecGameList() {
		List<Map<String, String>> recGameList = new ArrayList<Map<String, String>>();
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("249", games.getGameId(), 3, isPreView);
		for (LinkInfo li : list) {
			Games game = GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			if (game == null) {
				continue;
			}
			Map<String, String> map = new HashMap<String, String>();
			map.put("url", game.getOfficialWebSite());
			map.put("img", li.getPicurl());
			map.put("name", game.getGameName());
			recGameList.add(map);
		}
		return recGameList;
	}

	private List<Map<String, String>> getNewCardTypeList() {
		List<Map<String, String>> newCardTypeList = new ArrayList<Map<String, String>>();
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("251", games.getGameId(), 20, isPreView);
		for (LinkInfo li : list) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("id", li.getLinkid() + "");
			map.put("name", li.getLinktitle());
			newCardTypeList.add(map);
		}
		return newCardTypeList;
	}

	private String getNewCardDesc() {
		LinkInfo li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("250",
				games.getGameId(), isPreView);
		return (li == null) ? "" : changeHtmlPic(li.getLinkcontents());
	}
	private void initNewCard(Map<String,Object> root){
		LinkInfo li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("250",
				games.getGameId(), isPreView);
		root.put("isHidePlayGameButton", (li==null||li.getExt1()==null||"".equals(li.getExt1()))?"1":li.getExt1());
		root.put("playGameUrl", (li==null||li.getLinkurl()==null||"".equals(li.getLinkurl())?"":li.getLinkurl()));
	}
	private List<Map<String, String>> getNewCardServerList() {
		List<Map<String, String>> serverList = new ArrayList<Map<String, String>>();
		GameServers gs = new GameServers();
		gs.setGameId(games.getGameId());
		Page page = new Page();
        page.addOrder("openTime", OrderType.DESC);
		page.addOrder("fenQuNum", OrderType.DESC);
		List<GameServers> list = FacadeFactory.INSTANCE.getGameServersBo().find(gs, page);
		for (GameServers tgs : list) {
			if ("0".equals(tgs.getOpenStatus()) || "2".equals(tgs.getOpenStatus())) {
				continue;
			}
			Map<String, String> map = new HashMap<String, String>();
			map.put("sid", tgs.getServerId());
			map.put("name", tgs.getFenQuName());
			map.put("fid", tgs.getFenQuNum() + "");
			map.put("flag", tgs.getOpenStatus());
			serverList.add(map);
		}
		return serverList;
	}

	private List<Map<String, String>> getrecommendServerList() {
		List<Map<String, String>> recommendServerList = new ArrayList<Map<String, String>>();
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("240", games.getGameId(), 2, isPreView);
		for (LinkInfo li : list) {
			String fenQuNum = li.getExt1();
			GameServers qgs = new GameServers();
			qgs.setGameId(games.getGameId());
			qgs.setFenQuNum(Integer.valueOf(fenQuNum));
			List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().findGameServers(qgs, 1, 1);
			if (gsList == null || gsList.size() == 0) {
				continue;
			}
			GameServers gs = gsList.get(0);
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", gs.getFenQuName());
			map.put("id", gs.getFenQuNum() + "");
			map.put("flag", "1");
			recommendServerList.add(map);
		}
		return recommendServerList;
	}

	private List<Map<String, String>> getServerJsList() {
		List<Map<String, String>> serverList = new ArrayList<Map<String, String>>();
		GameServers qgs = new GameServers();
		qgs.setGameId(games.getGameId());
		Page page = new Page();
        page.addOrder("openTime", OrderType.DESC);
		page.addOrder("fenQuNum", OrderType.DESC);
		List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page);
		gsList = gsList == null ? new ArrayList<GameServers>() : gsList;
		for (GameServers tgs : gsList) {
			if ("0".equals(tgs.getOpenStatus())) {
				continue;
			}
			if ("2".equals(tgs.getOpenStatus())) {
				continue;
			}
			String flag = "";
			if ("1".equals(tgs.getOpenStatus())) {
				flag = "2";// 顺畅
			} else if ("3".equals(tgs.getOpenStatus())) {
				flag = "4";// 维护中
			} else if ("4".equals(tgs.getOpenStatus())) {
				flag = "3";// 测试中，表示即将开始
			}
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", tgs.getFenQuName());
			map.put("id", tgs.getFenQuNum() + "");
			map.put("flag", flag);
			map.put("serverId", tgs.getServerId() + "");
			//isNew状态有BUG，可能会出现多个isNew都为1.改为根据开区时间来生成。
			map.put("isNew", (tgs.getIsnew()!=null&&tgs.getIsnew()==true)?"1":"0");
			serverList.add(map);
		}
		// 判断是否是推荐的服务器
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("240", games.getGameId(), 500, isPreView);
		Set<String> set = new HashSet<String>();
		for (LinkInfo li : list) {
			set.add(li.getExt1());
		}
		for (Map<String, String> tmap : serverList) {
			if (!"2".equals(tmap.get("flag"))) {
				continue;
			}
			if (set.contains(tmap.get("id"))) {
				tmap.put("flag", "1");
			}
		}
		// 判断测试的公告
		List<LinkInfo> ceshiList = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("252", games.getGameId(), 500, isPreView);
		Map<String, LinkInfo> ceshimap = new HashMap<String, LinkInfo>();
		for (LinkInfo li : ceshiList) {
			ceshimap.put(li.getExt1() + "", li);
		}
		// 判断维护公告
		List<LinkInfo> weihuList = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("253", games.getGameId(), 500, isPreView);
		Map<String, LinkInfo> weihumap = new HashMap<String, LinkInfo>();
		for (LinkInfo li : weihuList) {
			weihumap.put(li.getExt1() + "", li);
		}
		for (Map<String, String> tmap : serverList) {
			if ("3".equals(tmap.get("flag"))) {
				LinkInfo li = ceshimap.get(tmap.get("id"));
				tmap.put("date", (li == null || li.getExt2() == null) ? "" : formatTime(li.getExt2()));
				tmap.put("url", (li == null || li.getLinkurl() == null) ? "" : li.getLinkurl());
			} else if ("4".equals(tmap.get("flag"))) {
				LinkInfo li = weihumap.get(tmap.get("id"));
				tmap.put("date",
						(li == null || li.getExt2() == null || li.getExt3() == null) ? "" : formatTime(li.getExt2())
								+ "到" + formatTime(li.getExt3()));
				tmap.put("url", (li == null || li.getLinkurl() == null) ? "" : li.getLinkurl());
			}
		}
		return serverList;
	}

	private void buildArticleList(Games game) {
		int pageSize = 20;

    	if("tod".equalsIgnoreCase(this.version.getColorCode())){///tod 12条
    		pageSize = 12;
    	}
    	
        if(game.getGameNo().equals("xyd")){
            buildArticleList("zonghe", pageSize, false,true);
        }else{
            buildArticleList("zonghe", pageSize, false,true);
            buildArticleList("gonggao", pageSize, true,true);
            buildArticleList("huodong", pageSize, true,true);
            buildArticleList("gonglue", pageSize, true,true);
            if("V5".equalsIgnoreCase(this.version.getVersionCode())){////V3外网被简版官网占用了，V5表示游戏官网3.0
            	  buildArticleList("ziliao", pageSize, false,false);//不需分页
            }else{
            	buildArticleList("ziliao", pageSize, false,true);
            }         
            buildArticleList("xinshou", pageSize, true,true);
            buildArticleList("zhongji", pageSize, true,true);
            buildArticleList("gaoshou", pageSize, true,true);
            buildArticleList("tese", pageSize, true,true);
            buildArticleList("luntan", pageSize, true,true);
        }

	}

	/**
	 * 
	 * @param type  文章类型
	 * @param pageSize 每页数据
	 * @param isSingle 
	 * @param isPage 是否需要分页
	 */
	private void buildArticleList(String type, int pageSize, boolean isSingle,boolean isPage) {
	   if(games.getClientType() == 2 && games.getGameNo().equals("xyd")){
            templateRoot = templateRoot + "/" + games.getGameNo();
        }
        String htmlFilePath1 = htmlFilePath + "/tv3/official/" + games.getGameNo();
		int zonghecount = buildArticleListCount(type, isSingle);
		int count = zonghecount / pageSize;
		if (zonghecount % pageSize > 0) {
			count++;
		}
		if (count == 0) {
			count = 1;
		}
		if(isPage){//如果需要分页
			for (int page = 0; page < count; page++) {
				List<Map<String, String>> list = buildArticleList(page + 1, pageSize, type, isSingle);
				Map<String, Object> listInfoMap = new HashMap<String, Object>();
				listInfoMap.put("typeId", type);
				listInfoMap.put("list", list);
				Map<String, Integer> pageInfoMap = new HashMap<String, Integer>();
				pageInfoMap.put("cur", (page + 1));
				pageInfoMap.put("total", count);
				Map<String, Object> root = new HashMap<String, Object>();
				root.put("listInfoMap", listInfoMap);
				root.put("pageInfoMap", pageInfoMap);
				root.put("headMap", getHeadData());// 获取头部信息
				FreemarkerUtil.buildHtml(templateRoot, "articlelist.shtml", root, htmlFilePath1
						+ "/" + type, (page + 1) + ".shtml");
			}
		}else{
			List<Map<String, String>> list = buildArticleList( 1, 10000, type, isSingle);
			Map<String, Object> listInfoMap = new HashMap<String, Object>();
			listInfoMap.put("typeId", type);
			listInfoMap.put("list", list);
			Map<String, Integer> pageInfoMap = new HashMap<String, Integer>();
			pageInfoMap.put("cur",1);
			pageInfoMap.put("total", count);
			Map<String, Object> root = new HashMap<String, Object>();
			root.put("listInfoMap", listInfoMap);
			root.put("pageInfoMap", pageInfoMap);
			root.put("headMap", getHeadData());// 获取头部信息
			
			LinkInfo li =FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId("289", games.getGameId(), false);
			if(li != null){
				root.put("xinshouLogo", li.getPicurl());
				root.put("gaoshouLogo", li.getExt2());
				root.put("teseLogo", li.getExt3());
			}
			FreemarkerUtil.buildHtml(templateRoot, "articlelist.shtml", root, htmlFilePath1
					+ "/" + type,   "index.shtml");
			
			
		}
		
	}
	
	
	

	private List<Map<String, String>> buildArticleList(int pageNo, int pageSize, String type, boolean isSingle) {
		Advice advice = new Advice();
		advice.setAdviceType("3");
		advice.setGameId(games.getGameId());
		if (isSingle) {
			advice.setPlatformno(type);
		} else {
			advice.setExt1(type);
		}
		advice.setLePublishDate(sdf.format(new Date()));
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
		String nowStr=sdf.format(new Date());
		List<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
		for (Advice ad : list) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("typeId", ad.getPlatformno());
			map.put("aid", ad.getSeqId() + "");
			map.put("title", ad.getTitle());
			map.put("url", ad.getJumpUrl() + "");
			map.put("date", ad.getPublishDate().substring(0, 10));
            boolean isRemoveRedBold=false;
            if(StringUtils.isNotEmpty(ad.getRemoveFlagTime())){
                isRemoveRedBold=nowStr.compareTo(ad.getRemoveFlagTime())>=0;
            }
			
			map.put("isColor", ad.getRed()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("isStrong", ad.getBold()&&isRemoveRedBold==false ? "yes" : "no");
			mapList.add(map);
		}
		return mapList;
	}

	private int buildArticleListCount(String type, boolean isSingle) {
		Advice advice = new Advice();
		advice.setAdviceType("3");
		advice.setGameId(games.getGameId());
		advice.setLePublishDate(sdf.format(new Date()));
		if (isSingle) {
			advice.setPlatformno(type);
		} else {
			advice.setExt1(type);
		}
		return FacadeFactory.INSTANCE.getAdviceBo().count(advice);
	}

	private List<Map<String, Object>> getserverPageList() {
		List<Map<String, String>> serverList = new ArrayList<Map<String, String>>();
		GameServers qgs = new GameServers();
		qgs.setGameId(games.getGameId());
		Page page = new Page();
        page.addOrder("openTime", OrderType.DESC);
		page.addOrder("fenQuNum", OrderType.DESC);
		List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page);
		gsList = gsList == null ? new ArrayList<GameServers>() : gsList;
		for (GameServers tgs : gsList) {
			if ("0".equals(tgs.getOpenStatus())) {
				continue;
			}
			if ("2".equals(tgs.getOpenStatus())) {
				continue;
			}
			String flag = "";
			if ("1".equals(tgs.getOpenStatus())) {
				flag = "2";// 顺畅
			} else if ("3".equals(tgs.getOpenStatus())) {
				flag = "4";// 维护中
			} else if ("4".equals(tgs.getOpenStatus())) {
				flag = "3";// 测试中，表示即将开始
			}
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", tgs.getFenQuName());
			map.put("id", tgs.getFenQuNum() + "");
			map.put("flag", flag);
			serverList.add(map);
		}
		// 判断是否是推荐的服务器
		List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getGameValidteLinkInfoListByLinkLocId_v2("240", games.getGameId(), 500, isPreView);
		Set<String> set = new HashSet<String>();
		for (LinkInfo li : list) {
			set.add(li.getExt1());
		}
		for (Map<String, String> tmap : serverList) {
			if (!"2".equals(tmap.get("flag"))) {
				continue;
			}
			if (set.contains(tmap.get("id"))) {
				tmap.put("flag", "1");
			}
		}

		// 分页
		List<Map<String, Object>> pageServerList = new ArrayList<Map<String, Object>>();
		for (int i = 0; i * 50 < serverList.size(); i++) {
			int from = i * 50;
			int end = from;
			String endFenQuNum = null;
			String fromFenQuNum = null;
			Map<String, Object> map = new HashMap<String, Object>();
			List<Map<String, String>> tlist = new ArrayList<Map<String, String>>();
			for (; end < from + 50 && end < serverList.size(); end++) {
				Map<String, String> tm = serverList.get(end);
				if (endFenQuNum == null) {
					endFenQuNum = tm.get("id");
				}
				fromFenQuNum = tm.get("id");
				tlist.add(tm);
			}

			Map<String, String> pageMap = new HashMap<String, String>();
			pageMap.put("from", fromFenQuNum);
			pageMap.put("to", endFenQuNum);
			map.put("page", pageMap);
			map.put("list", tlist);
			pageServerList.add(map);
		}
		return pageServerList;
	}

	public PageStatisticsJs getStatisticsJsNo(String gameId) {
		PageStatisticsJs psjs = new PageStatisticsJs();
		psjs.setGameId(gameId);
		List<PageStatisticsJs> list = FacadeFactory.INSTANCE.getPageStatisticsJsBo().findPageStatisticsJss(
				psjs, 1, 1);
		if (list == null || list.size() == 0) {
			return null;
		}
		return list.get(0);
	}

	public String changeHtmlPic(String content) {
		if (content == null) {
			return null;
		}
		content = content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image",
				"src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		content = content.replaceAll("src=\"/xlniumanager/userUploadFile/image",
				"src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		return content;
	}

	private static String formatTime(String timeStr) {
		if (timeStr == null || "".equals(timeStr)) {
			return "";
		}
		try {
			Date date = sdf.parse(timeStr);
			return sdfshort1.format(date);
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}
	private Map<String,String> gettopImgMap(){
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("276", games.getGameId(), isPreView);
		if(li==null){
			return null;
		}
		Map<String,String> map=new HashMap<String,String>();
		map.put("href", li.getLinkurl()==null?"":li.getLinkurl());
		map.put("src", li.getPicurl()==null?"":li.getPicurl());
		return map;
	}
	private List<Map<String,String>> getFooterImgList(){
		List<Map<String,String>> list=new ArrayList<Map<String,String>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId_v2("277", games.getGameId(),4, isPreView);
		for(LinkInfo li:lilist){
			Map<String,String> map=new HashMap<String,String>();
			map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			map.put("img", li.getPicurl()==null?"":li.getPicurl());
			list.add(map);
		}
		return list;
	}
	private Map<String,String> getIndexLeftTopAdv(){
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("275", games.getGameId(), isPreView);
		if(li==null){
			return null;
		}
		Map<String,String> map=new HashMap<String,String>();
		map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
		map.put("img", li.getPicurl()==null?"":li.getPicurl());
		return map;
	}
	private List<Map<String,String>> getpatchList(){
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId_v2("278", games.getGameId(), 100, isPreView);
		List<Map<String,String>> list=new ArrayList<Map<String,String>>();
		for(LinkInfo li:lilist){
			Map<String,String> map=new HashMap<String,String>();
			map.put("version",li.getLinktitle()==null?"":li.getLinktitle());
			map.put("updateTime",li.getExt1()==null?"":li.getExt1());
			map.put("size",li.getExt2()==null?"":li.getExt2());
			map.put("md5", li.getExt3()==null?"":li.getExt3());
			map.put("url",li.getLinkurl()==null?"":li.getLinkurl());
			list.add(map);
		}
		return list;
	}
	private List<Map<String,Object>> getdownloadList(){
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId_v2("279", games.getGameId(), 100, isPreView);
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		for(LinkInfo li:lilist){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("title",li.getLinktitle()==null?"":li.getLinktitle());
			map.put("subTitle",li.getExt1()==null?"":li.getExt1());
			map.put("linkTitle",li.getExt2()==null?"":li.getExt2());
			List<Map<String,String>> shuxingList=new ArrayList<Map<String,String>>();
			List<LinkInfo> lilist1=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("shu"+li.getLinkid(), 100, isPreView);
			for(LinkInfo templi:lilist1){
				Map<String,String> tempmap=new HashMap<String,String>();
				tempmap.put("name", templi.getLinktitle()==null?"":templi.getLinktitle());
				tempmap.put("value", templi.getExt1()==null?"":templi.getExt1());
				shuxingList.add(tempmap);
			}
			map.put("attributeList", shuxingList);
			List<Map<String,String>> imgList=new ArrayList<Map<String,String>>();
			lilist1=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("pic"+li.getLinkid(), 100, isPreView);
			for(LinkInfo templi:lilist1){
				Map<String,String> tempmap=new HashMap<String,String>();
				tempmap.put("text", templi.getLinktitle()==null?"":templi.getLinktitle());
				tempmap.put("img", templi.getPicurl()==null?"":templi.getPicurl());
				tempmap.put("url", templi.getLinkurl()==null?"":templi.getLinkurl());
				imgList.add(tempmap);
			}
			map.put("imgList", imgList);
			List<Map<String,String>> hezuoList=new ArrayList<Map<String,String>>();
			lilist1=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("hezuo"+li.getLinkid(), 100, isPreView);
			for(LinkInfo templi:lilist1){
				Map<String,String> tempmap=new HashMap<String,String>();
				tempmap.put("text", templi.getLinktitle()==null?"":templi.getLinktitle());
				tempmap.put("url", templi.getLinkurl()==null?"":templi.getLinkurl());
				hezuoList.add(tempmap);
			}
			map.put("linkList", hezuoList);
			list.add(map);
		}
		return list;
	}
	
	/**
	 * 获得备案信息
	 * @return
	 */
	public Map<String,String> getPutOnRecord(){
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId_v2("828", games.getGameId(), 5, isPreView);
		Map<String,String> map=new HashMap<String,String>();
		if(CollectionUtils.isEmpty(lilist))return map;
		LinkInfo li = lilist.get(0);
		map.put("title",li.getLinktitle()==null?"":li.getLinktitle());
		map.put("content",li.getLinkdesc()==null?"":li.getLinkdesc());
		return map;
	}
	
	/**
	 * 
	 * @return
	 */
	public List<Map<String,String>> getCliectLunBo(){
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId_v2("270", games.getGameId(), 5, isPreView);
		List<Map<String,String>> list=new ArrayList<Map<String,String>>();
		for(LinkInfo li:lilist){
			Map<String,String> map=new HashMap<String,String>();
			map.put("img",li.getPicurl()==null?"":li.getPicurl());
			map.put("link",li.getLinkurl()==null?"":li.getLinkurl());
			list.add(map);
		}
		return list;
	}
	
	public void manualAddTemplateSchema(final HtmlTemplate ht, TemplateSchema ts) {
		if (ts.getExt1() != null && !"".equals(ts.getExt1())) {
			String gameId = ts.getExt1();
			GameVersion version = FacadeFactory.INSTANCE.getGameVersionBo().find(gameId);
			if(version == null)return ;
			VersionInfo info = FacadeFactory.INSTANCE.getVersionInfoBo().find(version.getVersionNo());
			if(info==null)return;
			ts.setTemplateid(info.getTemplateId());
			FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
			return;
		}else{
			Page page = new Page();
			List<GameVersion> gvlist = FacadeFactory.INSTANCE.getGameVersionBo().find(new GameVersion(), page);			   
			List<VersionInfo> vilist =  FacadeFactory.INSTANCE.getVersionInfoBo().find(new VersionInfo(), page);
			for(GameVersion gv:gvlist){
				for(VersionInfo info:vilist){
					if(gv.getVersionNo().equals(info.getVersionNo().trim())){
						 ts.setExt1(gv.getGameId());
						 ts.setTemplateid(info.getTemplateId());
			             FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);	   
			             break;
					}
				}		    	
		    }		
		}		
	}

}

