package com.xunlei.niux.manager.template.builder.gameofficial;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.version.GameVersion;
import com.xunlei.niux.data.vipgame.vo.version.VersionInfo;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.niux.manager.web.util.SafeContentUtil;
import com.xunlei.util.StringTools;

/**
 * 文章模板生成
 * @author Administrator
 *
 */
public class ArticleBuilder {
	private static final Logger logger = Logger.getLogger(ArticleBuilder.class.getName());
	private long timestamp=0;

	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	
	
	
	/**
	 * 获取文章的url访问名字
	 * @param advice
	 * @return
	 */
	private String getArticeUrlName(final Advice advice){
		if(advice.getContenturl()==null||"".equals(advice.getContenturl())){
			return System.currentTimeMillis()+".shtml";
		}
		String contentUrl=advice.getContenturl();
		if(contentUrl.contains("/a/")){
			return contentUrl.substring(contentUrl.lastIndexOf("/")+1);
		}
		return System.currentTimeMillis()+".shtml";
	}
	
	
	
   private Map<String, String> getHeadData(String gameId) {
	    Map<String,String> headMap = new HashMap<String,String>();

	    LinkInfo linkinfo = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(
	      "302", gameId, false);
	    headMap.put("title", 
	      (linkinfo == null) || (linkinfo.getLinktitle() == null) ? "" : linkinfo.getLinktitle());
	    headMap.put("description", 
	      (linkinfo == null) || (linkinfo.getLinkdesc() == null) ? "" : linkinfo.getLinkdesc());
	    Games games = GameCache.getInstance().getGameByGameId(gameId);
	    headMap.put("gameName", games==null?"":games.getGameName());
	    return headMap;
	  }
   
	public String buildArticleBuilder(final Advice advice){
		timestamp=System.currentTimeMillis();
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成");
		Games game=GameCache.getInstance().getGameByGameId(advice.getGameId());
        if(game == null){
            logger.error("gameid "+advice.getGameId()+" 对应的游戏信息不存在！");
        }
        int gameClientType = game.getClientType();

		HtmlTemplate htmlTemplate=FacadeFactory.INSTANCE.getHtmlTemplateBo().find("000025");
		Map<String,String> articleInfoMap=new HashMap<String,String>();
		articleInfoMap.put("typeId", advice.getPlatformno()+"");
		articleInfoMap.put("title", advice.getTitle()+"");
		articleInfoMap.put("red", advice.getRed()+"");
		articleInfoMap.put("bold", advice.getBold()+"");
		articleInfoMap.put("content", getContent(game, advice));
		articleInfoMap.put("date", advice.getPublishDate().substring(0, 10));
		
		//找出上一篇，下一篇
		Advice advicePre = null;//上一篇
		Advice adviceSur = null;//下一篇
		Advice ad = new Advice();
		try{
			ad.setGameId(advice.getGameId());
			ad.setAdviceType(advice.getAdviceType());
			Page page = new Page();
			page.addOrder("publishDate", OrderType.DESC);
			List<Advice> alladvices = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(ad, page);
			int thisAdIndex = -1;
			for(int i = 0; i < alladvices.size(); i++){
				Advice adtmp = alladvices.get(i);
				if(advice.getTitle().equals(adtmp.getTitle()) && advice.getPlatformno().equals(adtmp.getPlatformno())){//找到这篇文章
					thisAdIndex = i;
					break;
				}
			}
			
			if(thisAdIndex > 0){
				adviceSur = alladvices.get(thisAdIndex - 1);
			}
			
			if(thisAdIndex < alladvices.size() - 1){
				advicePre = alladvices.get(thisAdIndex + 1);
			}
		}
		catch(Exception e){
            logger.error("gameid "+advice.getGameId()+" 对应的游戏信息不存在！",e);
		}
		articleInfoMap.put("title_sur", adviceSur == null ? "" : adviceSur.getTitle());
		articleInfoMap.put("contenturl_sur", adviceSur == null ? "" : adviceSur.getContenturl());
		articleInfoMap.put("title_pre", advicePre == null ? "" : advicePre.getTitle());
		articleInfoMap.put("contenturl_pre", advicePre == null ? "" : advicePre.getContenturl());

		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+",articleInfoMap:"+articleInfoMap);
			
		
		//seo标题
		String content = advice.getContent();
		content = SafeContentUtil.removeHtml(content);
		if(content !=null ){
			SafeContentUtil.checkContent(content);
    		if(content.length()>80)
    		   content = content.substring(0,80);
    	}
		articleInfoMap.put("description", content);
		String articeUrlName=getOldArticeUrlName(advice);
		//articeUrlName=getArticeUrlName(advice);
//		if(StringTools.isEmpty(advice.getContenturl())){//如果是新增操作
//			articeUrlName=getArticeUrlName(advice);
//		}else{
//			articeUrlName=getOldArticeUrlName(advice);
//		}
		VersionInfo info = getGameVersionCode(advice.getGameId());
		if(info!=null){
        	String articleTemplateId = info.getArticleTemplateId();
        	HtmlTemplate query = new HtmlTemplate();
        	query.setTemplateid(articleTemplateId);
        	HtmlTemplate templdate = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        	htmlTemplate.setHtmlroot(templdate.getHtmlroot());
        	htmlTemplate.setTemplateroot(templdate.getTemplateroot());
		}
		String htmlFilePath=htmlTemplate.getHtmlroot();
//        String htmlFilePath = "/data/output";
		
        
		if(htmlFilePath.endsWith("/")){
			htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
		}

		String previewhtmlFilePath=htmlTemplate.getPreviewhtmlroot();
		if(previewhtmlFilePath.endsWith("/")){
			previewhtmlFilePath=previewhtmlFilePath.substring(0, previewhtmlFilePath.length()-1);
		}
		
		String gameBoxPath = htmlFilePath+"/tv3/official/"+game.getGameNo()+"/gamebox";
		htmlFilePath=htmlFilePath+"/tv3/official/"+game.getGameNo()+"/a";
		
		previewhtmlFilePath=previewhtmlFilePath+"/tv3/official/"+game.getGameNo()+"/a";
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("articleInfoMap", articleInfoMap);
		root.put("headMap", getHeadData(game.getGameId()));
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成正式模板");

        String templateFilePath = htmlTemplate.getTemplateroot();
//        if ("000180".equals(game.getGameId())){
//        	templateFilePath = templateFilePath + "_" + game.getGameNo();
//        }
//        String templateFilePath = "/Users/jamesjxin/Work/XLWork/xlniuxmanager/src/main/java/com/xunlei/niux/manager/template/builder/gameofficial";
        if(templateFilePath.endsWith("/")){
            templateFilePath = templateFilePath.substring(0,templateFilePath.length()-1);
        }
        if(gameClientType == 2 && game.getGameNo().equals("xyd")){
            templateFilePath = templateFilePath + "/" + game.getGameNo();
        }
        if(info!=null){
        	String versionCode = info.getVersionCode();
        	if("V5".equalsIgnoreCase(versionCode)){//V3外网被简版官网占用了，V5表示游戏官网3.0
        		String gameId = advice.getGameId();
        		if(!StringTools.isEmpty(gameId)){        			
        			root.put("xinShouFirstArticleMap",getArticleMap("xinshou",gameId));
        			root.put("gaoShouFirstArticleMap",getArticleMap("gaoshou",gameId));
        			root.put("teSeFirstArticleMap",getArticleMap("tese",gameId));
        			root.put("articleList", getArticleList(advice.getPlatformno(),gameId));
        		}        		
        	}
        }
		FreemarkerUtil.buildHtml(templateFilePath,
				"article.shtml", root, htmlFilePath,
				articeUrlName);
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成预览模板");
		FreemarkerUtil.buildHtml(templateFilePath,
				"article.shtml", root, previewhtmlFilePath,
				articeUrlName);
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始同步");

        if(!game.getGameNo().equals("xyd")){
            FreemarkerUtil.buildHtml(templateFilePath,
                    "articleGameBox.shtml", root, gameBoxPath,
                    articeUrlName);
        }

		execRsync(htmlTemplate);
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"完成同步");
		String officilaWebSite=game.getOfficialWebSite();
		if(officilaWebSite.endsWith("/")){
			officilaWebSite=officilaWebSite.substring(0, officilaWebSite.length()-1);
		}
		return officilaWebSite+"/a/"+articeUrlName;
	}


    private String bulidCoinAdvice(Advice advice){
		timestamp=System.currentTimeMillis();
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成");
		Games game=GameCache.getInstance().getGameByGameId(advice.getGameId());
        if(game == null){
            logger.error("gameid "+advice.getGameId()+" 对应的游戏信息不存在！");
        }

		Map<String,String> articleInfoMap=new HashMap<String,String>();
		articleInfoMap.put("typeId", advice.getPlatformno()+"");
		articleInfoMap.put("title", advice.getTitle()+"");
		articleInfoMap.put("red", advice.getRed()+"");
		articleInfoMap.put("bold", advice.getBold()+"");
		articleInfoMap.put("content", getContent(game, advice));
		articleInfoMap.put("date", advice.getPublishDate().substring(0, 10));
		
		//找出上一篇，下一篇
		Advice advicePre = null;//上一篇
		Advice adviceSur = null;//下一篇
		Advice ad = new Advice();
		try{
			ad.setGameId(advice.getGameId());
			ad.setAdviceType(advice.getAdviceType());
			Page page = new Page();
			page.addOrder("publishDate", OrderType.DESC);
			List<Advice> alladvices = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(ad, page);
			int thisAdIndex = -1;
			for(int i = 0; i < alladvices.size(); i++){
				Advice adtmp = alladvices.get(i);
				if(advice.getTitle().equals(adtmp.getTitle()) && advice.getPlatformno().equals(adtmp.getPlatformno())){//找到这篇文章
					thisAdIndex = i;
					break;
				}
			}
			
			if(thisAdIndex > 0){
				adviceSur = alladvices.get(thisAdIndex - 1);
			}
			
			if(thisAdIndex < alladvices.size() - 1){
				advicePre = alladvices.get(thisAdIndex + 1);
			}
		}
		catch(Exception e){
            logger.error("gameid "+advice.getGameId()+" 对应的游戏信息不存在！",e);
		}
		articleInfoMap.put("title_sur", adviceSur == null ? "" : adviceSur.getTitle());
		articleInfoMap.put("contenturl_sur", adviceSur == null ? "" : adviceSur.getContenturl());
		articleInfoMap.put("title_pre", advicePre == null ? "" : advicePre.getTitle());
		articleInfoMap.put("contenturl_pre", advicePre == null ? "" : advicePre.getContenturl());

		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+",articleInfoMap:"+articleInfoMap);
			
		
		//seo标题
		String content = advice.getContent();
		content = SafeContentUtil.removeHtml(content);
		if(content !=null ){
			SafeContentUtil.checkContent(content);
    		if(content.length()>80)
    		   content = content.substring(0,80);
    	}
		articleInfoMap.put("description", content);
		String articeUrlName=getOldArticeUrlName(advice);
//		articeUrlName=getArticeUrlName(advice);
//		if(StringTools.isEmpty(advice.getContenturl())){//如果是新增操作
//			articeUrlName=getArticeUrlName(advice);
//		}else{
//			articeUrlName=getOldArticeUrlName(advice);
//		}
		
		HtmlTemplate htmlTemplate=FacadeFactory.INSTANCE.getHtmlTemplateBo().find("000091");//欢乐谷生成文章
		String previewhtmlFilePath=htmlTemplate.getPreviewhtmlroot();
		if(previewhtmlFilePath.endsWith("/")){
			previewhtmlFilePath=previewhtmlFilePath.substring(0, previewhtmlFilePath.length()-1);
		}
//		previewhtmlFilePath=previewhtmlFilePath+"/tv3/official/"+game.getGameNo()+"/a";
		
		String htmlFilePath=htmlTemplate.getHtmlroot();
		if(htmlFilePath.endsWith("/")){
			htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
		}
//		htmlFilePath=htmlFilePath+"/tv3/official/"+game.getGameNo()+"/a";

		Map<String,Object> root=new HashMap<String,Object>();
		root.put("articleInfoMap", articleInfoMap);
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成正式模板");

        String templateFilePath = htmlTemplate.getTemplateroot();
        if(templateFilePath.endsWith("/")){
            templateFilePath = templateFilePath.substring(0,templateFilePath.length()-1);
        }

        String gameId = advice.getGameId();
        root.put("articleList", getArticleList(advice.getPlatformno(),gameId));
        
//        //测试
//        templateFilePath="d:/templatefile/niuxhlg/";
//        htmlFilePath="d:/template/niuxhlg/";
//        previewhtmlFilePath="d:/template/niuxhlg_previewhtmlFilePath/";
        
		FreemarkerUtil.buildHtml(templateFilePath,"article.shtml", root, htmlFilePath+"/a", articeUrlName);
		FreemarkerUtil.buildHtml(templateFilePath, "article.shtml", root, previewhtmlFilePath+"/a", articeUrlName);	


		String officilaWebSite = "http://hlg.niu.xunlei.com/";
		if(officilaWebSite.endsWith("/")){
			officilaWebSite=officilaWebSite.substring(0, officilaWebSite.length()-1);
		}

		return officilaWebSite+"/a/"+articeUrlName;
	}
    
	
	private Map<String, String> getArticleMap(String articleType, String gameId) {	
		Advice advice = new Advice();
		advice.setAdviceType("3");
        if(StringUtils.isNotEmpty(articleType)){
            advice.setPlatformno(articleType);
        }
		advice.setGameId(gameId);
		advice.setLePublishDate(sdf.format(new Date()));
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		String nowStr=sdf.format(new Date());
		List<Advice> adviceList = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
		if(CollectionUtils.isEmpty(adviceList))return null;
		Advice ad = adviceList.get(0);
		Map<String, String> map = new HashMap<String, String>();
		map.put("type", ad.getPlatformno());
		map.put("url", ad.getJumpUrl() == null ? "" : ad.getJumpUrl());
		map.put("aid", ad.getSeqId() + "");
		map.put("title", formatTitle(ad.getTitle()));
		boolean isRemoveRedBold=false;
        if(StringUtils.isNotEmpty(ad.getRemoveFlagTime())){
            isRemoveRedBold=nowStr.compareTo(ad.getRemoveFlagTime())>=0;
        }
		map.put("isColor", ad.getRed()&&isRemoveRedBold==false ? "yes" : "no");
		map.put("isStrong", ad.getBold()&&isRemoveRedBold==false ? "yes" : "no");
		map.put("date", ad.getPublishDate().substring(5, 10));
		map.put("hotVlaue", ad.getHotLevel()+"");
		return map;
	}
	
	private List<Map<String, String>> getArticleList(String articleType, String gameId) {
		List<Map<String, String>> articleList = new ArrayList<Map<String, String>>();
		Advice advice = new Advice();
		advice.setAdviceType("3");
        if(StringUtils.isNotEmpty(articleType)){
            advice.setPlatformno(articleType);
        }
		advice.setGameId(gameId);
		advice.setLePublishDate(sdf.format(new Date()));
		Page page = new Page();
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		String nowStr=sdf.format(new Date());
		List<Advice> adviceList = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
		for (Advice ad : adviceList) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("type", ad.getPlatformno());
			map.put("url", ad.getJumpUrl() == null ? "" : ad.getJumpUrl());
			map.put("aid", ad.getSeqId() + "");
			map.put("title", formatTitle(ad.getTitle()));
			boolean isRemoveRedBold=false;
            if(StringUtils.isNotEmpty(ad.getRemoveFlagTime())){
                isRemoveRedBold=nowStr.compareTo(ad.getRemoveFlagTime())>=0;
            }
			map.put("isColor", ad.getRed()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("isStrong", ad.getBold()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("date", ad.getPublishDate().substring(5, 10));
			map.put("hotVlaue", ad.getHotLevel()+"");
			articleList.add(map);
		}
		return articleList;
	}

	private String formatTitle(String title){
		if(StringTools.isEmpty(title))return "";
		return title.replaceAll("\"", "\\\\\"");
	}
	
    
	private VersionInfo getGameVersionCode(String gameId){
		GameVersion query = new GameVersion();
		query.setGameId(gameId);
		GameVersion gameVersion = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(gameVersion == null) return null;
		VersionInfo info = new VersionInfo();
		info.setVersionNo(gameVersion.getVersionNo());
		VersionInfo version = FacadeFactory.INSTANCE.getBaseSo().findObject(info);
	     return version;
		
	}
	
	
	/**
	 * 获取文章的url访问名字
	 * @param advice
	 * @return
	 */
	private String getOldArticeUrlName(final Advice advice){
		String contentUrl = advice.getContenturl();
		if(StringTools.isEmpty(contentUrl)){//如果没有生成地址
			return System.currentTimeMillis()+".shtml";
		}
		if(contentUrl.contains("/a/")){
			return contentUrl.substring(contentUrl.lastIndexOf("/")+1);
		}
		return System.currentTimeMillis()+".shtml";
	}
	
    public String buildJinZuanArticleBuilder(final Advice advice){
        timestamp=System.currentTimeMillis();
        logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成");

        if(advice.getPlatformno().equals("question")){
            return "";
        }

        return bulidJinuanAdvice(advice);
    }
    
    public String buildCoinArticleBuilder(final Advice advice){
    	timestamp=System.currentTimeMillis();
    	logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成");
    	
    	if(advice.getPlatformno().equals("question")){
    		return "";
    	}
    	
    	return bulidCoinAdvice(advice);
    }

    private String bulidJinuanAdvice(Advice advice){
        Games game = null;

        game=GameCache.getInstance().getGameByGameId(advice.getGameId());
        if(game == null){
            logger.error("gameid "+advice.getGameId()+" 对应的游戏信息不存在！");
        }

        HtmlTemplate htmlTemplate=FacadeFactory.INSTANCE.getHtmlTemplateBo().find("000052");
        Map<String,String> articleInfoMap=new HashMap<String,String>();
        articleInfoMap.put("typeId", advice.getPlatformno()+"");
        articleInfoMap.put("title", advice.getTitle()+"");
        articleInfoMap.put("red", advice.getRed()+"");
        articleInfoMap.put("bold", advice.getBold()+"");
        articleInfoMap.put("content", getContent(game, advice));
//        articleInfoMap.put("content",advice.getContent());
        articleInfoMap.put("date", advice.getPublishDate().substring(0, 10));
        String articeUrlName=getArticeUrlName(advice);


        Map<String,Object> root=new HashMap<String,Object>();
        root.put("articleInfoMap", articleInfoMap);

        String templateFilePath = htmlTemplate.getTemplateroot();
        if(templateFilePath.endsWith("/")){
            templateFilePath = templateFilePath.substring(0,templateFilePath.length()-1);
        }

        String htmlFilePath=htmlTemplate.getHtmlroot();
        if(htmlFilePath.endsWith("/")){
            htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
        }
        htmlFilePath += "/a";

//        String inputPath = "/Users/jamesjxin/Work/XL工作目录/20140311金钻/模版/1";
//        String outputPath = "/Users/jamesjxin/Work/XL工作目录/20140311金钻/模版/output";

        FreemarkerUtil.buildHtml(templateFilePath,"articleDetail.html", root, htmlFilePath,articeUrlName);

        return "/a/"+articeUrlName;
    }
    
    

	private String getContent(final Games games,final Advice advice){
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始替换静态图片");
		//替换静态图片访问地址
		String content=advice.getContent()==null?"":advice.getContent();
		content=content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		content=content.replaceAll("src=\"/xlniumanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始替换关键字");
		//替换关键字
        if(games != null){
            List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId("256", games.getGameId(), 10, false);
            for(LinkInfo li:lilist){
                if(li.getLinktitle()==null||"".equals(li.getLinktitle())){
                    continue;
                }
                content=content.replace(li.getLinktitle(), "<a href=\""+li.getLinkurl()+"\" target=\"_blank\">"+li.getLinktitle()+"</a>");
                logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"替换关键字"+li.getLinktitle());
            }
            logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"替换关键字完成");
        }

		return content;
	}
	private void execRsync(final HtmlTemplate htmlTemplate){
		String execCmd=htmlTemplate.getRsyncname();//执行命
		if(execCmd==null||"".equals(execCmd)){
			return;
		}
		try {
			Runtime.getRuntime().exec(execCmd);
			Runtime.getRuntime().exec(htmlTemplate.getPreviewrsyncname());
		} catch (IOException e) {
			throw new RuntimeException("执行同步脚本："+execCmd+"出现异常",e);
		}

	}
}
