package com.xunlei.niux.manager.template.builder.gamecenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.LinkInfoBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-8-18.
 */
public class GameCenterPageBuilder extends AbstractTemplateBuilder {

    private LinkInfoBo linkInfoBo;

    private Map<String, LinkInfo> mobileGameDownloadInfoMap;

    @Override
    public void executeShcema() throws Exception {
        linkInfoBo = FacadeFactory.INSTANCE.getLinkInfoBo();
        initMobileGameDownloadInfoMap();


        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("sliderList", getLunBoPicList());
        rootMap.put("niuxGameList", getNiuxGameList());
        rootMap.put("syGameList", getSYGameList());
        rootMap.put("niuxGameMap", getWebGameSubTitleMap());
        rootMap.put("syGameMap", getSYGameSubTitleMap());
        rootMap.put("productList", getXLProductList());

        String templatePath = htmlTemplate.getTemplateroot();
        if (!templatePath.endsWith("/")) {
            templatePath = templatePath + "/";
        }
        String htmlPath = htmlTemplate.getHtmlroot();
        if (!htmlPath.endsWith("/")) {
            htmlPath = htmlPath + "/";
        }

//        String templatePath = "/Users/jamesjxin/Work/XL工作目录/20140811牛X手游官网&游戏中心/游戏中心/ftl/";
//        String htmlPath = "/Users/jamesjxin/Work/XL工作目录/20140811牛X手游官网&游戏中心/游戏中心/output/";

        FreemarkerUtil.buildHtml(templatePath, "index.html", rootMap, htmlPath, "index.html");

    }

    private void initMobileGameDownloadInfoMap() {
        mobileGameDownloadInfoMap = new HashMap<String, LinkInfo>();
        List<LinkInfo> gameDownloadInfoList = linkInfoBo.getAllLinkListByLinkLocId("1601", isPreView);
        if (CollectionUtils.isEmpty(gameDownloadInfoList)) {
            return;
        }

        for (LinkInfo linkInfo : gameDownloadInfoList) {
            mobileGameDownloadInfoMap.put(linkInfo.getGameidbytuijian(), linkInfo);
        }
    }

    private List<Map<String, Object>> getLunBoPicList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lunBoList = linkInfoBo.getLinkListByOrderByLimit("800", 10, "displaysort", OrderType.DESC, false);
        if (CollectionUtils.isEmpty(lunBoList)) {
            return resultList;
        }

        for (LinkInfo lunBo : lunBoList) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", lunBo.getLinktitle());
            map.put("img", lunBo.getPicurl());
            map.put("bgColor", lunBo.getExt1() == null ? "" : lunBo.getExt1());
            map.put("url", lunBo.getLinkurl());
            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String, Object>> getNiuxGameList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<LinkInfo> linkInfoList = linkInfoBo.getLinkListByOrderByLimit("801", 10, "displaysort", OrderType.DESC, true, false);
        if (CollectionUtils.isEmpty(linkInfoList)) {
            return resultList;
        }

        for (LinkInfo linkInfo : linkInfoList) {
            Map<String, Object> map = new HashMap<String, Object>();
            String gameId = linkInfo.getGameidbytuijian();
            Games game = GameCache.getInstance().getGameByGameId(gameId);
            if (game == null) {
                continue;
            }
            map.put("sourcetype", linkInfo.getExt3());
            map.put("vobpicurl", linkInfo.getPicurl());
            map.put("voburl", linkInfo.getExt2() == null ? "" : linkInfo.getExt2());
            map.put("cardLink", linkInfo.getLinkurl());
            map.put("gameId", gameId);
            map.put("gameNo", game.getGameNo());
            map.put("gameName", game.getGameName());
            map.put("gameOfficialLink", game.getOfficialWebSite());
            map.put("icon", linkInfo.getExt5() == null ? "" : linkInfo.getExt5());
            map.put("gameIntro", game.getGameDesc() == null ? "" : game.getGameDesc());
            map.put("isNew", game.getIsNew() ? 1 : 0);
            map.put("isHot", game.getIsHot() ? 1 : 0);
            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String, Object>> getSYGameList() {
        return getGameInfoListByLinklocIdWithLimit("802", 5);
    }

    private Map<String, Object> getWebGameSubTitleMap() {
        return getSubTitleMap("803");
    }

    private Map<String, Object> getSYGameSubTitleMap() {
        return getSubTitleMap("804");
    }

    private List<Map<String, Object>> getXLProductList() {
        List<Map<String, Object>> xlProductList = new ArrayList<Map<String, Object>>();
        LinkInfo linkInfo = new LinkInfo();
        linkInfo.setLinklocid("1503");//友情链接
        Page page = new Page();
        page.addOrder("validdatetime", OrderType.DESC);//按照生效时间逆序
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
        for (LinkInfo info : list) {
            String ext2 = info.getExt2();
            if ("001".equals(ext2)) {
                Map<String, Object> map = new HashMap<String, Object>();
                map.put("title", info.getLinktitle());
                map.put("url", info.getLinkurl());
                xlProductList.add(map);
            }
        }

        return xlProductList;
    }

    private Map<String, Object> getSubTitleMap(String linklocid) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        List<LinkInfo> linkInfoList = linkInfoBo.getLinkListByOrderByLimit(linklocid, 1, "validdatetime", OrderType.DESC, isPreView);
        if (CollectionUtils.isEmpty(linkInfoList)) {
            return resultMap;
        }

        LinkInfo subTitleInfo = linkInfoList.get(0);
        resultMap.put("subTitle", subTitleInfo.getLinktitle() == null ? "" : subTitleInfo.getLinktitle());
        resultMap.put("navIntro", subTitleInfo.getLinkdesc() == null ? "" : subTitleInfo.getLinkdesc());

        return resultMap;
    }


    private List<Map<String, Object>> getGameInfoListByLinklocIdWithLimit(String linklocid, int limit) {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isEmpty(linklocid)) {
            return resultList;
        }
        List<LinkInfo> newGameList = linkInfoBo.getLinkListByOrderByLimit(linklocid, limit, "displaysort", OrderType.DESC, isPreView);
        if (CollectionUtils.isEmpty(newGameList)) {
            return resultList;
        }

        for (LinkInfo newGameLinkInfo : newGameList) {
            String gameId = newGameLinkInfo.getGameidbytuijian();
            Games game = GameCache.getInstance().getGameByGameId(gameId);
            if (game == null) {
                continue;
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("img", game.getPicUrl() == null ? "" : game.getPicUrl());
            map.put("icon", game.getSmallPicUrl() == null ? "" : game.getSmallPicUrl());
            map.put("qcode", newGameLinkInfo.getPicurl() == null ? "" : newGameLinkInfo.getPicurl());
            map.put("gameName", game.getGameName());
            map.put("gameDesc", game.getGameDesc() == null ? "" : game.getGameDesc());
            map.put("gameOfficalLink", game.getOfficialWebSite() == null ? "" : game.getOfficialWebSite());
            map.put("gameIntro", game.getGameDesc() == null ? "" : game.getGameDesc());

            LinkInfo gameDownloadInfo = mobileGameDownloadInfoMap.get(gameId);
            if (gameDownloadInfo == null) {
                map.put("downloadLink", "");
                map.put("downloadNum", "");
                map.put("fileSize", "");
            } else {
                map.put("downloadLink", gameDownloadInfo.getLinkurl());
                map.put("downloadNum", NumParseUtil.getDownloadNumStr(gameDownloadInfo.getExt1()));
                map.put("fileSize", gameDownloadInfo.getExt2());
            }

            resultList.add(map);
        }

        return resultList;
    }

}
