package com.xunlei.niux.manager.template.builder.game;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.dto.game.KuaiWanGameDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by admin on 2015/7/9.
 */
public class KuaiWanBasicGameInfoBuilder extends AbstractTemplateBuilder {
    private String inputPath;
    private String outputPath;

    @Override
    public void executeShcema() throws Exception {
        inputPath = htmlTemplate.getTemplateroot();
        outputPath = htmlTemplate.getHtmlroot();

//        inputPath = "d:\\test";
//        outputPath = "d:\\test2";

        buildWebGameInfo();
        buildMobileGameInfo();

    }

    private void buildWebGameInfo(){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        List<KuaiWanGameDTO> webgameList = FacadeFactory.INSTANCE.getGamesBo().getKuaiwanWebGames();
        if(CollectionUtils.isNotEmpty(webgameList)){
            for(KuaiWanGameDTO gameDTO : webgameList){
                resultList.add(getGameMap(gameDTO, false));
            }
        }

        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("webgame", JsonObjectUtil.getDataJsonObject(resultList));

        FreemarkerUtil.buildHtml(inputPath, "webgame.json", rootMap, outputPath, "webgame.json");

    }

    private void buildMobileGameInfo(){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        List<KuaiWanGameDTO> mobilegameList = FacadeFactory.INSTANCE.getGamesBo().getKuaiwanAppGames();
        if(CollectionUtils.isNotEmpty(mobilegameList)){
            for(KuaiWanGameDTO gameDTO : mobilegameList){
                resultList.add(getGameMap(gameDTO,true));
            }
        }

        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("mobilegame", JsonObjectUtil.getDataJsonObject(resultList));

        FreemarkerUtil.buildHtml(inputPath, "mobilegame.json", rootMap, outputPath, "mobilegame.json");
    }

    private Map<String,Object> getGameMap(KuaiWanGameDTO game,boolean isMobileGame){
        Map<String,Object> map = new HashMap<String, Object>();
        if(game == null) {
            return map;
        }
        String gameId = game.getGameId();
        map.put("gameName",game.getGameName()==null?"":game.getGameName());
        map.put("gameDesc", game.getGameDesc()==null?"":game.getGameDesc());
        map.put("summary",game.getSummary()==null?"":game.getSummary());
        map.put("gameId",gameId);

        if(isMobileGame){
            map.put("iconUrl",  game.getSmallPicUrl()==null?"":game.getSmallPicUrl());
            map.put("appSize", game.getAppSize()==null?"":game.getAppSize());
            map.put("downloadUrl", game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
            int downloadNum = 100000;
            if(game.getDownloadNum()!=null && game.getDownloadNum() > 0){
                downloadNum = game.getDownloadNum();
            }
            map.put("downloadNum", NumParseUtil.getDownloadNumStr(String.valueOf(downloadNum)));
            map.put("gameDetailUrl",getGameDetailUrl(gameId));
            map.put("packageName",game.getPackageName()==null?"":game.getPackageName());
            map.put("editTime", game.getEditTime() == null ? "" : game.getEditTime());
            map.put("pic1", game.getPic1()==null?"":game.getPic1());
            map.put("pic2", game.getPic2()==null?"":game.getPic2());
            map.put("pic3", game.getPic3()==null?"": game.getPic3());
            map.put("pic4", game.getPic4()==null?"" :game.getPic4());
            map.put("pic5", game.getPic5()==null?"":game.getPic5());
        }else {
            map.put("smallPicUrl",  game.getSmallPicUrl()==null?"":game.getSmallPicUrl());
            map.put("picUrl", game.getPicUrl()== null?"":game.getPicUrl());
            map.put("officialWebSite", game.getOfficialWebSite()==null?"":game.getOfficialWebSite());
            map.put("editTime", game.getEditTime() == null ? "" : game.getEditTime());
            map.put("pic1", game.getPic1()==null?"":game.getPic1());
            map.put("pic2", game.getPic2()==null?"":game.getPic2());
            map.put("pic3", game.getPic3()==null?"":game.getPic3());
            map.put("pic4", game.getPic4()==null?"":game.getPic4());
            map.put("pic5", game.getPic5()==null?"":game.getPic5());
        }

        return map;
    }

    private String getGameDetailUrl(String gameId){
        return "/detail/"+gameId+".html";
    }
}
