package com.xunlei.niux.manager.template.builder.fenqu.fenqubuiderthread;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import org.apache.log4j.Logger;

import java.util.List;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-17.
 */
public class UpdateLatestFenquThread implements Callable{
    private static Logger logger = Logger.getLogger(UpdateLatestFenquThread.class);
    private String gameId;

    public UpdateLatestFenquThread(String gameId) {
        this.gameId = gameId;
    }

    @Override
    public String call() throws Exception {
        long timestamp = System.currentTimeMillis();
        updateLatestFenqu(gameId);
        long timePeriod = System.currentTimeMillis() - timestamp;
        logger.info("TimeSpend: UpdateLatestFenquThread uses ["+timePeriod+"]");
        return "success";
    }

    public void updateLatestFenqu(String gameId){
        if(gameId==null||"".equals(gameId)){
            return;
        }
        GameServers gs= FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(gameId, false);
        if(gs==null){
            return;
        }
        if(gs.getIsnew()){
            return;
        }
        //更新最新区服的状态
        gs.setIsnew(true);
        gs.setIsrecommand(true);
        gs.setRedtitle(true);
        FacadeFactory.INSTANCE.getGameServersBo().update(gs);

        GameServers query = new GameServers();
        query.setGameId(gameId);
        List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().find(query, new Page());
        for(int i=0;i<gsList.size();i++){
            GameServers gserver=gsList.get(i);
            if(gserver.getIsnew()==false){
                continue;
            }
            if(gserver.getSeqId().longValue()==gs.getSeqId().longValue()){
                continue;
            }
            gserver.setIsnew(false);
            gserver.setIsrecommand(false);
            gserver.setRedtitle(false);
            FacadeFactory.INSTANCE.getGameServersBo().update(gserver);
        }
    }
}
