package com.xunlei.niux.manager.template.builder.fenqu.fenqubuiderthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.tasks.TaskDutyConfig;
import com.xunlei.niux.manager.web.cache.GameCache;
import org.apache.log4j.Logger;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-17.
 */
public class BuildeTodayOpenFenQuServerThread implements Callable {
    private static Logger logger = Logger.getLogger(BuildeTodayOpenFenQuServerThread.class);
    static SimpleDateFormat sdfdate=new SimpleDateFormat("yyyy-MM-dd");
    private String tempPath;
    private String htmlFilePath;

    public BuildeTodayOpenFenQuServerThread(String tempPath, String htmlFilePath) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
    }

    @Override
    public String call() throws Exception {

        long timestamp = System.currentTimeMillis();
        buildeTodayOpenFenQuServer();
        long timePeriod = System.currentTimeMillis() - timestamp;
        logger.info("TimeSpend: BuildeTodayOpenFenQuServerThread uses ["+timePeriod+"]");
        return "success";
    }

    public void buildeTodayOpenFenQuServer(){
        String now=sdfdate.format(new Date());
        GameServers query=new GameServers();
        query.setFromopentime(now+" 00:00:00");
        query.setToopentime(now+" 23:59:59");
        Page page=new Page();
        page.addOrder("openTime", OrderType.ESC);
        page.addOrder("fenQuNum", OrderType.ESC);
        List<GameServers> gsList= FacadeFactory.INSTANCE.getGameServersBo().find(query, page);
        List<Map<String,Object>> list=fliterGameServerInfo(gsList);
        String json= JsonObjectUtil.getDataJsonObject(list);
        File file = com.xunlei.niux.manager.web.util.FileUtil.createFile(htmlFilePath, "todayopenserver.js");
        com.xunlei.niux.manager.web.util.FileUtil.writeByChar(file, "todayopenserver="+json);
    }

    private static List<Map<String,Object>> fliterGameServerInfo(List<GameServers> gsList){
        List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
        if(gsList==null||gsList.size()==0){
            return list;
        }
        for(int i=0;i<gsList.size();i++){
            GameServers tgs=gsList.get(i);
            Games games= GameCache.getInstance().getGameByGameId(tgs.getGameId());
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("seqId", tgs.getSeqId());
            map.put("gameId", tgs.getGameId());
            map.put("fenQuNum", tgs.getFenQuNum());
            map.put("fenQuName", tgs.getFenQuName());
            map.put("serverId", tgs.getServerId());
            map.put("openStatus", tgs.getOpenStatus());
            map.put("openTime", tgs.getOpenTime());
            map.put("isnew", tgs.getIsnew());
            map.put("fenQuNickName", tgs.getFenQuNickName());
            map.put("bigFenQuName", tgs.getBigFenQuName());
            map.put("gameNo", games.getGameNo());
            map.put("gameName", games.getGameName());
            list.add(map);
        }
        return list;
    }
}
