package com.xunlei.niux.manager.template.builder.fenqu.fenqubuiderthread;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-18.
 */
public class BuildLatestFenQuThread implements Callable{
    private static Logger logger = Logger.getLogger(BuildLatestFenQuThread.class);
    private String tempPath;
    private String htmlFilePath;

    public BuildLatestFenQuThread(String tempPath, String htmlFilePath) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
    }

    @Override
    public String call() throws Exception {
        long timestamp = System.currentTimeMillis();
        buildLatestFenQu();
        long timePeriod = System.currentTimeMillis() - timestamp;
        logger.info("TimeSpend: BuildLatestFenQuThread uses ["+timePeriod+"]");
        return "success";
    }

    public void buildLatestFenQu(){
        Games qGame=new Games();
        List<Games> gameList= FacadeFactory.INSTANCE.getGamesBo().findGames(qGame, 0, 0);
        List<Object> list=new ArrayList<Object>();
        for(Games game:gameList){
            if (game.getClientType() != 0 && game.getClientType() != 1) {
                continue;
            }
            GameServers gs=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(game.getGameId(), false);
            if(gs==null){
                continue;
            }
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("seqId", gs.getSeqId());
            map.put("fenQuNum", gs.getFenQuNum());
            map.put("fenQuName", gs.getFenQuName()==null?"": gs.getFenQuName());
            map.put("fenQuNickName", (gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName())?gs.getFenQuName():gs.getFenQuNickName()));
            map.put("serverName", gs.getServerName()==null?"":gs.getServerName());
            map.put("serverId", gs.getServerId()==null?"":gs.getServerId());
            map.put("serverAddress", gs.getAddress()==null?"":gs.getAddress());
            map.put("gameId", gs.getGameId());
            map.put("gameNo", game.getGameNo());
            map.put("openTime",gs.getOpenTime()==null?"":gs.getOpenTime());
            list.add(map);
        }
        Map<String,Object> root=new HashMap<String,Object>();
        root.put("latestfenqulist", list);
        String templateFileName="latestfenquinfo.ftl";
        String htmlFileName="gamelatestfenquinfos.js";
        FreemarkerUtil.buildHtml(tempPath, templateFileName, root, htmlFilePath, htmlFileName);
    }
}
