package com.xunlei.niux.manager.template.builder.fenqu.fenqubuiderthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import org.apache.log4j.Logger;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-17.
 */
public class BuildGameFenQuJsonThread implements Callable{
    private static Logger logger = Logger.getLogger(BuildeTodayOpenFenQuServerThread.class);
    private String tempPath;
    private String htmlFilePath;
    private String gameId;


    public BuildGameFenQuJsonThread(String gameId, String tempPath, String htmlFilePath) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.gameId = gameId;
    }

    @Override
    public String call() throws Exception {
        long timestamp = System.currentTimeMillis();
        buildGameFenQuJson(gameId);
        long timePeriod = System.currentTimeMillis() - timestamp;
        logger.info("TimeSpend: BuildGameFenQuJsonThread uses ["+timePeriod+"]");
        return "success";
    }

    public void buildGameFenQuJson(String gameId){
        if(gameId==null||"".equals(gameId)){
            return ;
        }
        GameServers query=new GameServers();
        query.setGameId(gameId);
        Page page=new Page();
        page.addOrder("openTime", OrderType.DESC);
        page.addOrder("fenQuNum", OrderType.DESC);
        //查询全部
        List<GameServers> list= FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        List<Map<String,Object>> tlist=new ArrayList<Map<String,Object>>();

        for(GameServers gs:list){      	
            if("0".equals(gs.getOpenStatus())||"2".equals(gs.getOpenStatus())){          	
                continue;
            }
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("fenQuNum",  String.valueOf(gs.getFenQuNum()));
            map.put("fenQuName", gs.getFenQuName());
            map.put("serverId",gs.getServerId());
            map.put("serverName", gs.getServerName());
            map.put("address", gs.getAddress());
            map.put("seqId", gs.getSeqId());
            map.put("openTime",gs.getOpenTime()==null?"":gs.getOpenTime());
            map.put("openStatus", gs.getOpenStatus());
            map.put("fenQuNickName", (gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName()))?gs.getFenQuName():gs.getFenQuNickName());
            map.put("bigFenQuName", gs.getBigFenQuName()==null?"":gs.getBigFenQuName());
            tlist.add(map);
        }
        String json= JsonObjectUtil.getDataJsonObject(tlist);
        File file = com.xunlei.niux.manager.web.util.FileUtil.createFile(htmlFilePath, gameId+".json");
        com.xunlei.niux.manager.web.util.FileUtil.writeByChar(file, "gamefenqus="+json);
        if("000202".equals(gameId.trim())){//大天使需要显示未接入的区服
            List<Map<String,Object>> dtstlist=new ArrayList<Map<String,Object>>();           
        	 for(GameServers gs:list){      	
                 if("2".equals(gs.getOpenStatus())){          	
                     continue;
                 }
                 Map<String,Object> map=new HashMap<String,Object>();
                 map.put("fenQuNum",  String.valueOf(gs.getFenQuNum()));
                 map.put("fenQuName", gs.getFenQuName());
                 map.put("serverId",gs.getServerId());
                 map.put("serverName", gs.getServerName());
                 map.put("address", gs.getAddress());
                 map.put("seqId", gs.getSeqId());
                 map.put("openTime",gs.getOpenTime()==null?"":gs.getOpenTime());
                 map.put("openStatus", gs.getOpenStatus());
                 map.put("fenQuNickName", (gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName()))?gs.getFenQuName():gs.getFenQuNickName());
                 map.put("bigFenQuName", gs.getBigFenQuName()==null?"":gs.getBigFenQuName());
                 dtstlist.add(map);
             }
             String dtsjson= JsonObjectUtil.getDataJsonObject(dtstlist);
             File dtsfile = com.xunlei.niux.manager.web.util.FileUtil.createFile(htmlFilePath, gameId+"_1.json");
             com.xunlei.niux.manager.web.util.FileUtil.writeByChar(dtsfile, "gamefenqus="+dtsjson);
        }
    }
}
