package com.xunlei.niux.manager.template.builder.fenqu;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.xunlei.niux.manager.web.proxy.SynchBoxNewServerAdviceProxy;
import org.apache.log4j.Logger;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.data.vipgame.vo.version.GameVersion;
import com.xunlei.niux.data.vipgame.vo.version.VersionInfo;
import com.xunlei.niux.manager.template.constant.TemplateIdConstant;

/**
 * 开区
 * @author liangdong
 *
 */
public class TimeOpenFenQuService{
	
	private static final Logger logger = Logger.getLogger(TimeOpenFenQuService.class);
	
	private static final SimpleDateFormat SDF=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	public void execute() throws Exception {
		logger.info("Start open fenqu...");
		List<GameServers> gameServersList = FacadeFactory.INSTANCE.getGameServersBo().getTimeOpenFenQuGameServersList();
		
		if(gameServersList == null || gameServersList.size()==0){
			logger.info("None to open.");
			return;
		}
		try{
			for(GameServers gameservers : gameServersList){
				String gameId = gameservers.getGameId();
				openFenQu(gameservers);
				//更新游戏分区
				addEnterGameTemplateSchema(gameId);
				addGameOfficialTemplateSchema(gameId);
				noticeniuxupdatecache(gameId);
            }

            //等待模板执行，延迟同步数据
            Thread.sleep(5*60*1000);

			for(GameServers gameservers : gameServersList){
                SynchBoxNewServerAdviceProxy.getInstance().makeServerAndAdvice(gameservers.getGameId());
                Thread.sleep(1000);
			}

		}finally{
			Runtime.getRuntime().exec("/usr/local/htdocs/JNetPayGenXml/startup.sh");
			logger.info("End open fenqu...");
		}
	}

	
	private void openFenQu(final GameServers gameServers)throws Exception{

		if(notTheTime(gameServers.getFenQuOpenTime())){
			return;
		}
		
		try{
			gameServers.setOpenStatus("1");
			gameServers.setFenQuOpenFlag(0);
			FacadeFactory.INSTANCE.getGameServersBo().update(gameServers);
			logger.info("定时开服成功：gameId="+gameServers.getGameId()+"|fenQuNum="+gameServers.getFenQuNum());
		}catch(Exception e){
			logger.error("定时开服失败 gameId="+gameServers.getGameId()+", fenQuNum="+gameServers.getFenQuNum()
					+", openStatus="+gameServers.getOpenStatus(), e);
		}
		
	}
	
	private boolean notTheTime(final String fenQuOpenTime) throws ParseException {
		
		long fenQuOpenTimestamp  = SDF.parse(fenQuOpenTime).getTime();
		long now = new Date().getTime();
		
		return now < fenQuOpenTimestamp;
	
	}
	
	private void addEnterGameTemplateSchema(final String gameId){
		String nowStr=SDF.format(new Date());
    	//添加执行计划
		TemplateSchema ts=new TemplateSchema();
		ts.setTemplateid("000027");
		ts.setSchematime(nowStr);
		ts.setIsexecuted(false);
		ts.setInputby("系统");
		ts.setInputtime(nowStr);
		ts.setIspreview(false);
		ts.setExt1(gameId);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
	}
	/**
	 * 添加游戏官网执行模板
	 * @param gameId
	 */
	private void addGameOfficialTemplateSchema(final String gameId){
		GameVersion gameversion=FacadeFactory.INSTANCE.getGameVersionBo().find(gameId);
		if(gameversion==null){
			return;
		}
		VersionInfo versionInfo=FacadeFactory.INSTANCE.getVersionInfoBo().find(gameversion.getVersionNo());
		if(versionInfo==null){
			return;
		}
		TemplateSchema templateSchema=new TemplateSchema();
		templateSchema.setTemplateid(versionInfo.getTemplateId());
		templateSchema.setIspreview(false);
		templateSchema.setExecstatus(false);
		templateSchema.setSchematime(SDF.format(new Date()));
		templateSchema.setInputtime(SDF.format(new Date()));
		templateSchema.setInputby("系统");
		templateSchema.setExt1(gameId);
		templateSchema.setExt2(versionInfo.getColorCode());
		templateSchema.setIsexecuted(false);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(templateSchema);
		return;
	}
	/**
	 * 通知牛X平台更新分区缓存
	 * @param gameId
	 */
	private void noticeniuxupdatecache(final String gameId){
		try{
			HtmlTemplate ht=new HtmlTemplate();
			ht.setTemplateid(TemplateIdConstant.TEMPLATE_GAME_FENQU);
			ht.setExt1(gameId);
			FenQuBuilder fqb=new FenQuBuilder();
			fqb.addTeamplateSchema(ht, false);
		}catch(Exception e){
			throw new RuntimeException(e);
		}
	}
}
