package com.xunlei.niux.manager.template.builder.entergame;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameInsideplace;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.PageStatisticsJs;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.template.builder.entergame.entergamethread.EnterGamePageBuilderThread;
import com.xunlei.niux.manager.template.builder.entergame.entergamethread.GameServerJsonBuilderThread;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class EnterGameBuilderV2 extends AbstractTemplateBuilder {

	private Games games = null;

	@Override
	public void executeShcema() throws Exception {
		games = GameCache.getInstance().getGameByGameId(schema.getExt1());
        if(games == null){
            throw new RuntimeException("gameId "+schema.getExt1()+"对应的games信息不存在！");
        }
        String templatePath = htmlTemplate.getTemplateroot();
        String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
        if (htmlFilePath.endsWith("/")) {
            htmlFilePath = htmlFilePath.substring(0, htmlFilePath.length() - 1);
        }

        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future pageFuture = executorService.submit(new EnterGamePageBuilderThread(templatePath, htmlFilePath, games, isPreView));
        Future jsonFuture = executorService.submit(new GameServerJsonBuilderThread(templatePath,htmlFilePath,games,isPreView));

        pageFuture.get();
        jsonFuture.get();

        executorService.shutdown();

	}

	public void manualAddTemplateSchema(final HtmlTemplate ht, TemplateSchema ts) {
		if (ts.getExt1() != null && !"".equals(ts.getExt1())) {
			FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
			return;
		}
		List<Games> glist = GameCache.getInstance().getAllGames();
		for (Games g : glist) {
            if(g.getClientType() ==0 || g.getClientType() ==1){
                ts.setExt1(g.getGameId());
                FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
            }

		}
	}




}
