package com.xunlei.niux.manager.template.builder.desknews;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class DeskNewsBuilder extends AbstractTemplateBuilder {
	@Override
	public void executeShcema() throws Exception {
		Map<String,Object> rootMap=new HashMap<String,Object>();
		Map<String,String> tempMap=getLeftPic();
		if(tempMap!=null){
			rootMap.put("hotPicMap", tempMap);
		}
		
		tempMap=getRightPic1();
		if(tempMap!=null){
			rootMap.put("hotPicMap1", tempMap);
		}
		tempMap=getRightPic2();
		if(tempMap!=null){
			rootMap.put("hotPicMap2", tempMap);
		}
		
		rootMap.put("leftTopNews_list", getLeftNews());
		rootMap.put("mnews_list", getMiddleNews());
		rootMap.put("rec_list", getrec_list());
		rootMap.put("gift_list", getgiftlist());
		rootMap.put("giftboxList", getGiftboxList());
		List<Map<String,String>> mdnews=getMiddleNews();
		if(mdnews.size()>0){
			rootMap.put("hotArticleMap",mdnews.get(0));
		}
		if(mdnews.size()>2){
			rootMap.put("mnews_list", mdnews.subList(1, mdnews.size()));
		}
		
		List<Map<String,String>> bottommdnews=getBottomMiddleNews();
		if(bottommdnews.size()>0){
			rootMap.put("hotArticleBottomMap",bottommdnews.get(0));
		}
		if(bottommdnews.size()>2){
			rootMap.put("mnews_bottom_list", bottommdnews.subList(1, mdnews.size()));
		}
		
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		if (htmlFilePath.endsWith("/")) {
			htmlFilePath = htmlFilePath.substring(0, htmlFilePath.length() - 1);
		}
		rootMap.put("gameList", getJiHuMaList());
		
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "index_2.0.ftl", rootMap, htmlFilePath+"/desknews", "index.html");
		//FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "config.niuxpackage.ftl", rootMap, htmlFilePath+"/actives/niuxpackage", "config.niuxpackage.php");
		//FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "niuxpackage.index.ftl", rootMap, htmlFilePath+"/actives/niuxpackage", "index.html");
	}
	private List<Map<String,String>> getJiHuMaList(){
		List<Map<String,String>> tempList=new ArrayList<Map<String,String>>();
		List<LinkInfo> lilists=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1274", 12, isPreView);
		for(int i=0;i<lilists.size();i++){
			LinkInfo li=lilists.get(i);
			Map<String,String> tempMap=new HashMap<String,String>();
			tempMap.put("batid", li.getLinktitle()==null?"":li.getLinktitle());
			tempMap.put("picurl", li.getPicurl()==null?"":li.getPicurl());
			tempMap.put("desc", li.getLinkdesc()==null?"":li.getLinkdesc());
			tempMap.put("value", li.getExt1()==null?"":li.getExt1());
			
			Games games=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			tempMap.put("gameid",games.getGameId());
			tempMap.put("gameno", games.getGameNo());
			tempMap.put("gamename",games.getGameName());
			tempList.add(tempMap);
		}
		return tempList;
	}
	
	private List<Map<String,String>> getGiftboxList(){
		List<Map<String,String>> tempList=new ArrayList<Map<String,String>>();
		List<LinkInfo> lilists=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1300", 2, isPreView);
		for(int i=0;i<lilists.size();i++){
			LinkInfo li=lilists.get(i);
			Map<String,String> tempMap=new HashMap<String,String>();
			tempMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			tempMap.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			tempList.add(tempMap);
		}
		return tempList;
	}
	
	private List<Map<String,String>> getgiftlist(){
		List<Map<String,String>> tempList=new ArrayList<Map<String,String>>();
		List<LinkInfo> lilists=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1272", 4, isPreView);
		for(int i=0;i<lilists.size();i++){
			LinkInfo li=lilists.get(i);
			Map<String,String> tempMap=new HashMap<String,String>();
			tempMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			tempMap.put("name", li.getLinktitle()==null?"":li.getLinktitle());
			Games games=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			tempMap.put("gamename",games.getGameName());
			tempList.add(tempMap);
		}
		return tempList;
	}
	private List<Map<String,String>> getrec_list(){
		List<Map<String,String>> tempList=new ArrayList<Map<String,String>>();
		List<LinkInfo> lilists=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1269", 3, isPreView);
		for(int i=0;i<lilists.size();i++){
			LinkInfo li=lilists.get(i);
			Map<String,String> tempMap=new HashMap<String,String>();
			tempMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			Games games=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			tempMap.put("title", games.getGameName());
			tempMap.put("picurl", li.getPicurl()==null?"":li.getPicurl());
			tempList.add(tempMap);
		}
		return tempList;
	}
	private List<Map<String,String>> getMiddleNews(){
		List<Map<String,String>> tempList=new ArrayList<Map<String,String>>();
		List<LinkInfo> lilists=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1271", 11, isPreView);
		for(int i=0;i<lilists.size();i++){
			LinkInfo li=lilists.get(i);
			Map<String,String> tempMap=new HashMap<String,String>();
			tempMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			tempMap.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			tempMap.put("addTime", li.getValiddatetime());
			tempList.add(tempMap);
		}
		return tempList;
	}
	
	private List<Map<String,String>> getBottomMiddleNews(){
		List<Map<String,String>> tempList=new ArrayList<Map<String,String>>();
		List<LinkInfo> lilists=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1301", 11, isPreView);
		for(int i=0;i<lilists.size();i++){
			LinkInfo li=lilists.get(i);
			Map<String,String> tempMap=new HashMap<String,String>();
			tempMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			tempMap.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			tempMap.put("addTime", li.getValiddatetime());
			tempList.add(tempMap);
		}
		return tempList;
	}
	
	private List<Map<String,String>> getLeftNews(){
		List<Map<String,String>> tempList=new ArrayList<Map<String,String>>();
		List<LinkInfo> lilists=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1270", 3, isPreView);
		for(int i=0;i<lilists.size();i++){
			LinkInfo li=lilists.get(i);
			Map<String,String> tempMap=new HashMap<String,String>();
			tempMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			tempMap.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			tempList.add(tempMap);
		}
		return tempList;
	}
	private Map<String,String> getRightPic1(){
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1268", 2,isPreView);
		if(list==null||list.isEmpty()){
			return null;
		}
        for(LinkInfo li:list){
            if(li.getDisplaysort()==1){
                Map<String,String> tempMap=new HashMap<String,String>();
                tempMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
                tempMap.put("picurl",li.getPicurl()==null?"":li.getPicurl());
                tempMap.put("desc", li.getLinktitle()==null?"":li.getLinktitle());
                return tempMap;
            }
        }
        return null;
	}
	private Map<String,String> getRightPic2(){
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1268", 2,isPreView);
		if(list==null||list.isEmpty()){
			return null;
		}
        for(LinkInfo li:list){
            if(li.getDisplaysort()==2){
                Map<String,String> tempMap=new HashMap<String,String>();
                tempMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
                tempMap.put("picurl",li.getPicurl()==null?"":li.getPicurl());
                tempMap.put("desc", li.getLinktitle()==null?"":li.getLinktitle());
                return tempMap;
            }
        }
        return null;
	}
	private Map<String,String> getLeftPic(){
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2("1267", isPreView);
		if(li==null){
			return null;
		}
		Map<String,String> tempMap=new HashMap<String,String>();
		tempMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
		tempMap.put("picurl",li.getPicurl()==null?"":li.getPicurl());
		tempMap.put("desc", li.getLinktitle()==null?"":li.getLinktitle());
		tempMap.put("logoUrl", li.getExt2()==null?"":li.getExt2());
		tempMap.put("logoSourceUrl", li.getExt1()==null?"":li.getExt1());
		tempMap.put("descUrl", li.getExt3()==null?"":li.getExt3());
		return tempMap;
	}
}
