package com.xunlei.niux.manager.template.builder.bonusmarket;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductCharge;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;
import org.apache.commons.lang.StringUtils;

/**
 * 生成商品详情页
 * @author lisu
 *  2015-01-28
 */
public class ProductDetailBuilder{

	private static  String productTemplateId = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("productTemplateId");	
	
	private void execRsync(final HtmlTemplate htmlTemplate){
		String execCmd=htmlTemplate.getRsyncname();//执行命
		if(execCmd==null||"".equals(execCmd)){
			return;
		}
		try {
			Runtime.getRuntime().exec(execCmd);
			Runtime.getRuntime().exec(htmlTemplate.getPreviewrsyncname());
		} catch (IOException e) {
			throw new RuntimeException("执行同步脚本："+execCmd+"出现异常",e);
		}

	}
	
	private HtmlTemplate getHtmlTemplate(){
		HtmlTemplate query = new HtmlTemplate();
    	query.setTemplateid(productTemplateId);
    	HtmlTemplate templdate = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    	return templdate;
	}
	private Gift getGift(String giftId){
		Gift query = new Gift();
		query.setGiftId(Long.parseLong(giftId));
		Gift gift = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		return gift;
	}
	
	private long getTimeStamp(String time){
		try {
			return DateUtil.parseForTimestamp(time)/1000;
		} catch (ParseException e) {
			return 0;
		}
	}

	public void build(BonusProductCharge bpc) throws Exception{
		String giftId = bpc.getProductId();
		Gift gift = getGift(giftId);
		if(gift==null){
			throw new Exception("商品基本信息不存在");
		}
		Map<String,Object> root=new HashMap<String,Object>();
		Map<String,Object> articleInfoMap=new HashMap<String,Object>();
		articleInfoMap.put("giftid", giftId);
		articleInfoMap.put("giftName", gift.getGiftName());
		articleInfoMap.put("giftBonusNum", bpc.getBonus());
		articleInfoMap.put("giftMoneyNum", 0);
		articleInfoMap.put("giftImgUrl", bpc.getPicUrl());
        articleInfoMap.put("isTimeLimit",bpc.getIsTimeLimit());
        articleInfoMap.put("startTime",bpc.getStartTime()==null?"":BonusMarketTimeFormatter.format(bpc.getStartTime()));
        articleInfoMap.put("valdateTime",bpc.getValdateTime() ==null?"":BonusMarketTimeFormatter.format(bpc.getValdateTime()));

        String manual = gift.getExt1();
        if(StringUtils.isNotEmpty(manual)){
            manual = manual.replaceAll("\\|","<br>");
        }
		articleInfoMap.put("giftManual", manual);

		articleInfoMap.put("giftContent", gift.getSimpleDesc());
		articleInfoMap.put("giftIntro", getContent(bpc.getContent()));
		articleInfoMap.put("totalNum", bpc.getTotalCount());
		if(StringTools.isNotEmpty(bpc.getValdateTime())){			
			articleInfoMap.put("giftActiveTime", getTimeStamp(bpc.getValdateTime()));
		}		
		int giftType = getGiftType(gift.getGiftType());
		articleInfoMap.put("giftType",giftType);
		Map<String,String> gameMap=new HashMap<String,String>();
		if(StringTools.isNotEmpty(gift.getGameId())){
			Games games = GameCache.getInstance().getGameByGameId(gift.getGameId());
			gameMap.put("gameName", games.getGameName());
			gameMap.put("gameNo", games.getGameNo());
			gameMap.put("gameOfficialUrl", games.getOfficialWebSite());
			gameMap.put("gameId", games.getGameId());
			articleInfoMap.put("giftGameMap", gameMap);
		}		
		root.put("giftMap", articleInfoMap);		
		HtmlTemplate htmlTemplate = getHtmlTemplate();
		String htmlFilePath=htmlTemplate.getHtmlroot();
	    String templateFilePath = htmlTemplate.getTemplateroot();
		FreemarkerUtil.buildHtml(templateFilePath,
				"detail.html", root, htmlFilePath,
				bpc.getProductId()+".html");
		execRsync(htmlTemplate);
	}
	
	private int getGiftType(String giftType){
		if(StringTools.isEmpty(giftType))return 2;
		if("product".equals(giftType))return 1;
		return 2;
	}


    private String getContent(String content) {
        //替换静态图片访问地址
        content = content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image", "src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
        content = content.replaceAll("src=\"/xlniumanager/userUploadFile/image", "src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");

        return content;
    }
}
