package com.xunlei.niux.manager.template.builder.bonusmarket;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.easyutils.html.HtmlUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 15-2-2.
 */
public class LotteryPageBuilder implements Callable {
    private static final Logger logger = Logger.getLogger(LotteryPageBuilder.class);
    private static final String actNo = "jifenshoplottery";

    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public LotteryPageBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        Map<String,Object> rootMap = new HashMap<String,Object>();
        rootMap.put("specialLotteryList",getSpecialLotteryList());
        rootMap.put("lastSpLotteryUserMap",getLastSpLotteryUserMap());
        rootMap.put("lotteryGiftInfoMap",getLotteryGiftInfoMap());

        FreemarkerUtil.buildHtml(inputPath, "lottery.html", rootMap, outputPath, "lottery.html");
        return "";
    }

    private List<Map<String,Object>> getSpecialLotteryList(){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        resultList.add(getSpecialLotteryList("815"));
        resultList.add(getSpecialLotteryList("816"));

        return resultList;
    }

    private Map<String,Object> getSpecialLotteryList(String linklocId){
        Map<String,Object> resultMap = new HashMap<String, Object>();
        List<LinkInfo> linkList = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getLinkListByOrderByLimit(linklocId, 1, "displaysort", OrderType.DESC,false);
        if(CollectionUtils.isEmpty(linkList)){
            return resultMap;
        }

        LinkInfo linkInfo = linkList.get(0);
        resultMap.put("giftName",linkInfo.getExt1());
        resultMap.put("giftValue",linkInfo.getExt2());
        resultMap.put("imgSrc",linkInfo.getPicurl());
        resultMap.put("startTime",linkInfo.getExt3().substring(0,10));
        resultMap.put("endTime",linkInfo.getExt4().substring(0,10));

        return resultMap;
    }

    private Map<String,Object> getLastSpLotteryUserMap(){
        Map<String,Object> resultMap = new HashMap<String, Object>();
        List<LinkInfo> linkList = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getLinkListByOrderByLimit("817", 1, "displaysort", OrderType.DESC,false);

        if(CollectionUtils.isEmpty(linkList)){
            return resultMap;
        }
        LinkInfo linkInfo = linkList.get(0);
        resultMap.put("userName", HtmlUtil.vagueString(linkInfo.getExt1()));
        resultMap.put("giftName",linkInfo.getExt2());
        return resultMap;

    }

    private Map<String,Object> getLotteryGiftInfoMap(){
        Map<String,Object> resultMap = new HashMap<String, Object>();
        resultMap.put("lotteryGiftIdList",getLotteryGiftIdList(actNo));
        resultMap.put("moduleId","");
        resultMap.put("bgSrc",getBgSrc());
        return resultMap;
    }

    private List<Map<String,Object>> getLotteryGiftIdList(String actNo){
        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
        if(StringUtils.isEmpty(actNo)){
            return result;
        }
        LotteryGift query = new LotteryGift();
        query.setActNo(actNo);
        query.setIsValid(true);

        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        List<LotteryGift> giftList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);

        if(CollectionUtils.isEmpty(giftList)){
            return result;
        }

        int index = 1;
        for(LotteryGift lotteryGift : giftList){
            Map<String,Object> map = new HashMap<String,Object>();
            String giftId = lotteryGift.getGiftId();
            Gift gift = getGiftById(giftId);

            if(gift == null){
                logger.error("lotteryGift: " + giftId + " not exist!");
                continue;
            }
            map.put("giftIndex",index);
            map.put("giftId",lotteryGift.getGiftId());
            map.put("giftName",lotteryGift.getGiftName());
            map.put("desc",gift.getSimpleDesc()==null?"":gift.getSimpleDesc());
            map.put("img",lotteryGift.getPhoto()==null?"":lotteryGift.getPhoto());

            result.add(map);
            index++;
        }

        return result;
    }

    private Gift getGiftById(String giftId){
        if(StringUtils.isEmpty(giftId)){
            return null;
        }
        Gift query = new Gift();
        query.setGiftId(Long.parseLong(giftId));

        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findObject(query);

        return gift;
    }

    private String getBgSrc(){
        List<LinkInfo> linkList = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getLinkListByOrderByLimit("818", 1, "displaysort", OrderType.DESC,false);

        if(CollectionUtils.isEmpty(linkList)){
            return "";
        }

        LinkInfo linkInfo = linkList.get(0);

        return linkInfo.getPicurl();
    }


}
