package com.xunlei.niux.manager.template.builder.bonusmarket;

import com.xunlei.niux.data.vipgame.dto.ProductDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 15-1-27.
 */
public class JiFenShopIndexPageBuilder implements Callable {
    private static final Logger logger = Logger.getLogger(JiFenShopIndexPageBuilder.class);

    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public JiFenShopIndexPageBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("headSliderList",getHeadSliderList());
        rootMap.put("loginADMap",getLoginADMap());
        rootMap.put("exchangeGiftList",getExchangeGiftList());
        rootMap.put("lotteryADMap",getLotteryADMap());
        rootMap.put("timeLimitGiftList", getTimeLimitGiftList());

        FreemarkerUtil.buildHtml(inputPath, "index.html", rootMap, outputPath, "index.html");
        FreemarkerUtil.buildHtml(inputPath+"include", "userbox.html", rootMap, outputPath+"include", "userbox.html");
        return "";
    }

    private List<Map<String,Object>> getHeadSliderList(){
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<LinkInfo> linkInfoList = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("812", 10, false, -1);
        if (CollectionUtils.isEmpty(linkInfoList)) {
            return resultList;
        }

        for (LinkInfo linkInfo : linkInfoList) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", linkInfo.getLinktitle() == null ? "" : linkInfo.getLinktitle());
            map.put("imgSrc", linkInfo.getPicurl() == null ? "" : linkInfo.getPicurl());
//            map.put("bgColor", linkInfo.getExt1() == null ? "" : linkInfo.getExt1()); //ext1-－背景颜色
            map.put("link", linkInfo.getLinkurl() == null ? "" : linkInfo.getLinkurl());

            resultList.add(map);
        }

        return resultList;
    }

    private Map<String,Object> getLoginADMap(){
        Map<String,Object> result = new HashMap<String,Object>();
        List<LinkInfo> infoList = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("813", 1, false);
        if(org.springframework.util.CollectionUtils.isEmpty(infoList)){
            return result;
        }
        LinkInfo info = infoList.get(0);
        result.put("imgSrc", info.getPicurl());
        result.put("link", info.getLinkurl());
        return result;
    }

    private List<Map<String,Object>> getExchangeGiftList(){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        List<ProductDTO> list = FacadeFactory.INSTANCE.getGiftRecordBo().getBonusProductChargeList(0);
        if(CollectionUtils.isEmpty(list)){
            return resultList;
        }

        List<ProductDTO> entityList = new ArrayList<ProductDTO>();
        List<ProductDTO> niuxgiftList = new ArrayList<ProductDTO>();
        List<ProductDTO> otherList = new ArrayList<ProductDTO>();

        for (ProductDTO productDTO : list) {
            if (productDTO.getGiftType() == 1) {
                entityList.add(productDTO);
            }else if(productDTO.getGiftType() == 2){
                niuxgiftList.add(productDTO);
            }else{
                otherList.add(productDTO);
            }
        }

        for(int i=0;i<5;i++){
            Map<String,Object> map = new HashMap<String, Object>();
            if(entityList.size()>i){
                map.put("entityGiftMap",getGiftMap(entityList.get(i)));
            }
            if(niuxgiftList.size()>i){
                map.put("niuxgiftGiftMap",getGiftMap(niuxgiftList.get(i)));
            }
            if(otherList.size()>i){
                map.put("otherGiftMap",getGiftMap(otherList.get(i)));
            }
            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String,Object>> getTimeLimitGiftList(){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        List<ProductDTO> list = FacadeFactory.INSTANCE.getGiftRecordBo().getTimeLimitBonusProductChargeList(0);

        if(CollectionUtils.isEmpty(list)){
            return resultList;
        }

        for(ProductDTO productDTO : list){
            Map<String,Object> map = getGiftMap(productDTO);
            resultList.add(map);
        }

        return resultList;
    }

    private Map<String,Object> getGiftMap(ProductDTO productDTO){
        DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Map<String,Object> map = new HashMap<String, Object>();
        if(productDTO == null){
            return map;
        }
        map.put("imgSrc",productDTO.getGiftImgUrl());
        map.put("bigImgSrc",productDTO.getSmallImgUrl());
        map.put("giftName",productDTO.getGiftName());
        map.put("bonusNum",productDTO.getGiftBonusNum());
        map.put("link","/exchange/"+productDTO.getGiftid()+".html");
        map.put("productId",productDTO.getGiftid());
        map.put("maxNum",productDTO.getTotalNum());
        map.put("isTimeLimit",productDTO.getIsTimeLimit());
        map.put("startTime",productDTO.getStartTime()==null?"":BonusMarketTimeFormatter.format(productDTO.getStartTime()));
        map.put("valdateTime",productDTO.getValdateTime() ==null?"":BonusMarketTimeFormatter.format(productDTO.getValdateTime()));
        long timeStamp = 0;
        Date valideDate;
        try {
            valideDate = sdf_time.parse(productDTO.getValdateTime());
            timeStamp = valideDate.getTime()/1000;
        } catch (ParseException e) {
            logger.error("validateTime parse Exception",e);
        }
        map.put("timeStamp",timeStamp);

        return map;
    }

    private Map<String,Object> getLotteryADMap(){
        Map<String,Object> result = new HashMap<String,Object>();
        List<LinkInfo> infoList = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("814", 1, false);
        if(org.springframework.util.CollectionUtils.isEmpty(infoList)){
            return result;
        }
        LinkInfo info = infoList.get(0);
        result.put("imgSrc", info.getPicurl());
        result.put("link", info.getLinkurl());
        return result;
    }




}
