package com.xunlei.niux.manager.template.builder.bonusmarket;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;

import org.apache.commons.collections.CollectionUtils;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.dto.ProductDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

/**
 * 积分兑换模版
 */
public class BonusExchangeBuilder implements Callable {


    private final static String JFSC_actNo = "jifenmarket";//积分商城：平台与盒子同步
    private String rootPath;
    private String htmlPath;
    private boolean isPreView;
    
    public BonusExchangeBuilder(String rootPath, String htmlPath, boolean isPreView) {
        this.rootPath = rootPath;
        this.htmlPath = htmlPath;
        this.isPreView = isPreView;
    }

    @Override
    public Object call() throws Exception {
        Map<String,Object> rootMap = new HashMap<String, Object>();
        Map<String,Object> giftMap = new HashMap<String, Object>();

        List<ProductDTO> list = getGiftList();
        giftMap.put("totalCount", list==null?0:list.size());
        giftMap.put("giftList", list);

        rootMap.put("giftMap", giftMap);
        FreemarkerUtil.buildHtml(rootPath, "exchange.html", rootMap, htmlPath, "exchange.html");
        buildBoxJFSC(list);//积分商城：平台与盒子同步
        return "";
    }

    public List<ProductDTO> getGiftList(){
        List<ProductDTO> list = FacadeFactory.INSTANCE.getGiftRecordBo().getBonusProductChargeList(0);
        return list;
    }

    private void buildBoxJFSC(List<ProductDTO> list){
    	Map<String,Object> rootMap = new HashMap<String, Object>();
    	
    	String gameData = "var jifenmarket_giftdata = " + JsonObjectUtil.getDataJsonObject(getGiftInfoList(list));
    	rootMap.put("giftdata",gameData);
    	
    	//写死
    	FreemarkerUtil.buildHtml("/usr/local/templatefile/gamebox/boxjfjp/", "jifenmarket_giftdata.js", rootMap, "/usr/local/templatedata/formal/gamebox/boxjfjp/", "jifenmarket_giftdata.js");
    }

    private List<Map<String,Object>> getGiftInfoList(List<ProductDTO> giftInfoDTOList){

        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        if(CollectionUtils.isEmpty(giftInfoDTOList)) {
            return resultList;
        }

        for(ProductDTO giftInfoDTO : giftInfoDTOList){
            Map<String,Object> map = new HashMap<String, Object>();
            map.put("actNo",JFSC_actNo);
            map.put("moduleId","");
            map.put("giftId",giftInfoDTO.getGiftid()==null?"":giftInfoDTO.getGiftid());
            map.put("giftName",giftInfoDTO.getGiftName()==null?"":giftInfoDTO.getGiftName());
            map.put("giftType",giftInfoDTO.getGiftType());
            map.put("consumeBonus",giftInfoDTO.getGiftBonusNum());
            map.put("leftCount",giftInfoDTO.getRemainNum());
            map.put("totalCount",giftInfoDTO.getTotalNum());
            map.put("photo",giftInfoDTO.getGiftImgUrl()==null?"":giftInfoDTO.getGiftImgUrl());
            map.put("firstLetter",giftInfoDTO.getFirstLetter()==null?"":giftInfoDTO.getFirstLetter());
            map.put("isTimeLimit",giftInfoDTO.getIsTimeLimit());
            map.put("startTime",giftInfoDTO.getStartTime()==null?"":BonusMarketTimeFormatter.format(giftInfoDTO.getStartTime()));
            map.put("valdateTime",giftInfoDTO.getValdateTime() ==null?"":BonusMarketTimeFormatter.format(giftInfoDTO.getValdateTime()));

            resultList.add(map);
        }

        return resultList;
    }
}
