package com.xunlei.niux.manager.template.builder.bonusmarket;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Activity;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by lizeyu on 2015/10/15.
 */
public class BonusActivityBuilder implements Callable{

    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public BonusActivityBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception{
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("activityList", getActing(isPreview));

       FreemarkerUtil.buildHtml(inputPath, "activity.html", rootMap, outputPath, "activity.html");
        return "";
    }

    /**
     * 获得活动页中正在进行的活动
     * @return
     */
    private List<Map<String,Object>> getActing(boolean isPreView){
        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
        List<LinkInfo> lilist= FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_BONUS_ACTIVITY, 100, isPreView);
        if(lilist == null||lilist.size()==0)return null;
        for(LinkInfo info:lilist){
            Map<String,Object> map = new HashMap<String,Object>();
            map.put("title", info.getLinktitle());
            map.put("content", info.getLinkdesc());
            map.put("url", info.getLinkurl());
            map.put("img", info.getPicurl());
            map.put("actNo", info.getExt2());

            //查询对应的活动截止时间
            String actNo = info.getExt2();
            Activity query = new Activity();
            query.setActno(actNo);
            Activity activity = FacadeFactory.INSTANCE.getBaseSo().findObject(query);

            if(activity == null){
                throw new RuntimeException("活动不存在，活动编号：" + actNo);
            }
            String beginDate = activity.getStarttime();
            String endDate = activity.getEndtime();
            map.put("beginDate", beginDate.substring(0, 10));
            map.put("endDate", endDate.substring(0, 10));

            Date currentTime = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = formatter.format(currentTime);
            int status = DateUtil.timeCompare(endDate, dateString);
            map.put("status", status);

            result.add(map);
        }
        return result;
    }
}
