package com.xunlei.niux.manager.template.builder;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.Logger;

import com.xunlei.niux.data.vipgame.bo.HtmlTemplateBo;
import com.xunlei.niux.data.vipgame.bo.TemplateSchemaBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;

/**
 * 抽象模板执行
 * @author lin
 * @date 2012-10-13
 * @Descripter:
 */
public abstract class AbstractTemplateBuilder implements ITemplateBuilder {
	private static final Logger logger=Logger.getLogger(AbstractTemplateBuilder.class.getName());
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	protected HtmlTemplate htmlTemplate;//html模板
	protected TemplateSchema schema;//模板执行计划
	protected TemplateSchemaBo templateSchemaBo;
	protected HtmlTemplateBo htmlTempalteBo;
	private boolean execSuccess=true;
	protected String execfailreason="";
	protected boolean isPreView=false;
	public void build(int schemaId) {
		logger.info("开始执行模板计划，id："+schemaId);
		long starttime=System.currentTimeMillis();//执行开始时间
		
		templateSchemaBo=FacadeFactory.INSTANCE.getTemplateSchemaBo();
		htmlTempalteBo=FacadeFactory.INSTANCE.getHtmlTemplateBo();
		
		try{
			this.schema=templateSchemaBo.find(schemaId);//获取模板执行计划
			if(schema==null){
				logger.error("模板计划id："+schemaId+"对应模板计划不存在");
			}
			
			//设置是否是预览
			isPreView=schema.getIspreview();
			
			//查询模板
			this.htmlTemplate=htmlTempalteBo.find(schema.getTemplateid());
			if(htmlTemplate==null){
				logger.error("模板id："+schema.getTemplateid()+"对应模板不存在");
				throw new RuntimeException("模板id："+schema.getTemplateid()+"对应模板不存在");
			}
			
			//清空同步文件
			execClearCmd();
			
			//执行模板生成计划
			executeShcema();
			
			//执行同步脚本
			execRsync();
			
		}catch(Exception e){
			execSuccess=false;
			execfailreason=e.getMessage();
			logger.error("模板计划id："+schemaId+"执行失败",e);
		}
		
		long endtime=System.currentTimeMillis();
		long spendtime=endtime-starttime;//执行花费时间
		
		//更新数据库
		schema.setExecstatus(execSuccess);
		schema.setExectime(sdf.format(new Date()));
		schema.setIsexecuted(true);
		schema.setSpendtime(Integer.valueOf(String.valueOf(spendtime)));
		schema.setExecfailreason(execfailreason);
		templateSchemaBo.update(schema);
		logger.info("执行完成");
	}
	/**
	 * 执行模板生成。如果生成失败，抛出异常
	 * @throws Exception
	 */
	public abstract void executeShcema()throws Exception;
	/**
	 * 执行同步脚本
	 */
	private void execRsync(){
		String execCmd="";//执行命令
		if(isPreView){
			execCmd=htmlTemplate.getPreviewrsyncname();			//执行预处理脚本
		}else{
			execCmd=htmlTemplate.getRsyncname();//执行正式脚本
		}
		if(execCmd==null||"".equals(execCmd)){
			logger.info("同步命令不存在，不需要执行同步命令");
			return;
		}
		try {
			Runtime.getRuntime().exec(execCmd);
		} catch (IOException e) {
			logger.error("执行同步脚本："+execCmd+"出现异常",e);
			throw new RuntimeException("执行同步脚本："+execCmd+"出现异常",e);
		}
	}
	/**
	 * 执行清理脚本
	 */
	private void execClearCmd(){
		String clearCmd="";
		if(isPreView){
			clearCmd=htmlTemplate.getClearpreviewrsyncfilename();
		}else{
			clearCmd=htmlTemplate.getClearrsyncfilename();
		}
		if(clearCmd==null||"".equals(clearCmd)){
			logger.info("清理命令不存在，不需要执行该命令");
			return;
		}
		try{
			Runtime.getRuntime().exec(clearCmd);
		}catch(Exception e){
			logger.error("执行同步脚本："+clearCmd+"出现异常",e);
			throw new RuntimeException("执行同步脚本："+clearCmd+"出现异常",e);
		}
	}
	/**
	 * tianjia 
	 */
    public void  addTeamplateSchema(final HtmlTemplate ht,boolean isPreview){
    	String nowStr=sdf.format(new Date());
    	//添加执行计划
		TemplateSchema ts=new TemplateSchema();
		ts.setTemplateid(ht.getTemplateid());
		ts.setSchematime(nowStr);
		ts.setIsexecuted(false);
		ts.setInputby("系统");
		ts.setInputtime(nowStr);
		ts.setIspreview(isPreview);
		ts.setExt1(ht.getExt1());
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
    }
    /**
     * 获取模板生成文件保存地址
     * @return
     */
    protected String getHtmlRoot(){
    	return isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
    }
    /**
     * 手动添加人工执行计划
     */
    public void manualAddTemplateSchema(final HtmlTemplate ht,TemplateSchema ts){
    	FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
    }
}
