package com.xunlei.niux.gameoffical.template.v2.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.PageStatisticsJs;
import com.xunlei.niux.gameoffical.template.v2.vo.GameBgVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameFenquVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameLunTangVo;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

/**
 * 生成新手卡页面
 * @author lin
 * @date 2012-9-11
 * @Descripter:
 */
public class NewCardBuilder {
	private String tempName="newcard.ftl";
	private String tempPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","temppath").trim();
	private String htmlName="newcard.shtml";
	private String htmlPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","htmlpath").trim()+"/tv2/offical/";
	private String rootPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","rootpath").trim();
	/**
	 * 生成
	 * @param luntanglist 论坛
	 * @param tuijianList 推荐游戏
	 * @param fenquList 所有分区
	 * @param gameInfo 游戏信息
	 */
	public void builder(List<GameLunTangVo> luntanglist,List<GameInfoVo> tuijianList,List<GameFenquVo> fenquList,GameInfoVo gameInfo,GameBgVo gameBg){
		htmlPath=htmlPath+gameInfo.getGameNo();//html保存路径
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("tuijiangame_data_header", HeaderBuilder.buildTeJianGameHeader(tuijianList));
		root.put("tuijiangame_data_side",SideBuilder.buildTuiJianGameSide(tuijianList));
		root.put("gameluntang_data_1", SideBuilder.buildeGameLunTang(luntanglist));
		root.put("gamefenqu_data_option_list", SideBuilder.getGameFenQuDataOptions(gameInfo.getGameId(), gameInfo.getGameNo()));
		root.put("gameinfo",SideBuilder.buildGameInfo(gameInfo));
		root.put("gamenewcard_data",buildNewCard(gameInfo.getGameId()));
		root.put("gamebg",gameBg);
		root.put("root", rootPath);
		PageStatisticsJs psjs=TempDataBuilder.getStatisticsJsNo(gameInfo.getGameId());
		root.put("gamestatitisjsno", (psjs==null||psjs.getStatisticsId()==null)?"":psjs.getStatisticsId());
		root.put("baiduId", (psjs==null||psjs.getBaiDuId()==null)?"":psjs.getBaiDuId());
		root.put("flashurl", TempDataBuilder.getFlashUrl(gameInfo.getGameId()));
        if(gameInfo.getLoadClientType() != 0) {
            tempName = "duanyou_newcard.ftl";
        }
		FreemarkerUtil.buildHtml(tempPath, tempName,root, htmlPath, htmlName);
	}
	/**
	 * 生成分区
	 * @param list
	 * @return
	 */
	public static String buildNewCard(List<GameFenquVo> list){
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		for(GameFenquVo fq:list){
			if(fq==null){
				continue;
			}
			sb.append("<li><a href=\"javascript:getnewcard('").append(fq.getGameId()).append("',")
			.append(fq.getFenQuNum()).append(",'").append(fq.getFenQuName()).append("');\">").append(fq.getFenQuName()).append("</a></li>");
		}
		return sb.toString();
	}
	public static String buildNewCard(String gameId){
		GameServers gs=new GameServers();
		gs.setGameId(gameId);
		Page page=new Page();
		page.addOrder("fenQuNum", OrderType.DESC);
		List<GameServers> list=FacadeFactory.INSTANCE.getGameServersBo().find(gs, page);
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		for(GameServers tgs:list){
			if(tgs==null){
				continue;
			}
			if("0".equals(tgs.getOpenStatus())||"2".equals(tgs.getOpenStatus())){
				continue;
			}
			sb.append("<li><a href=\"javascript:getnewcard('").append(tgs.getGameId()).append("',")
			.append(tgs.getFenQuNum()).append(",'").append(tgs.getFenQuName()).append("');\">").append(tgs.getFenQuName()).append("</a></li>");
		}
		return sb.toString();
	}
	/**
	 * 测试数据
	 * @param args
	 */
	public static void main(String[] args){
			List<GameLunTangVo> ltList=new ArrayList<GameLunTangVo>();
			GameLunTangVo lt1=new GameLunTangVo();
			lt1.setBold(false);
			lt1.setRed(true);
			lt1.setPublisher("林志军");
			lt1.setPublishDate(new Date());
			lt1.setLink("http://niu.xunlei.com");
			lt1.setType("画册仙册");
			lt1.setTitle("早点网画影仙册游戏");
			ltList.add(lt1);

			GameLunTangVo lt2=new GameLunTangVo();
			lt2.setBold(true);
			lt2.setRed(true);
			lt2.setPublisher("林志军");
			lt2.setPublishDate(new Date());
			lt2.setLink("http://niu.xunlei.com");
			lt2.setType("画册仙册");
			lt2.setTitle("早点网画影仙册游戏");
			ltList.add(lt2);

			GameLunTangVo lt3=new GameLunTangVo();
			lt3.setBold(false);
			lt3.setRed(false);
			lt3.setPublisher("林志军");
			lt3.setPublishDate(new Date());
			lt3.setLink("http://niu.xunlei.com");
			lt3.setType("画册仙册");
			lt3.setTitle("早点网画影仙册游戏");
			ltList.add(lt3);

			GameLunTangVo lt4=new GameLunTangVo();
			lt4.setBold(false);
			lt4.setRed(false);
			lt4.setPublisher("林志军");
			lt4.setPublishDate(new Date());
			lt4.setLink("http://niu.xunlei.com");
			lt4.setType("画册仙册");
			lt4.setTitle("早点网画影仙册游戏");
			ltList.add(lt4);
			List<GameInfoVo> list=new ArrayList<GameInfoVo>();
			GameInfoVo g1=new GameInfoVo();
			g1.setGameName("龙将");
			g1.setGameNo("lj");
			g1.setGameOffical("http://lj.youxi.xunlei.com");
			g1.setRunStatus("new");//新游戏
			list.add(g1);
			GameInfoVo g3=new GameInfoVo();
			g3.setGameName("大侠传");
			g3.setGameNo("dxz");
			g3.setGameOffical("http://dxz.youxi.xunlei.com");
			list.add(g3);
			GameInfoVo g4=new GameInfoVo();
			g4.setGameName("醉西游");
			g4.setGameNo("zxy");
			g4.setGameOffical("http://zxy.youxi.xunlei.com");
			g4.setRunStatus("hot");//新游戏
			list.add(g4);
			GameInfoVo g5=new GameInfoVo();
			g5.setGameName("傲视天地");
			g5.setGameNo("astd");
			g5.setGameOffical("http://astd.youxi.xunlei.com");
			g5.setRunStatus("hot");//新游戏
			list.add(g5);
			GameInfoVo g6=new GameInfoVo();
			g6.setGameName("傲世遮天");
			g6.setGameNo("aszt");
			g6.setGameOffical("http://aszt.youxi.xunlei.com");
			g6.setRunStatus("hot");//新游戏
			list.add(g6);
			GameInfoVo gameInfo=new GameInfoVo();
			gameInfo.setGameNo("sxd");
			gameInfo.setLunTangUrl("http://gamebbs.xunlei.com/forum.php?mod=forumdisplay&fid=674");
			gameInfo.setGameDesc("神仙道游戏好玩");
			gameInfo.setGameOffical("http://test.niu.xunlei.com:8080/GameOffical");
			gameInfo.setGameName("神仙道");
			List<GameFenquVo> fenqulist=new ArrayList<GameFenquVo>();
			GameFenquVo v1=new GameFenquVo();
			v1.setFenQuName("迅雷一区");
			v1.setFenQuNum(1);
			v1.setGameNo("sxd");
			v1.setOpenTime("2012-09-01 12:00:00");
			fenqulist.add(v1);
			GameFenquVo v2=new GameFenquVo();
			v2.setFenQuName("迅雷2区");
			v2.setFenQuNum(2);
			v2.setGameNo("sxd");
			v2.setOpenTime("2012-09-01 12:00:00");
			fenqulist.add(v2);
			GameFenquVo v4=new GameFenquVo();
			v4.setFenQuName("迅雷4区");
			v4.setFenQuNum(4);
			v4.setGameNo("sxd");
			v4.setOpenTime("2012-09-06 12:00:00");
			fenqulist.add(v4);
			GameFenquVo v3=new GameFenquVo();
			v3.setFenQuName("迅雷3区");
			v3.setFenQuNum(3);
			v3.setGameNo("sxd");
			v3.setOpenTime("2012-09-01 12:00:00");
			fenqulist.add(v3);
			new NewCardBuilder().builder(ltList, list,fenqulist,gameInfo,null);
	}
}
