package com.xunlei.niux.gameoffical.template.v2.builder;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.PageStatisticsJs;
import com.xunlei.niux.gameoffical.template.v2.vo.GameBgVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameFenquVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameGongGaoVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameGongLueVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameJieTuVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameLunTangVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameScrollPicVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameTeSeVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameZiLiaoVo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.niux.manager.web.util.StringUtil;

/**
 * 首页生成
 * @author lin
 * @date 2012-9-11
 * @Descripter:
 */
public class IndexBuilder {
	private String tempName="index.ftl";
	private String tempPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","temppath").trim();
	private String htmlName="index.shtml";
	private String htmlPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","htmlpath").trim()+"/tv2/offical/";
	private String rootPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","rootpath").trim();
	private static String IMG_DOMAIN=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","img_domain").trim();
	public void builder(IndexVo indexVo){
		htmlPath=htmlPath+indexVo.gameInfoVo.getGameNo();//html保存路径
		Map<String,Object> root=new HashMap<String,Object>();
		GameInfoVo gameInfo=indexVo.gameInfoVo;
		root.put("gametese_data", buildGameTese(indexVo.teSeList));
		root.put("gameziliao_data", buildGameZiliao(indexVo.ziLiaoList));
		root.put("gamegonglue_data",buildGameGongLue(indexVo.gongLueList,gameInfo.getGameNo()));
		root.put("gameluntang_data_1",SideBuilder.buildeGameLunTang(indexVo.luntangList));
		root.put("gameinfo", SideBuilder.buildGameInfo(indexVo.gameInfoVo));
		root.put("gamejietu_data",buildGameJiTu(indexVo.jieTuList));
		//root.put("gamefenqu_data", buildFenQu(indexVo.fenQuList));
		root.put("gamefenqu_data_list", getFenQuList(gameInfo.getGameId(), gameInfo.getGameNo()));
		root.put("gamefenqu_data_option_list", SideBuilder.getGameFenQuDataOptions(gameInfo.getGameId(), gameInfo.getGameNo()));
		//root.put("gamelatestfenqu_data", buildlatestfenqu(indexVo.gameInfoVo));
		root.put("gamelatestfenqu_data_list",getLatestFenQu(gameInfo.getGameId(), gameInfo.getGameNo()));
		root.put("gamenotopenfenqu_data_list", getNotOpenFenQu(gameInfo.getGameId(), gameInfo.getGameNo()));
		
		root.put("gamegonggao_data",buildGameGongGaoList(indexVo.gonggaoList));
		root.put("gamegonggao_data_scoll",buildGongGaoScroll(indexVo.gonggaoList));
		root.put("tuijiangame_data_header",HeaderBuilder.buildTeJianGameHeader(indexVo.tejianGameList));
		root.put("tuijiangame_data_side",SideBuilder.buildTuiJianGameSide(indexVo.tejianGameList));
		root.put("gamescrollpic_data", buildScrollPic(indexVo.scrollPicList));
		root.put("gamebg",indexVo.gamebg);
		root.put("root", rootPath);
		root.put("seomap", getKeyWord(indexVo.gameInfoVo.getGameId()));
		root.put("flashurl", getFlashUrl(indexVo.gameInfoVo.getGameId()));
		root.put("frieldlinklist", getFriendLink(indexVo.gameInfoVo.getGameId()));
		PageStatisticsJs psjs=TempDataBuilder.getStatisticsJsNo(indexVo.gameInfoVo.getGameId());
		root.put("gamestatitisjsno", (psjs==null||psjs.getStatisticsId()==null)?"":psjs.getStatisticsId());
		root.put("baiduId", (psjs==null||psjs.getBaiDuId()==null)?"":psjs.getBaiDuId());
		root.put("fuchenggonggao", getFuChengGuangGao(gameInfo.getGameId()));
        //公告JS，供端游嵌入式页面调用
        Map<String,Object> root2=new HashMap<String,Object>();
        root2.put("duanyouAct", indexVo.gonggaoList);
        FreemarkerUtil.buildHtml(tempPath, "duanyou_act.ftl", root2, htmlPath + "/client/js", "act.js");

		FreemarkerUtil.buildHtml(tempPath, "flash.ftl", root, htmlPath, "flash.html");
		FreemarkerUtil.buildHtml(tempPath, "customerservice.ftl", root, htmlPath, "customerservice.html");
		FreemarkerUtil.buildHtml(tempPath, "title.ftl", root, htmlPath, "title.html");
		FreemarkerUtil.buildHtml(tempPath, "friendlink.ftl", root, htmlPath, "friendlink.html");
		buildClientLunBoTu(gameInfo.getGameId());
        //端游
        if(indexVo.gameInfoVo.getLoadClientType()!=0) {
            root.put("clientlinklist", getClientLink(indexVo.gameInfoVo.getGameId()));
            FreemarkerUtil.buildHtml(tempPath, "duanyou_index.ftl", root, htmlPath, htmlName);
            return;
        }

		FreemarkerUtil.buildHtml(tempPath, tempName, root, htmlPath, htmlName);

	}
	private Map<String,String> getFuChengGuangGao(String gameId){
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId("307", gameId, false);
		Map<String,String> map=new HashMap<String,String>();
		if(li==null){
			map.put("isshow", "0");
			return map;
		}
		map.put("isshow", "1");
		map.put("linkurl", li.getLinkurl());
		map.put("imgurl", li.getPicurl());
		return map;
	}
	/**
	 * 创建游戏client轮播图
	 */
	private void buildClientLunBoTu(String gameId){
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.GAME_OFFICIAL_CLIENTLUNBOTU, gameId, 3, false);
		List<Object> rlist=new ArrayList<Object>();
		for(LinkInfo li:list){
			Map<String,String> map=new HashMap<String,String>();
			map.put("picUrl", li.getPicurl()==null?"":li.getPicurl());
			map.put("linkUrl", li.getLinkurl()==null?"":li.getLinkurl());
			rlist.add(map);
		}
		 String jsonStr=JsonObjectUtil.getDataJsonObject(rlist);
		 jsonStr="var CLIENT_LUNBOTU="+jsonStr;
	     String htmlFilePath1=htmlPath + "/client/js";
		 File file=FileUtil.createFile(htmlFilePath1, "lunbotu.js");
		 try {
			FileUploadUtil.write(file, jsonStr);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	public List<Map<String,Object>> getFriendLink(String gameId){
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		List<LinkInfo> llist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.GAME_OFFICIAL_FRIENDLINK, gameId, 30, false);
		for(LinkInfo linkinfo:llist){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("title", linkinfo.getLinktitle()==null?"":linkinfo.getLinktitle());
			map.put("linkurl", linkinfo.getLinkurl()==null?"":linkinfo.getLinkurl());
			list.add(map);
		}
		return list;
	}
	public String getFlashUrl(String gameId){
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_OFFICIAL_FLASH, gameId, false);
		if(li==null){
			return "";
		}
		return li.getPicurl()==null?"":li.getPicurl();
	}
	public Map<String,Object> getKeyWord(String gameId){
		Map<String,Object> map=new HashMap<String,Object>();
		LinkInfo linkinfo=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_OFFICIAL_KEYWORD, gameId,  false);
		if(linkinfo==null){
			linkinfo=new LinkInfo();
		}
		map.put("title",linkinfo.getLinktitle()==null?"":linkinfo.getLinktitle());
		map.put("desc",linkinfo.getLinkdesc()==null?"":linkinfo.getLinkdesc());
		map.put("keyword",linkinfo.getExt1()==null?"":linkinfo.getExt1());
		return map;
	}

    public List<Map<String,Object>> getClientLink(String gameId){
        List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
        List<LinkInfo> llist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.GAME_OFFICIAL_DUANYOU_PATH, gameId, 2, false);
        for(LinkInfo linkinfo:llist){
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("title", linkinfo.getLinktitle()==null?"":linkinfo.getLinktitle());
            map.put("url", linkinfo.getLinkurl()==null?"":linkinfo.getLinkurl());
            map.put("desc", linkinfo.getLinkdesc()==null?"":linkinfo.getLinkdesc());
            list.add(map);
        }
        return list;
    }
	/**
	 * 生成滚动图片
	 * @param list
	 * @return
	 */
	public static String buildScrollPic(List<GameScrollPicVo> list){
		StringBuffer sb1=new StringBuffer();
		if(list!=null){
			int i=1;
			for(GameScrollPicVo gsp:list){
				if(gsp==null){
					continue;
				}
				if(i>5){
					break;
				}
				sb1.append("<a href=\"").append(gsp.getLink()).append("\" target=\"_blank\" title=\"")
				   .append(StringUtil.formatHtml(gsp.getTitle())).append("\" id=\"game_scroll_img_").append(i).append("\" style=\"display: ");
				if(i==1){
					sb1.append("block");
				}else{
					sb1.append("none");
				}
				sb1.append("\"><img src=\"").append(IMG_DOMAIN+"/"+gsp.getImgUrl()).append("\" width=\"366\" height=\"260\" alt=\"\" /></a>");
				i++;
			}
		}
		sb1.append("<div class=\"bg\"></div>");
		sb1.append("<ul class=\"index\" id=\"game_scroll_img_ul\">");
		if(list!=null){
			int i=1;
			for(GameScrollPicVo gsp:list){
				if(gsp==null){
					continue;
				}
				if(i>5){
					break;
				}
				sb1.append("<li ");
				if(i==1){
					sb1.append("class=\"current\"");
				}
				sb1.append(" id=\"game_scroll_img_li_").append(i).append("\">").append(i).append("</li>");
				i++;
			}
		}
		sb1.append("</ul>");
		return sb1.toString();
	}
	/**
	 * 生成滚动公告
	 * @return
	 */
	public static String buildGongGaoScroll(List<GameGongGaoVo> list){
		int titleMaxLen=40;
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		int i=1;
		for(GameGongGaoVo gg:list){
			if(gg==null){
				continue;
			}
			int typeandnamelen=0;
			if(gg.getType()!=null){
				typeandnamelen=typeandnamelen+gg.getType().length();
			}
			if(gg.getPublisher()!=null){
				typeandnamelen=typeandnamelen+gg.getPublisher().length();
			}
			sb.append("<div class=\"con\"");
			sb.append(" id=\"advscroll").append(i).append("\"");
			if(i>1){
				sb.append(" style=\"display:none\"");
			}
			sb.append(">");
			sb.append("<span class=\"txt\"><a href=\"").append(gg.getLink()).append("\" target=\"_blank\">").append(StringUtil.formatHtml(gg.getTitle(), titleMaxLen)).append("</a></span>");
			sb.append("<span class=\"date\">").append(formatDate(gg.getPublishDate(), "yyyy-MM-dd")).append("</span></div>");
			i++;
		}
		return sb.toString();
	}
	/**
	 *生成公告list
	 * @return
	 */
	public static String buildGameGongGaoList(List<GameGongGaoVo> list){
		int titleMaxLen=25;
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		for(GameGongGaoVo gg:list){
			if(gg==null){
				continue;
			}
			int typeandnamelen=0;
			sb.append("<li ");
			if(gg.isBold()||gg.isRed()){
				String classStr="";	
				classStr=classStr+" class=\"";
				if(gg.isBold()){
					classStr=classStr+"fb ";
				}
				if(gg.isRed()){
					classStr=classStr+"fco ";
				}
				classStr=classStr.substring(0,classStr.length());
				classStr=classStr+"\"";
				sb.append(classStr);
			}
			sb.append(">");
			sb.append("<a href=\"").append(gg.getLink()).append("\" target=\"_blank\" title=\"").append(StringUtil.formatHtml(gg.getTitle()))
			  .append("\">").append(StringUtil.formatHtml(gg.getTitle(), titleMaxLen-typeandnamelen))
			  .append(" ").append(StringUtil.formatHtml(gg.getPublisher())).append("</a>");
			sb.append("<span class=\"date\">").append(formatDate(gg.getPublishDate(), "MM-dd")).append("</span>");
			
			sb.append("</li>");
		}
		return sb.toString();
	}
	/**
	 * 生成截图
	 * @return
	 */
	public static  String buildGameJiTu(List<GameJieTuVo> list){
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		for(GameJieTuVo jieTu:list){
			if(jieTu==null){
				continue;
			}
			sb.append("<li>")
			  .append("<a href=\"").append(IMG_DOMAIN+"/"+jieTu.getLink()).append("\"")
			  .append(" target=\"_blank\" title=\"").append(StringUtil.formatHtml(jieTu.getTitle()))
			  .append("\"><img src=\"").append(IMG_DOMAIN+"/"+jieTu.getImgUrl()).append("\" alt=\"\"/></a></li>");
		}
		return sb.toString();
	}
	/**
	 * 生成最新分区
	 * @return
	 */
	public static String buildlatestfenqu(GameInfoVo giv){
		StringBuilder sb=new StringBuilder();
		if(giv==null){
			return sb.toString();
		}
		GameFenquVo fenqu=giv.getLastestfenqu();
		if(fenqu==null){
			return sb.toString();
		}
		sb.append("<h3>开区时间：</h3><p>").append(fenqu.getOpenTime()).append("</p>");
		sb.append("<a href=\"javascript:gameoffical.getSeqIdAnEnterGame(\'").append(fenqu.getGameNo())
		  .append("\',").append(fenqu.getFenQuNum()).append(")\" target=\"\" title=\"").append(fenqu.getFenQuName()).append("\" class=\"btn hotbtn\">")
		  .append(fenqu.getFenQuNickName()).append("</a>");
		return sb.toString();
		
	}
	private List<Map<String,Object>> getLatestFenQu(String gameId,String gameNo){
		List<Map<String,Object>> latestFenQuList=new ArrayList<Map<String,Object>>();
		GameServers gs= FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(gameId, false);
		if(gs!=null){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("gameNo", gameNo);
			map.put("gameId", gameId);
			map.put("fenQuNum", gs.getFenQuNum());
			map.put("fenQuNickName", (gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName()))?gs.getFenQuName():gs.getFenQuNickName());
			map.put("openTime", gs.getOpenTime()+"");
			latestFenQuList.add(map);
		}
		return latestFenQuList;
	}
	private List<Map<String,Object>> getNotOpenFenQu(String gameId,String gameNo){
		List<Map<String,Object>> notOpenFenQuList=new ArrayList<Map<String,Object>>();
		GameServers qgs=new GameServers();
		qgs.setGameId(gameId);
		qgs.setOpenStatus("0");
		Page page=new Page();
		page.addOrder("fenQuNum", OrderType.ESC);
		List<GameServers> gslist=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page);
		for(GameServers gs:gslist){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("gameNo", gameNo);
			map.put("gameId", gameId);
			map.put("fenQuNum", gs.getFenQuNum());
			map.put("fenQuNickName", (gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName()))?gs.getFenQuName():gs.getFenQuNickName());
			map.put("openTime", gs.getOpenTime()+"");
			map.put("openStatus", gs.getOpenStatus());
			notOpenFenQuList.add(map);
		}
		return notOpenFenQuList;
	}
	/**
	 * 生成分区列表
	 * @return
	 */
	public static String buildFenQu(List<GameFenquVo> list){
		StringBuilder sb=new StringBuilder();
		GameFenquVo lastfenqu=null;
		if(list==null){
			return sb.toString();
		}
		for(GameFenquVo fenqu:list){
			if(fenqu==null){
				continue;
			}
			sb.append("<li><a href=\"javascript:gameoffical.getSeqIdAnEnterGame(\'").append(fenqu.getGameNo())
			  .append("\',").append(fenqu.getFenQuNum()).append(")\" target=\"\" title=\"").append(fenqu.getFenQuName()).append("\" class=\"btn areabtn\">")
			  .append(fenqu.getFenQuNickName()).append("</a></li>");
			if(lastfenqu==null){
				lastfenqu=fenqu;
			}else if(fenqu.getFenQuNum()>lastfenqu.getFenQuNum()){
				lastfenqu=fenqu;
			}
		}
		return sb.toString();
	}
	/**
	 * 获取游戏分区列表
	 * @param gameId
	 * @param gameNo
	 * @return
	 */
	private static List<Map<String,String>> getFenQuList(String gameId,String gameNo){
		GameServers qgs=new GameServers();
		qgs.setGameId(gameId);
		Page page=new Page();
		page.addOrder("fenQuNum", OrderType.DESC);
		List<GameServers> gslist=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page);
		List<Map<String,String>> list=new ArrayList<Map<String,String>>();
		for(GameServers gs:gslist){
			if("0".equals(gs.getOpenStatus())){
				continue;
			}
			Map<String,String> map=new HashMap<String,String>();
			map.put("gameNo", gameNo);
			map.put("fenQuNum", String.valueOf(gs.getFenQuNum()));
			String fenQuNickName="";
			if("1".equals(gs.getOpenStatus())){
				fenQuNickName=(gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName())?gs.getFenQuName():gs.getFenQuNickName());
			}else if("3".equals(gs.getOpenStatus())){
				fenQuNickName=gs.getFenQuNum()+"区(维护中)";
			}else if("2".equals(gs.getOpenStatus())){
				fenQuNickName=gs.getFenQuNum()+"区(已关闭)";
			}
			map.put("fenQuNickName", fenQuNickName);
			map.put("openStatus", gs.getOpenStatus());
			list.add(map);
		}
		return list;
	}
	/**
	 * 生成游戏信息
	 * @return
	 */
	public static GameInfoVo buildGameInfo(GameInfoVo giv){
		GameInfoVo gameinfo=new GameInfoVo();
		gameinfo.setGameDesc(StringUtil.formatHtml(giv.getGameDesc()));
		gameinfo.setLunTangUrl(StringUtil.formatHtml(giv.getLunTangUrl()));
		gameinfo.setGameName(StringUtil.formatHtml(giv.getGameName()));
		return gameinfo;
	}
	/**
	 * 生成游戏攻略
	 * @return
	 */
	public static String buildGameGongLue(List<GameGongLueVo> list,String gameNo){
		int titleMaxLen=16;
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		sb.append("<ul class=\"newslist\">");
		for(int i=0;i<list.size();i=i+2){
			GameGongLueVo gonglue=list.get(i);
			if(gonglue==null){
				continue;
			}
			sb.append("<li ");
			if(gonglue.isBold()||gonglue.isRed()){
				String classStr="";	
				classStr=classStr+" class=\"";
				if(gonglue.isBold()){
					classStr=classStr+"fb ";
				}
				if(gonglue.isRed()){
					classStr=classStr+"fco ";
				}
				classStr=classStr.substring(0,classStr.length());
				classStr=classStr+"\"";
				sb.append(classStr);
			}
			sb.append(">");
			sb.append("<a href=\"").append(gonglue.getLink()).append("\" target=\"_blank\" title=\"").append(StringUtil.formatHtml(gonglue.getTitle()))
			  .append("\">").append(StringUtil.formatHtml(gonglue.getTitle(), titleMaxLen)).append("</a><span class=\"date\">")
			  .append(formatDate(gonglue.getPublishDate(), "yyyy-MM-dd")).append("</span></li>");
		}
		sb.append("</ul>");
		sb.append("<div class=\"line\"></div>");
		sb.append("<ul class=\"newslist right\">");
		for(int i=1;i<list.size();i=i+2){
			if(i==19){
				sb.append("<li><a href=\"tv2/offical/").append(gameNo).append("/GameStrategyList.shtml")
				  .append("\" target=\"_blank\">更多&gt;&gt;</a></li>");
				continue;
			}
			GameGongLueVo gonglue=list.get(i);
			if(gonglue==null){
				continue;
			}
			sb.append("<li ");
			if(gonglue.isBold()||gonglue.isRed()){
				String classStr="";	
				classStr=classStr+" class=\"";
				if(gonglue.isBold()){
					classStr=classStr+"fb ";
				}
				if(gonglue.isRed()){
					classStr=classStr+"fco ";
				}
				classStr=classStr.substring(0,classStr.length());
				classStr=classStr+"\"";
				sb.append(classStr);
			}
			sb.append(">");
			sb.append("<a href=\"").append(gonglue.getLink()).append("\" target=\"_blank\" title=\"").append(StringUtil.formatHtml(gonglue.getTitle()))
			  .append("\">").append(StringUtil.formatHtml(gonglue.getTitle(), titleMaxLen)).append("</a><span class=\"date\">")
			  .append(formatDate(gonglue.getPublishDate(), "yyyy-MM-dd")).append("</span></li>");
		}
		sb.append("</ul>");
		return sb.toString();
	}
	/**
	 * 生成游戏特色
	 * @return
	 */
	public static String buildGameTese(List<GameTeSeVo> list){
		int titleMaxLen=7;
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		int liindex=1;//每行显示5个（li）
		boolean liendflag=true;//已结束
		for(GameTeSeVo tese:list){
			if(tese==null){
				continue;
			}
			if(liindex==1){
				sb.append("<li>");
				liendflag=false;
			}
			//添加span内容
			sb.append("<span><a  href=\"").append(tese.getLink()).append("\" target=\"_blank\" ");
			if(tese.isBold()||tese.isRed()){
				String classStr="";	
				classStr=classStr+" class=\"";
				if(tese.isBold()){
					classStr=classStr+"fb ";
				}
				if(tese.isRed()){
					classStr=classStr+"fco ";
				}
				classStr=classStr.substring(0,classStr.length());
				classStr=classStr+"\"";
				sb.append(classStr);
			}
			sb.append("title=\"")
			  .append(StringUtil.formatHtml(tese.getTitle())).append("\">").append(StringUtil.formatHtmlFixedLen(tese.getTitle(),titleMaxLen)).append("</a></span>");
			if(liindex==5){
				sb.append("</li>");
				liindex=1;//设置为1表示li重头开始
				liendflag=true;
				continue;
			}
			liindex++;
		}
		//判断是否li没有结束
		if(!liendflag){
			sb.append("</li>");
		}
		return sb.toString();
	}
	/**
	 * 生成资料
	 * @return
	 */
	public static  String buildGameZiliao(List<GameZiLiaoVo> list){
		int titleMaxLen=7;//标题最长字数
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		int liindex=1;//每行显示5个（li）
		boolean liendflag=true;//已结束
		for(GameZiLiaoVo ziliao:list){
			if(ziliao==null){
				continue;
			}
			if(liindex==1){
				sb.append("<li>");
				liendflag=false;
			}
			//添加span内容
			sb.append("<span");
			sb.append("><a href=\"").append(ziliao.getLink()).append("\" target=\"_blank\" ");
			if(ziliao.isBold()||ziliao.isRed()){
				String classStr="";	
				classStr=classStr+" class=\"";
				if(ziliao.isBold()){
					classStr=classStr+"fb ";
				}
				if(ziliao.isRed()){
					classStr=classStr+"fco ";
				}
				classStr=classStr.substring(0,classStr.length());
				classStr=classStr+"\"";
				sb.append(classStr);
			}
			sb.append("title=\"")
			  .append(StringUtil.formatHtml(ziliao.getTitle())).append("\">").append(StringUtil.formatHtmlFixedLen(ziliao.getTitle(),titleMaxLen)).append("</a></span>");
			if(liindex==5){
				sb.append("</li>");
				liindex=1;//设置为1表示li重头开始
				liendflag=true;
				continue;
			}
			liindex++;
		}
		//判断是否li没有结束
		if(!liendflag){
			sb.append("</li>");
		}

		return sb.toString();
	}
	/**
	 * 时间格式
	 * @param date
	 * @param pattern
	 * @return
	 */
	private static String formatDate(Date date,String pattern){
		if(date==null){
			return "";
		}
		try{
			SimpleDateFormat sdf=new SimpleDateFormat(pattern);
			return sdf.format(date);
		}catch(Exception e){
			e.printStackTrace();
			return "";
		}
	}
	public static class IndexVo{
		public List<GameZiLiaoVo> ziLiaoList=new ArrayList<GameZiLiaoVo>();//游戏资料
		public List<GameTeSeVo> teSeList=new ArrayList<GameTeSeVo>();//游戏特色
		public List<GameGongLueVo> gongLueList=new ArrayList<GameGongLueVo>();//游戏攻略
		public List<GameLunTangVo> luntangList=new ArrayList<GameLunTangVo>();//论坛
		public List<GameJieTuVo> jieTuList=new ArrayList<GameJieTuVo>();//游戏截图
		public List<GameFenquVo> fenQuList=new ArrayList<GameFenquVo>();//游戏分区
		public GameInfoVo gameInfoVo;//游戏信息
		public List<GameGongGaoVo> gonggaoList=new ArrayList<GameGongGaoVo>();//公告
		public List<GameInfoVo> tejianGameList=new ArrayList<GameInfoVo>();//推荐游戏
		public List<GameScrollPicVo> scrollPicList=new ArrayList<GameScrollPicVo>();//滚动图片
		public GameBgVo gamebg;//游戏背景
	}
}
