package com.xunlei.niux.gameoffical.template.v2.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.niux.manager.web.util.StringUtil;

/**
 * 头部生成
 * @author lin
 * @date 2012-9-11
 * @Descripter:
 */
public class HeaderBuilder {
	private String tempName="header.ftl";
	private String tempPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","temppath").trim();
	private String htmlName="header.shtml";
	private String htmlPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","htmlpath").trim()+"/tv2/offical/";
	private String rootPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","rootpath").trim();
	private static String IMG_DOMAIN=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","img_domain").trim();
	public void builder(List<GameInfoVo> tuijianList,GameInfoVo gameInfo){
		htmlPath=htmlPath+gameInfo.getGameNo();
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("tuijiangame_data_header", buildTeJianGameHeader(tuijianList));
		root.put("root", rootPath);
		root.put("gameinfo", SideBuilder.buildGameInfo(gameInfo));
		FreemarkerUtil.buildHtml(tempPath, tempName, root, htmlPath, htmlName);
	}
	/**
	 * 生成推荐游戏（头部的）
	 * @return
	 */
	public static String buildTeJianGameHeader(List<GameInfoVo> list){
		int titleMaxLen=10;
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		for(int i=0;i<4&&i<list.size();i++){
			GameInfoVo giv=list.get(i);
			sb.append("<li><a href=\"")
			.append(giv.getGameOffical()).append("\" target=\"_blank\"");
			if(giv.getBold()||giv.getRed()){
				sb.append(" class=\"");
				if(giv.getBold()){
					sb.append("fb ");
				}
				if(giv.getRed()){
					sb.append("fco");
				}
				sb.append("\"");
			}
			sb.append(" title=\"").append(StringUtil.formatHtml(giv.getGameName())).append("\" >");
			sb.append("<img  width=\"16\" height=\"16\" src=\"").append(IMG_DOMAIN).append("/").append(giv.getLogoUrl()).append("\"/>");
			sb.append(StringUtil.formatHtml(giv.getGameName(), titleMaxLen)).append("</a></li>");
		}
		return sb.toString();
	}
	/**
	 * 测试数据
	 * @param args
	 */
	public static void main(String[] args){
		List<GameInfoVo> list=new ArrayList<GameInfoVo>();
		GameInfoVo g1=new GameInfoVo();
		g1.setGameName("龙将");
		g1.setGameNo("lj");
		g1.setGameOffical("http://lj.youxi.xunlei.com");
		g1.setRunStatus("new");//新游戏
		list.add(g1);
		GameInfoVo g3=new GameInfoVo();
		g3.setGameName("大侠传");
		g3.setGameNo("dxz");
		g3.setGameOffical("http://dxz.youxi.xunlei.com");
		//g3.setRunStatus("hot");//新游戏
		list.add(g3);
		GameInfoVo g5=new GameInfoVo();
		g5.setGameName("傲视天地");
		g5.setGameNo("astd");
		g5.setGameOffical("http://astd.youxi.xunlei.com");
		g5.setRunStatus("hot");//新游戏
		list.add(g5);
		GameInfoVo g6=new GameInfoVo();
		g6.setGameName("傲世遮天");
		g6.setGameNo("aszt");
		g6.setGameOffical("http://aszt.youxi.xunlei.com");
		g6.setRunStatus("hot");//新游戏
		list.add(g6);
		GameInfoVo gameinfo=new GameInfoVo();
		gameinfo.setGameNo("sxd");
		new HeaderBuilder().builder(list, gameinfo);
	}
}
