package com.xunlei.niux.gameoffical.model;

import java.util.List;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import org.apache.log4j.Logger;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameContent;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.gameoffical.template.v2.builder.AllGameInfoBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.BgBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.EnterGameBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.HeaderAllGamesBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.HeaderBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.IndexBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.NewCardBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.NoticeContentBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.NoticeListBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.RegsiterBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.SideBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.TempDataBuilder;
import com.xunlei.niux.gameoffical.template.v2.builder.IndexBuilder.IndexVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameBgVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
/**
 * 游戏官网
 * @author lin
 * @date 2012-9-12
 * @Descripter:
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMEOFFICIAL)
public class GameOfficalManagedBean extends BaseManagedBean{
	private static final Logger logger=Logger.getLogger(GameOfficalManagedBean.class.getName());
	private static String syngameoffical=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","syngameoffical").trim();//同步逛网
	private static String testsyngameoffical=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","testsyngameoffical").trim();;//测试同步
	private static String cleargameoffical=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","cleargameoffical").trim();;//测试同步
	private static boolean isCreateTempalteing=false;//是否正在生成模板
	/**
	 * 生成官网
	 * @return
	 */
	public String buildTemplate(){	
		try{
			if(isCreateTempalteing){
				alertJS("其他人正在生成模板，请稍后再生成！");
				return "";
			}
			isCreateTempalteing=true;
			//清空以前生成的静态页面
			Runtime.getRuntime().exec(cleargameoffical);
			//
			UserInfo user=this.currentUserInfo();
			logger.info("用户"+user.getTrueName()+" 生成官网模板");
			Games gameInfo=this.findBean(Games.class,"games");
			long gameFK=gameInfo.getSeqId();
			logger.info("游戏id："+gameFK);
			IndexVo indexVo=new IndexVo();
			indexVo.fenQuList=TempDataBuilder.getAllFenQu(gameFK);
			indexVo.gameInfoVo=TempDataBuilder.getGameInfo(gameFK);
			indexVo.gonggaoList=TempDataBuilder.getGongGaoList(gameFK);
			indexVo.gongLueList=TempDataBuilder.getGongLueList(gameFK);
			indexVo.jieTuList=TempDataBuilder.getGameJieTu(gameFK);
			indexVo.luntangList=TempDataBuilder.getLunTangList(gameFK);
			indexVo.scrollPicList=TempDataBuilder.getScrollPic(gameFK);
			indexVo.tejianGameList=TempDataBuilder.getTuiJianGameList(gameFK);
			indexVo.teSeList=TempDataBuilder.getTeSeList(gameFK);
			indexVo.ziLiaoList=TempDataBuilder.getZiLiaoList(gameFK);
			indexVo.gamebg=TempDataBuilder.getGameBg(gameFK);
			List<GameInfoVo> allgameinfolist=TempDataBuilder.getAllGameList();
			new HeaderAllGamesBuilder().builder(allgameinfolist);
			new HeaderBuilder().builder(indexVo.tejianGameList, indexVo.gameInfoVo);
			new SideBuilder().builder(indexVo.luntangList, indexVo.tejianGameList, indexVo.fenQuList, indexVo.gameInfoVo);
			new IndexBuilder().builder(indexVo);
			new NoticeListBuilder().builder(indexVo.luntangList, indexVo.tejianGameList, indexVo.fenQuList, indexVo.gameInfoVo,indexVo.gamebg);
			new NewCardBuilder().builder(indexVo.luntangList, indexVo.tejianGameList, indexVo.fenQuList, indexVo.gameInfoVo,indexVo.gamebg);
			new BgBuilder().builder(indexVo.gameInfoVo, indexVo.gamebg);
			new AllGameInfoBuilder().builder(allgameinfolist);
			new EnterGameBuilder().builder();
			new RegsiterBuilder().bulider();
			Runtime.getRuntime().exec(syngameoffical);
			isCreateTempalteing=false;
			alertJS("模板成功生成");
			return "";
		}catch(Exception e){
			logger.info("生成官网模板出现异常",e);
			isCreateTempalteing=false;
			alertJS("模板生成出现异常"+e.getMessage());
			return "";
		}
	}
	public String buildTemplateTest(){	
		try{
			if(isCreateTempalteing){
				alertJS("其他人正在生成模板，请稍后再生成！");
				return "";
			}
			isCreateTempalteing=true;
			//清空以前生成的静态页面
			Runtime.getRuntime().exec(cleargameoffical);
			//
			UserInfo user=this.currentUserInfo();
			logger.info("用户"+user.getTrueName()+" 生成官网模板");
			Games gameInfo=this.findBean(Games.class,"games");
			long gameFK=gameInfo.getSeqId();
			logger.info("游戏id："+gameFK);
			IndexVo indexVo=new IndexVo();
			indexVo.fenQuList=TempDataBuilder.getAllFenQu(gameFK);
			indexVo.gameInfoVo=TempDataBuilder.getGameInfo(gameFK);
			indexVo.gonggaoList=TempDataBuilder.getGongGaoList(gameFK);
			indexVo.gongLueList=TempDataBuilder.getGongLueList(gameFK);
			indexVo.jieTuList=TempDataBuilder.getGameJieTu(gameFK);
			indexVo.luntangList=TempDataBuilder.getLunTangList(gameFK);
			indexVo.scrollPicList=TempDataBuilder.getScrollPic(gameFK);
			indexVo.tejianGameList=TempDataBuilder.getTuiJianGameList(gameFK);
			indexVo.teSeList=TempDataBuilder.getTeSeList(gameFK);
			indexVo.ziLiaoList=TempDataBuilder.getZiLiaoList(gameFK);
			indexVo.gamebg=TempDataBuilder.getGameBg(gameFK);
			List<GameInfoVo> allgameinfolist=TempDataBuilder.getAllGameList();
			new HeaderAllGamesBuilder().builder(allgameinfolist);
			new HeaderBuilder().builder(indexVo.tejianGameList, indexVo.gameInfoVo);
			new SideBuilder().builder(indexVo.luntangList, indexVo.tejianGameList, indexVo.fenQuList, indexVo.gameInfoVo);
			new IndexBuilder().builder(indexVo);
			new NoticeListBuilder().builder(indexVo.luntangList, indexVo.tejianGameList, indexVo.fenQuList, indexVo.gameInfoVo,indexVo.gamebg);
			new NewCardBuilder().builder(indexVo.luntangList, indexVo.tejianGameList, indexVo.fenQuList, indexVo.gameInfoVo,indexVo.gamebg);
			new BgBuilder().builder(indexVo.gameInfoVo, indexVo.gamebg);
			new AllGameInfoBuilder().builder(allgameinfolist);
			new EnterGameBuilder().builder();
			new RegsiterBuilder().bulider();
			Runtime.getRuntime().exec(testsyngameoffical);
			isCreateTempalteing=false;
			alertJS("预览模板成功生成");
			return "";
		}catch(Exception e){
			logger.info("生成官网预览模板出现异常",e);
			isCreateTempalteing=false;
			alertJS("预览模板生成出现异常"+e.getMessage());
			return "";
		}
	}
	/**
	 * 生成通知内容
	 * @return
	 */
	public String buildGameContentTemplate(){
		try{
			if(isCreateTempalteing){
				alertJS("其他人正在生成模板，请稍后再生成！");
				return "";
			}
			isCreateTempalteing=true;
			//清空以前生成的静态页面
			Runtime.getRuntime().exec(cleargameoffical);
			//
			UserInfo user=this.currentUserInfo();
			logger.info("用户"+user.getTrueName()+" 生成游戏通知模板模板");
			GameContent query=this.findBean(GameContent.class,"niux_gamecontent");
			logger.info("游戏id："+query.getGameFK());
			GameContent content=FacadeFactory.INSTANCE.getGameContentBo().findGameContentById(query.getSeqId());
			GameBgVo gameBg=TempDataBuilder.getGameBg(query.getGameFK());
			String url=new NoticeContentBuilder().builder(content, TempDataBuilder.getGameInfo(content.getGameFK()),gameBg);
			GameContent content1=FacadeFactory.INSTANCE.getGameContentBo().findGameContentById(query.getSeqId());
			content1.setJumpUrl(url);
			FacadeFactory.INSTANCE.getGameContentBo().update(content1);
			Runtime.getRuntime().exec(syngameoffical);
			isCreateTempalteing=false;
			alertJS("模板成功生成");
			return "";
		}catch(Exception e){
			logger.info("生成游戏通知模板出现异常",e);
			isCreateTempalteing=false;
			alertJS("模板生成出现异常"+e.getMessage());
			return "";
		}
	}
	/**
	 * 生成游戏列表模板
	 * @return
	 */
	public String buildAllGameTemplate(){
		try{
			UserInfo user=this.currentUserInfo();
			logger.info("用户"+user.getTrueName()+" 生成游戏列表模板");
			new HeaderAllGamesBuilder().builder(TempDataBuilder.getAllGameList());
			return "";
		}catch(Exception e){
			logger.info("生成游戏列表模板出现异常",e);
			return "";
		}
	}
}
