package com.xunlei.niux.manager.web.vo;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: jx
 * Date: 13-10-22
 * Time: 下午2:18
 * To change this template use File | Settings | File Templates.
 */
public class UserRebateDateRecordTask {
    private static final Logger logger = Logger.getLogger(UserRebateDateRecordTask.class.getName());
    private static String time = null;
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    static{
        if(time == null){
            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.DAY_OF_YEAR, -1);

            time = sdf.format(cal.getTime());//当前时间的前一天
        }
    }

    public static void main(String[] args){
        logger.info("开始获取最近的统计日期");
        String lastDate = getLatestCountDate();
        logger.info("最近统计日期获取完成");

        Date startDate = null;
        if(StringUtils.isNotEmpty(lastDate)){
            try {
                Date date = sdf.parse(lastDate);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(Calendar.DAY_OF_YEAR,1);
                startDate = calendar.getTime();
            }catch (ParseException e){
                logger.error("Oops, Exception when get startDate!",e);
            }
            logger.info("统计日期："+sdf.format(startDate) +" 到 "+time);
        }else {
            logger.info("统计日期："+time+"之前所有数据");
        }
        logger.info("开始统计会员返利日报数据");
        makeDateRecord(startDate);
        logger.info("会员返利日报数据统计完成");
    }

    public static String getLatestCountDate(){
        String date="";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try{
            conn = DBConnUtil.getConnection("niux_vip");
            String sql = "SELECT DISTINCT recordDate FROM user_rebate_daterecord ORDER BY recordDate DESC LIMIT 1;";
            logger.info("getLatestCountDate sql: "+sql);
            stmt = DBConnUtil.getStatement(conn);
            rs = stmt.executeQuery(sql);
            if(rs.next()){
                date = rs.getString(1);
            }
        }catch(Exception e){
            logger.error("Error!",e);
        }finally{
            try{
                if(stmt != null){
                    stmt.close();
                    stmt = null;
                }
                if(conn != null){
                    conn.close();
                    conn = null;
                }
                if(rs != null){
                    rs.close();
                    rs = null;
                }
            }catch(Exception e){
                logger.error("Error!",e);
            }
        }
        return date;
    }

    public static void makeDateRecord(Date startDate){
        Connection conn = null;
        PreparedStatement insertstmt = null;
        try{
            conn = DBConnUtil.getConnection("niux_vip");
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO user_rebate_daterecord (gameId,recordDate,rebateMoney) ");
            sql.append("(SELECT  gameId,DATE(recordTime) AS recordDate,SUM(payOrderMoney) AS rebateMoney FROM user_rebate_record where ");
            if(startDate!=null){
               sql.append(" DATE(recordTime) >= Date('"+sdf.format(startDate)+"') and ");
            }
            sql.append("DATE(recordTime) <= Date('"+time+"')");
            sql.append("GROUP BY gameId,DATE(recordTime)) UNION ");
            sql.append("(SELECT '000000' AS gameId, DATE(recordTime) AS recordDate,SUM(payOrderMoney) AS rebateMoney FROM user_rebate_record WHERE ");
            if(startDate!=null){
                sql.append(" DATE(recordTime) >= Date('"+sdf.format(startDate)+"') and ");
            }
            sql.append("DATE(recordTime) <= Date('"+time+"')");
            sql.append("GROUP BY DATE(recordTime))");
            insertstmt = conn.prepareStatement(sql.toString());
            int rows = insertstmt.executeUpdate();
            logger.info("成功生成"+rows+"条统计数据");
        }catch(Exception e){
            logger.error("Error!",e);
        }finally{
            try{
                if(insertstmt != null){
                    insertstmt.close();
                    insertstmt = null;
                }
                if(conn != null){
                    conn.close();
                    conn = null;
                }
            }catch(Exception e){
                logger.error("Error!",e);
            }
        }

    }
}
