package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import com.xunlei.niux.manager.web.util.HttpClientUtil;

/**
 * 更新充值页面手机的用户QQ号到客户查询中
 * @author lisu
 * 2013-05-11
 */
public class UpdateCustomerQQTask {

	private static final Logger logger = Logger.getLogger(UpdateCustomerQQTask.class.getName());	
	private static String URL = "http://websvr.niu.xunlei.com/queryUserInfo.gameUserInfo?";
	private static final int MAXCOUNT = 200;//设置调用接口最多可以有多少个账号
    private static String time = null;
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间
		}
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		logger.info("开始更新充值页面手机的用户QQ号到客户查询中......");	
		updateAutoProduct();
		logger.info("充值页面手机的用户QQ号到客户查询中更新完毕！");	
	}

	/**
	 * 充值页面手机的用户QQ号到客户查询中
	 */
	public static void updateAutoProduct(){
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		String starttime = TaskLogUtil.getNowTime();
		try{
		    conn = ConnUtil.getConnection();
		    String sql = "select count(*) from customerinfo WHERE checkflag = 0 AND uid IS NULL";
		    stmt = conn.prepareStatement(sql);		    
		    rs = stmt.executeQuery();
		    rs.next();
		    int count = rs.getInt(1);
		    
		    sql = "SELECT account,qq FROM customerinfo WHERE checkflag = 0 AND uid IS NULL;";
		    stmt = conn.prepareStatement(sql);		    
		    rs = stmt.executeQuery();		    
		    		    
		    int i = 0;
		    String myaccounts = "";
		    List<String> qqs = new ArrayList<String>();
		    List<String> accounts = new ArrayList<String>();

		    logger.info("count=================>"+count);
		    while(rs.next()){		    	
		    	String account = rs.getString(1);
		    	String qq = rs.getString(2);
		    	myaccounts += account+",";
		    	accounts.add(account);
		    	qqs.add(qq);
		    	if(i==MAXCOUNT){
		    		String responseText = HttpClientUtil.getHtml(URL+"gameid=000069&type=300&accounts="+myaccounts);		
		    		update(responseText,accounts,qqs);
		    		i = 0;
		    		myaccounts = "";
		    		accounts.clear();
		    		qqs.clear();
		    	}else if(i == count-1){
		    		String responseText = HttpClientUtil.getHtml(URL+"gameid=000069&type=300&accounts="+myaccounts);		
		    		update(responseText,accounts,qqs);
		    		i = 0;
		    		myaccounts = "";
		    		accounts.clear();
		    		qqs.clear();
		    	}
		    	i++;
		    }
		    
		    String endtime = TaskLogUtil.getNowTime();
		    TaskLogUtil.addLog("充值页面手机的用户QQ号到客户查询中", null, starttime, endtime, true);
		    if(qqs != null && qqs.size() > 0){
		    	qqs.clear();
		    	qqs = null;
		    }
		}catch(Exception e){
			logger.info("update customer qq failure.The exception:"+e.getMessage()+",time="+time);
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("充值页面手机的用户QQ号到客户查询中", e.getMessage(), starttime, endtime, false);
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}	
	}
	
	/**
	 * 更新数据
	 * @param reponseText
	 * @param qqs
	 */
	private static void update(String responseText,List<String> accounts,List<String> qqs) throws Exception {
		responseText = responseText.replace("{", "").replace("}", "").replace("\"", "");
		String strs[] = responseText.split(",");
		String statuesText[] = strs[1].split(":");
		if(!"0".equals(statuesText[1])){
			throw new RuntimeException("调用账号转换接口失败,code="+statuesText[1]);
		}
		String resultText[] = strs[0].split(":");
		String uidsText = resultText[1].trim();
		String uids[] = uidsText.split("&");
		Connection conn = null;
		Connection uconn = null;
		PreparedStatement stmt = null;
		PreparedStatement ustmt = null;
		try{
			conn = ConnUtil.getConnection();
			uconn = ConnUtil.getConnection();
			for(int i=0;i<uids.length;i++){
				String uid = uids[i].split("=")[1].trim();
				String qq = qqs.get(i);
				String account = accounts.get(i);
				String sql = "update customerdetailquery set qq =1? where uid = 2? ";
				sql = sql.replace("1?", "'"+qq+"'").replace("2?", "'"+uid+"'");
				stmt = conn.prepareStatement(sql);	
				stmt.executeUpdate();
				sql = "update customerinfo set checkflag = 1,uid=1? where account = 2?";
				sql = sql.replace("1?", "'"+uid+"'").replace("2?", "'"+account+"'");
				logger.info("sql================>"+sql);
				ustmt = uconn.prepareStatement(sql);
				ustmt.executeUpdate();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(ustmt != null){
					ustmt.close();
					ustmt = null;
				}
				if(uconn != null){
					uconn.close();
					uconn = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}	
	}
}
