package com.xunlei.niux.manager.web.vo;


import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import com.xunlei.niux.manager.web.util.HttpClientUtil;


/**
 * 生成充值客户信息
 * @author lisu
 * 2013-03-02
 */
public class UpdateCustomerLoginTimeTask {
	private static final Logger logger = Logger.getLogger(UpdateCustomerLoginTimeTask.class.getName());
	private static String time = null;
	private static String customerInterface = "http://tw07286.sandai.net:8002/getPayAndLoginRecord?";
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 cal.add(Calendar.DAY_OF_MONTH, -1);
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间的前一天
		}
	}
	
	
	public static void main(String args[]){
	   make();
	}
	
	/**
	 * 生成文件到文件服务器，更新客户信息，并且生成大客户记录
	 */
	public static void make(){	
	   logger.info("开始生成充值客户文件......");	
	   makeFile();
	   logger.info("充值客户文件生成完毕！");
	   logger.info("开始生成客户详情数据......");	
	   execCustomerDetail();
	   logger.info("客户详情数据生成完毕！");	   
	}
	
	
	/**
	 * 生成充值客户信息文件
	 */
	public static  void makeFile(){		
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, -1);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
		String date = sdf.format(cal.getTime());//当前时间的前一天
		String url = "http://tw07286.sandai.net:8002/scanPlatNewForUser?date="+date+"&type=2";
		String message = null;
		int flag = 0;
		 try{
		      String responseString =  HttpClientUtil.getHtml(url);	    	
		      if(responseString != null && !"".equals(responseString)){
		    		String str[] = responseString.split("&");
		    		String status = str[0].split("=")[1];
		    		message = str[1].split("=")[1];
		    		flag = Integer.parseInt(status);
		    		if(flag != 1){
		    			throw new Exception(URLDecoder.decode(message,"utf8"));
		    		}
		    	}
		    }catch(Exception e){
		    	logger.info("生成充值客户文件任务执行失败，原因：" + e.getMessage());
		    }
	}
	
	
	
	
	/**
	 * 生成客户详情数据
	 */
	public static void execCustomerDetail() {	
		String baseUrl = getUrl();		
		String filepath = getFilesPath();		
		if(filepath.indexOf(",")>-1){//如果有多个文件
			for(String subFilePath:filepath.split(",")){
			   initData(baseUrl,subFilePath);
			}
		}else{//如果只有一个文件
			initData(baseUrl,filepath);
		}	
	}
	
	
	/**
	 * 通过http的形式访问远程文件，并且读取文件中的数据，保存到数据库
	 * @param path
	 * @return
	 */
	public static void initData(String baseUrl,String filepath){
		URL url = null;
		Connection uconn = null;
		PreparedStatement upstmt = null;
		try {
			url = new URL(baseUrl+filepath);			
		} catch (MalformedURLException e) {
			logger.info("文件找不到，文件路径为："+baseUrl+filepath+"，请查看是否正确。错误代码："+e.getMessage());
		} 
		HttpURLConnection httpUrl = null;
		BufferedReader br = null;
		//连接指定的网络资源 
		try {
			httpUrl = (HttpURLConnection) url.openConnection(); 
			httpUrl.connect();
			//获取网络输入流 
			br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 			
			/**-----------
			 * 开始解析数据
			 * -----------
			 */
            logger.info("========开始解析文件:"+filepath+"=========");			
			String readLine = br.readLine();
			int line = 0;//读取的行号			
			uconn = ConnUtil.getConnection();
			Map gamepayMap = new HashMap();
			long gameCount = 0;
			long payGameCount = 0;
			String lastLoginTime = null;
			String lastPayTime = null;
			while(readLine != null){
				lastLoginTime = null;
				lastPayTime = null;
				line ++;
				logger.info("line=============>"+line);				
				//开始解析数据
				String arr[] = readLine.split(",");
				String uid = null;
				for(String data:arr){
					if(data.indexOf("userid=")>-1){													
						uid = data.substring(data.indexOf("=")+1)==null?"":data.substring(data.indexOf("=")+1).trim();//迅雷uid	
						if(uid == null||"".equals(uid)){
							continue;
						}
					}
					
				}			
				   /////////////////////////////////////////////////////////////////////////////////////////
                //计算激活游戏数和充值游戏数
                getGameAndPayCount(gamepayMap,uid);
                gameCount = gamepayMap==null?0:gamepayMap.get("gameCount")==null?0:(Long)gamepayMap.get("gameCount");
                payGameCount = gamepayMap==null?0:gamepayMap.get("payGameCount")==null?0:(Long)gamepayMap.get("payGameCount");
//                /////////////////////////////////////////////////////////////////////////////////////////
                
            	logger.info("updateuid==============>"+uid);
                ///////////////////////////////////////////////////////////////////////////////////////
                //查询客户的VIP等级
            	String usql = "update customerdetailquery set lastLoginTime=?,lastPayTime=?,gameCount=?,payGameCount=?  where uid=?";
            	upstmt = uconn.prepareStatement(usql);
            	upstmt.setString(1, lastLoginTime);
            	upstmt.setString(2, lastPayTime);
            	upstmt.setLong(3, gameCount);
            	upstmt.setLong(4, payGameCount);
            	upstmt.setString(5, uid);
            	upstmt.execute();                               	
                          
				//读取下一行的数据
				readLine = br.readLine();
			}											
		} catch (Exception e) {
			logger.info(e.getMessage());
			e.printStackTrace();
		}finally{
			try{
				if(upstmt != null){
					upstmt.close();
					upstmt = null;
				}
				if(uconn != null){
					uconn.close();
					uconn = null;
				}
				if(br != null){
					br.close();
					br =  null;
				}
				if(httpUrl != null){
					httpUrl.disconnect();
					httpUrl = null;
				}
			}catch(Exception e){
				logger.info(e.getMessage());
				e.printStackTrace();
			}
		}
	}
	
	
	/**
	 * 检查客户是否流失 
	 * 规则：VIP1-VIP7连续5天未登录游戏  VIP8-VIP10连续2天未登录游戏
	 * @param lastLoginTime 最后登录时间
	 * @param vipGrade VIP等级
	 * @return
	 */
	public static boolean checkCustomerIsLost(String lastLoginTime,int vipGrade){
		if(lastLoginTime == null||"".equals(lastLoginTime))return true;
		if(vipGrade>=1 && vipGrade <= 7){
			if(compareTime(time,lastLoginTime) >= 5)return true;
		}else if(vipGrade >= 8 && vipGrade <= 10){
			if(compareTime(time,lastLoginTime) >= 2)return true;
		}
		return false;
	}
	
	/**
	 * 格式化年份
	 * @param maxday
	 * @return
	 */
	public static String getFormatYear(String maxday){
		String year = maxday.substring(0, 1);		
  		String tmp = maxday.substring(1, 5);		
        String month = tmp.substring(0,2);
        String day = tmp.substring(2); 
		if("1".equals(year)){
    		year = "2011";
    	}else if("2".equals(year)){
    		year = "2012";
    	}else if("3".equals(year)){
    		year = "2013";
    	}else if("4".equals(year)){
    		year = "2014";
    	}else if("5".equals(year)){
    		year = "2015";
    	}else if("6".equals(year)){
    		year = "2016";
    	}else if("7".equals(year)){
    		year = "2017";
    	}else if("8".equals(year)){
    		year = "2018";
    	}else if("9".equals(year)){
    		year = "2019";
    	}
		maxday = year+"-"+month+"-"+day;
		return maxday;
	}
	
	
	
	/**
	 * 取时间格式为：yyyy-MM-dd 日期的前一天 
	 * @param daytime
	 * @return
	 */
	public static String formatBeforeDay(String daytime){
		if(daytime==null||"".equals(daytime))return null;
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date date = null;
		try {
			date = sdf.parse(daytime);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		String now = sdf.format(cal.getTime());		
		return now;
	}
	
	
	/**
	 * 按照日期读出统计前一天的数据
	 * @return
	 */
	public static String getFilesPath(){				
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String strs[] = time.split("-");
		String filepath = null;
		String daytime = strs[0]+strs[1]+strs[2];
        try{
        	String sql = "select fileurl from bigcustomerquery where daytime=?";
        	conn = ConnUtil.getConnection();
        	pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, daytime);
 			rs = pstmt.executeQuery();
 			if(rs == null)return null;
 			rs.next();
 			filepath = rs.getString(1);
        }catch(Exception e){
        	e.printStackTrace();
        }finally{
        	try{
        		if(rs != null){
        			rs.close();
        			rs = null;
        		}
        		if(pstmt != null){
        			pstmt.close();
        			pstmt = null;
        		}
        		if(conn != null){
        			conn.close();
        			conn = null;
        		}
        	}catch(Exception e){
        		e.printStackTrace();
        	}
        }
        		
		return filepath;
		
	}
	
	/**
     * 获得文件服务器地址
     * @return
     */
	public static String getUrl(){
		String bigCustomerRemoteUrl= "http://twin13024.sandai.net:8080/hdfs-webdav";
		logger.info("获得文件服务器地址成功");
		return bigCustomerRemoteUrl;
	}
	
	
	/**
	 * 通过get方式调用接口
	 * @param url
	 * @return
	 */
	public static String getInfoForHttpGetMothed(String url) {
		try {
			logger.info(" Get/URL :" + url);
			HttpGet httpget = new HttpGet(url);
			HttpClient client = new DefaultHttpClient();
			String backStr = "";
			ResponseHandler<String> responseHandler = new BasicResponseHandler();
			backStr = client.execute(httpget, responseHandler);
			return backStr;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}
	
	/**
	 * 比较两个时间相隔多少天
	 *  
	 * @param fromtime 格式 yyyy-MM-dd
	 * @param totime   格式 yyyy-MM-dd
	 * @return
	 */
	public static long compareTime(String fromtime,String totime){
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
        Date one = null;
        Date two = null;
        long days=0;  
        try{
        	one = df.parse(fromtime);  
        	two = df.parse(totime); 
        	long time1 = one.getTime();  
        	long time2 = two.getTime();  
        	long diff = time1 - time2;       	
        	days = diff / (1000 * 60 * 60 * 24);  
        }catch(ParseException  e){
        	e.printStackTrace();  
        }
		return days;
	}
	
	
	/**
	 * 获得平台的激活游戏数和充值游戏数
	 */
	public static void getGameAndPayCount(Map map,String uid){	
		if(map != null)map.clear();
		String jsonStr = getInfoForHttpGetMothed(customerInterface+"uid="+uid+"&date="+time);
		if(jsonStr == null){
			return;
		}
		ObjectMapper mapper = new ObjectMapper();
		try {
			JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);			
			//绑定游戏详情数据
			List<Record> recordList = record.getList();								
			if(recordList == null||recordList.size()==0)return;
			long gameCount = 0L;//激活游戏数
			long payGameCount = 0L;//充值游戏数
			Set game = new HashSet();
			Set pay = new HashSet();	
			for(Record rec:recordList){
				if(rec.getFirstLoginTime() != null && !"".equals(rec.getFirstLoginTime())){
					game.add(rec.getGameId());
				}
				if(rec.getFirstPayTime() != null && !"".equals(rec.getFirstPayTime())){
					pay.add(rec.getGameId());
				}				
			}
			gameCount = game.size();
			payGameCount = pay.size();
			map.put("gameCount", gameCount);
			map.put("payGameCount", payGameCount);
		} catch (JsonParseException e) {
			e.printStackTrace();
		} catch (JsonMappingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
