package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;

/**
 * 更新自动发放奖品执行状态定时任务
 * @author lisu
 * 2013-04-24
 */
public class UpdateAutoProductTask {

	private static final Logger logger = Logger.getLogger(UpdateAutoProductTask.class.getName());	
    private static String time = null;
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间
		}
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		logger.info("开始更新自动发放奖品执行状态......");	
		updateAutoProduct();
		logger.info("自动发放奖品执行状态更新完毕！");	
	}

	/**
	 * 更新自动发放奖品执行状态
	 */
	public static void updateAutoProduct(){
		Connection conn = null;
		PreparedStatement stmt = null;
		String starttime = TaskLogUtil.getNowTime();
		try{
		    conn = ConnUtil.getConnection();
		    String sql = "update autoproduct set flag = 0 where flag = 1";
		    stmt = conn.prepareStatement(sql);		    
		    stmt.executeUpdate();
		    String endtime = TaskLogUtil.getNowTime();
		    TaskLogUtil.addLog("重新设置自动发放奖品状态", null, starttime, endtime, true);
		}catch(Exception e){
			logger.info("update autoproduct failure.The exception:"+e.getMessage()+",time="+time);
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("重新设置自动发放奖品状态", e.getMessage(), starttime, endtime, false);
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}	
	}
}
