package com.xunlei.niux.manager.web.vo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaskLogUtil {
	private static final Logger logger = Logger.getLogger(TaskLogUtil.class.getName());
	private static SimpleDateFormat sdf = null; 
	
	static{
		if(sdf == null){
			sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		}
	}
	
	/**
	 * 添加定时任务日志
	 * @param taskname 任务名称
	 * @param reason 异常原因
	 * @param starttime 开始执行时间
	 * @param endtime 执行结束时间
	 * @param conn 数据库连接
	 * @param flag 状态，表示是否成功
	 */
	public static void addLog(String taskname,String reason,String starttime,String endtime,boolean flag){
		Connection conn = null;
		PreparedStatement pstmt = null;
		try{
			conn = ConnUtil.getConnection();
			String sql = "insert into timetaskrecord values(?,?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(sql);
			long sendtime = compareTime(starttime,endtime);//定时任务从开始到结束相隔多少秒
			pstmt.setString(1, null);
			pstmt.setString(2, taskname);
			pstmt.setString(3, starttime);
			pstmt.setString(4, endtime);
			pstmt.setLong(5, sendtime);
			pstmt.setInt(6, flag?1:0);
			pstmt.setString(7, reason==null?"":reason);
			pstmt.execute();
		}catch(Exception e){
			e.printStackTrace();
			logger.info("time task add logger error . The time :"+endtime+". The reason :"+e.getMessage());
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	
	/**
	 * 获得当前时间
	 * @return
	 */
	public static String getNowTime(){		
		return sdf.format(new Date());
	}
	
	
	/**
	 * 比较两个时间相隔多少秒
	 *  
	 * @param fromtime 格式 yyyy-MM-dd
	 * @param totime   格式 yyyy-MM-dd
	 * @return
	 */
	public static long compareTime(String fromtime,String totime){
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");  
        Date one = null;
        Date two = null;
        long days=0;  
        try{
        	one = df.parse(fromtime);  
        	two = df.parse(totime); 
        	long time1 = one.getTime();  
        	long time2 = two.getTime();  
        	long diff = time2 - time1;       	
        	days = diff / 1000;  
        }catch(ParseException  e){
        	e.printStackTrace();  
        }
		return days;
	}
}
