package com.xunlei.niux.manager.web.vo;


import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;



/**
 * 生成充值客户信息
 * @author lisu
 * 2013-03-02
 */
public class LeaveCustomerTask {
	private static final Logger logger = Logger.getLogger(LeaveCustomerTask.class.getName());
	private static String time = null;
	private static String customerInterface = "http://tw07286.sandai.net:8002/getPayAndLoginRecord?";
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 cal.add(Calendar.DAY_OF_MONTH, -1);
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间的前一天
		}
	}
	
	
	public static void main(String args[]){
	   make();
	}
	
	/**
	 * 生成文件到文件服务器，更新客户信息，并且生成大客户记录
	 */
	public static void make(){	
	   logger.info("开始生成客户详情数据......");	
	   initData("/tmp/bigcustomerdetail/","PlatNew2447887361361131249384.227044d9c5fe45bebeba1a691c7ededf(1).txt");
	   logger.info("客户详情数据生成完毕！");	   
	}
	
	
	/**
	 * 通过http的形式访问远程文件，并且读取文件中的数据，保存到数据库
	 * @param path
	 * @return
	 */
	public static void initData(String baseUrl,String filepath){
		Connection conn = null;
		Connection uconn = null;
		PreparedStatement pstmt = null;
		PreparedStatement upstmt = null;
		ResultSet rs = null;
		FileInputStream fis = null;
		File file = new File(baseUrl+filepath);			
		BufferedReader br = null;
		//连接指定的网络资源 
		try {
			fis = new FileInputStream(file);
            br = new BufferedReader(new InputStreamReader(fis));		
			/**-----------
			 * 开始解析数据
			 * -----------
			 */
            logger.info("========开始解析文件:"+filepath+"=========");			
			String readLine = br.readLine();
			int line = 0;//读取的行号
			List<String> loginlist = new ArrayList<String>();//登录集合
			List<Double> paylist = new ArrayList<Double>();//支付集合	
			List<String> payTimeList = new ArrayList<String>();//充值时间集合		
			//获得所有的客户等级
			//List<CustomerGrade> gradeList = FacadeFactory.INSTANCE.getCustomerGradeBo().findCustomerGradeList();
			String sql = "select * from customergrade ORDER BY vipGrade ASC ";
			conn = ConnUtil.getConnection();
			uconn = ConnUtil.getConnection();
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			List<Integer> vipGradeList = new ArrayList<Integer>();
			List<Long> amountFromList = new ArrayList<Long>();
			List<Long> amountToList = new ArrayList<Long>();
			int oo = 0;
			while(rs.next()){
				amountFromList.add(rs.getLong("amountFrom"));
				amountToList.add(rs.getLong("amountTo"));
            	vipGradeList.add(rs.getInt("vipGrade"));
            	oo++;
			}
			Map gamepayMap = new HashMap();
//			int jj = 0;
			double total = 0;
			long lastPayTotal = 0L;
			long payTotalAmt = 0L;
			Integer vipgrade = 0;
			int vipstatus = 0;
			boolean isBack = false;
			boolean isPromote = false;
			long gameCount = 0;
			long payGameCount = 0;
			Integer callcount = 0;
			String lastLoginTime = null;
			String lastPayTime = null;
			while(readLine != null){
//				if(jj >= 1000)break;
//				jj ++;
				total = 0;
				lastPayTotal = 0L;
				payTotalAmt = 0L;
				vipstatus = 0;
				callcount = 0;
				vipgrade = 0;
				lastLoginTime = null;
				lastPayTime = null;
				isBack = false;
				isPromote = false;
				
				line ++;
				logger.info("line=============>"+line);				
				//开始解析数据
				String arr[] = readLine.split(",");
				loginlist.clear();//清空集合
				paylist.clear();
				payTimeList.clear();
				//CustomerDetailQuery detail = new CustomerDetailQuery();
				String uid = null;
				for(String data:arr){
					if(data.indexOf("userid=")>-1){													
						uid = data.substring(data.indexOf("=")+1)==null?"":data.substring(data.indexOf("=")+1).trim();//迅雷uid	
						if(uid == null||"".equals(uid))continue;
					}
					if(data.indexOf("login_")>-1){					
						loginlist.add(data.substring(data.indexOf("_")+1).split("=")[0]);//将多个日期放到集合						
					}
					if(data.indexOf("pay_")>-1){	
					    paylist.add(new Double(data.substring(data.indexOf("_")).split("=")[1]));//将多个金额放到集合
					    payTimeList.add(data.substring(data.indexOf("_")+1).split("=")[0]);//将多个充值时间放到集合
					}	
				}
				for(int i=0;i<payTimeList.size();i++){
					String payTime = getFormatYear(payTimeList.get(i));
					if(payTime.trim().equals(time)){
						lastPayTotal+=paylist.get(i);//当天的平台充值金额
					}
				}
				//detail.setLastModifyAmt(lastPayTotal);
				
				Collections.sort(loginlist);//将登录日期排序
				Collections.sort(payTimeList);//将充值日期排序
		        if(loginlist.size()>0){
                	String maxday = loginlist.get(loginlist.size()-1);
                	maxday = getFormatYear(maxday);
                	//detail.setLastLoginTime(maxday);//最后登录时间
                	lastLoginTime = maxday;
                }  
                for(Double pay:paylist){
                	total += pay;//求出总金额
                }
                if(payTimeList.size()>0){
                	String maxday = payTimeList.get(payTimeList.size()-1);
                	maxday = getFormatYear(maxday);
                	//detail.setLastPayTime(maxday);//最后充值时间
                	lastPayTime = maxday;
                }
               // detail.setPayTotalAmt(total);
                payTotalAmt = Math.round(total) ;
                
                ///////////////////////////////////////////////////////////////////////////////////////
                //查询客户的VIP等级
                for(int i=0;i<amountFromList.size();i++){
                	long amountFrom = amountFromList.get(i);
                	long amountTo = amountToList.get(i);
                	Integer vipGrade = vipGradeList.get(i);
                	if(amountFrom <= payTotalAmt && amountTo >= payTotalAmt){
                		vipgrade = vipGrade;
                		break;
                	}
                }
                ////////////////////////////////////////////////////////////////////////////////////////
                //获得对某用户的外呼次数 
                sql = "select count(*) from callrecord where uid=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, uid);
    			rs = pstmt.executeQuery();
    			rs.next();//游标下滚
    			callcount = rs.getInt(1);
                ////////////////////////////////////////////////////////////////////////////////////////
                //判断客户是否流失
                boolean lostFlag = checkCustomerIsLost(lastLoginTime,vipgrade);
                if(lostFlag)vipstatus=2;//设置状态为流失
                else vipstatus=1;//设置状态为保有
                ////////////////////////////////////////////////////////////////////////////////////////
                //判断该客户的新增、回流、晋级状态
                sql = "select * from customerdetailquery where uid=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, uid);
    			rs = pstmt.executeQuery();   			
    			
                /////////////////////////////////////////////////////////////////////////////////////////
                //计算激活游戏数和充值游戏数
                getGameAndPayCount(gamepayMap,uid);
                gameCount = (Long)gamepayMap.get("gameCount");
                payGameCount = (Long)gamepayMap.get("payGameCount");
                /////////////////////////////////////////////////////////////////////////////////////////
                
                if(rs == null||!rs.next()){//如果客户不存在，则需要新增客户信息               	
                	String usql = "insert into customerdetailquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                	upstmt = uconn.prepareStatement(usql);
                	upstmt.setString(1, null);
                	upstmt.setString(2, uid);
                	upstmt.setString(3, "");
                	upstmt.setInt(4, vipgrade);
                	upstmt.setInt(5, vipstatus);
                	upstmt.setLong(6, gameCount);
                	upstmt.setLong(7, payGameCount);
                	upstmt.setLong(8, payTotalAmt);
                	upstmt.setString(9, lastPayTime);
                	upstmt.setString(10, lastLoginTime);
                	upstmt.setInt(11, callcount);
                	upstmt.setInt(12, 0);
                	upstmt.setString(13, "");
                	upstmt.setString(14, "");
                	upstmt.setString(15, "");
                	upstmt.setString(16, "");
                	upstmt.setString(17, "");
                	upstmt.setLong(18, lastPayTotal);
                	upstmt.setInt(19, 1);
                	upstmt.setInt(20, 0);
                	upstmt.setInt(21, 0);
                	upstmt.execute();
                }else{
            		int myvipgrade = rs.getInt("vipGrade");
                	vipstatus = rs.getInt("vipStatus");
                	if(!lostFlag && vipstatus == 2){//判断是否回流
                		isBack = true;
                	}else{
                		isBack = false;
                	}
                	if(myvipgrade != vipgrade)isPromote=true;//判断是否晋级
                	else isPromote = false;
                	String usql = "update customerdetailquery set isBack=?,isNew=?,isPromote=?,lastLoginTime=?,lastPayTime=?,callCount=?,lastModifyAmt=?,vipGrade=?,vipStatus=?,payTotalAmt=?,gameCount=?,payCount=? where uid=?";
                	upstmt = uconn.prepareStatement(usql);
                	upstmt.setInt(1, isBack?1:0);
                	upstmt.setInt(2,0);
                	upstmt.setInt(3, isPromote?1:0);
                	upstmt.setString(4, lastLoginTime);
                	upstmt.setString(5, lastPayTime);
                	upstmt.setInt(6, callcount);
                	upstmt.setLong(7, lastPayTotal);
                	upstmt.setInt(8, vipgrade);
                	upstmt.setInt(9, vipstatus);
                	upstmt.setLong(10, payTotalAmt+rs.getLong("payTotalAmt"));
                	upstmt.setLong(11, gameCount);
                	upstmt.setLong(12, payGameCount);
                	upstmt.setString(13, uid);
                	upstmt.execute();               
                	
                }
//                if(cdqlist==null || cdqlist.size()==0){//如果客户不存在，则需要新增客户信息
//                	detail.setIsNew(true);
//                	detail.setIsBack(false);
//                	detail.setIsPromote(false);
//                	 //插入到数据库中               
//                    FacadeFactory.INSTANCE.getCustomerDetailQueryBo().insert(detail);
//                }else{//如果客户存在，则需要更新客户信息
//                	detail.setIsNew(false);
//                	CustomerDetailQuery cdq = cdqlist.get(0);
//                	if(!lostFlag && cdq.getVipStatus() == 2){//判断是否回流
//                		detail.setIsBack(true);
//                	}else{
//                		detail.setIsBack(false);
//                	}
//                	if(detail.getVipGrade() != cdq.getVipGrade())detail.setIsPromote(true);//判断是否晋级
//                	else detail.setIsPromote(false);
//                	
//                	cdq.setIsBack(detail.getIsBack());
//                	cdq.setIsNew(detail.getIsNew());
//                	cdq.setIsPromote(detail.getIsPromote());
//                	cdq.setLastLoginTime(detail.getLastLoginTime());
//                	cdq.setLastPayTime(detail.getLastPayTime());
//                	cdq.setCallCount(detail.getCallCount());
//                	cdq.setLastModifyAmt(detail.getLastModifyAmt());
//                	cdq.setVipGrade(detail.getVipGrade());
//                	cdq.setVipStatus(detail.getVipStatus());
//                	cdq.setPayTotalAmt(detail.getPayTotalAmt());
//                	cdq.setGameCount(detail.getGameCount());
//                	cdq.setPayCount(detail.getPayCount());
//                	//更新到数据库中
//                	FacadeFactory.INSTANCE.getCustomerDetailQueryBo().update(cdq);
//                }                             
                ////////////////////////////////////////////////////////////////////////////////////////
                
				//读取下一行的数据
				readLine = br.readLine();
			}											
		} catch (Exception e) {
			logger.info(e.getMessage());
			e.printStackTrace();
		}finally{
			try{
				if(upstmt != null){
					upstmt.close();
					upstmt = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(uconn != null){
					uconn.close();
					uconn = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(br != null){
					br.close();
					br =  null;
				}
				if(fis != null){
					fis.close();
					fis = null;
				}
			}catch(Exception e){
				logger.info(e.getMessage());
				e.printStackTrace();
			}
		}
	}
	
	
	/**
	 * 检查客户是否流失 
	 * 规则：VIP1-VIP7连续5天未登录游戏  VIP8-VIP10连续2天未登录游戏
	 * @param lastLoginTime 最后登录时间
	 * @param vipGrade VIP等级
	 * @return
	 */
	public static boolean checkCustomerIsLost(String lastLoginTime,int vipGrade){
		if(lastLoginTime == null||"".equals(lastLoginTime))return true;
		if(vipGrade>=1 && vipGrade <= 7){
			if(compareTime(time,lastLoginTime) >= 5)return true;
		}else if(vipGrade >= 8 && vipGrade <= 10){
			if(compareTime(time,lastLoginTime) >= 2)return true;
		}
		return false;
	}
	
	/**
	 * 格式化年份
	 * @param maxday
	 * @return
	 */
	public static String getFormatYear(String maxday){
		String year = maxday.substring(0, 1);		
  		String tmp = maxday.substring(1, 5);		
        String month = tmp.substring(0,2);
        String day = tmp.substring(2); 
		if("1".equals(year)){
    		year = "2011";
    	}else if("2".equals(year)){
    		year = "2012";
    	}else if("3".equals(year)){
    		year = "2013";
    	}else if("4".equals(year)){
    		year = "2014";
    	}else if("5".equals(year)){
    		year = "2015";
    	}else if("6".equals(year)){
    		year = "2016";
    	}else if("7".equals(year)){
    		year = "2017";
    	}else if("8".equals(year)){
    		year = "2018";
    	}else if("9".equals(year)){
    		year = "2019";
    	}
		maxday = year+"-"+month+"-"+day;
		return maxday;
	}
	
	
	
	/**
	 * 取时间格式为：yyyy-MM-dd 日期的前一天 
	 * @param daytime
	 * @return
	 */
	public static String formatBeforeDay(String daytime){
		if(daytime==null||"".equals(daytime))return null;
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date date = null;
		try {
			date = sdf.parse(daytime);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		String now = sdf.format(cal.getTime());		
		return now;
	}
	
	
	
	/**
	 * 通过get方式调用接口
	 * @param url
	 * @return
	 */
	public static String getInfoForHttpGetMothed(String url) {
		try {
			logger.info(" Get/URL :" + url);
			HttpGet httpget = new HttpGet(url);
			HttpClient client = new DefaultHttpClient();
			String backStr = "";
			ResponseHandler<String> responseHandler = new BasicResponseHandler();
			backStr = client.execute(httpget, responseHandler);
			return backStr;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}
	
	/**
	 * 比较两个时间相隔多少天
	 *  
	 * @param fromtime 格式 yyyy-MM-dd
	 * @param totime   格式 yyyy-MM-dd
	 * @return
	 */
	public static long compareTime(String fromtime,String totime){
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
        Date one = null;
        Date two = null;
        long days=0;  
        try{
        	one = df.parse(fromtime);  
        	two = df.parse(totime); 
        	long time1 = one.getTime();  
        	long time2 = two.getTime();  
        	long diff = time1 - time2;       	
        	days = diff / (1000 * 60 * 60 * 24);  
        }catch(ParseException  e){
        	e.printStackTrace();  
        }
		return days;
	}
	
	
	/**
	 * 获得平台的激活游戏数和充值游戏数
	 */
	public static void getGameAndPayCount(Map map,String uid){	
		if(map != null)map.clear();
		String jsonStr = getInfoForHttpGetMothed(customerInterface+"uid="+uid+"&date="+time);
		if(jsonStr == null){
			return;
		}
		ObjectMapper mapper = new ObjectMapper();
		try {
			JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);			
			//绑定游戏详情数据
			List<Record> recordList = record.getList();								
			if(recordList == null||recordList.size()==0)return;
			long gameCount = 0L;//激活游戏数
			long payGameCount = 0L;//充值游戏数
			Set game = new HashSet();
			Set pay = new HashSet();	
			for(Record rec:recordList){
				if(rec.getFirstLoginTime() != null && !"".equals(rec.getFirstLoginTime())){
					game.add(rec.getGameId());
				}
				if(rec.getFirstPayTime() != null && !"".equals(rec.getFirstPayTime())){
					pay.add(rec.getGameId());
				}				
			}
			gameCount = game.size();
			payGameCount = pay.size();
			map.put("gameCount", gameCount);
			map.put("payGameCount", payGameCount);
		} catch (JsonParseException e) {
			e.printStackTrace();
		} catch (JsonMappingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
