package com.xunlei.niux.manager.web.vo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.util.StringTools;

public class GatherPhoneFromExcel {
	private static  String filename = "/tmp/lisu/";
	private final static String URL = "http://websvr.niu.xunlei.com/queryUserInfo.gameUserInfo?gameid=000069&type=300&accounts=";
	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
	private static final SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
	//private static  String filename = "/tmp/lztx";
	private static  String sheetname = "lztx";
	
	public static void main(String[] args) {
		try {
			importData3();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
  
	
	public static void gather2() throws Exception {
		Connection conn = null;
		Connection sconn = null;
		Connection inconn = null; 
        PreparedStatement stmt = null;
        PreparedStatement sstmt = null;
        PreparedStatement instmt = null;
        ResultSet rs = null;
        FileInputStream fis = null;
        BufferedReader br = null;
		try{
			 conn = ConnUtil.getConnection();		
			 sconn = ConnUtil.getConnection();
			 inconn = ConnUtil.getConnection();
			 fis = new FileInputStream(new File(filename+"xxddz_phone.txt"));
			 br = new BufferedReader(new InputStreamReader(fis));
			 String sql = "insert into userphone values(?,?,?,?)";
             stmt = conn.prepareStatement(sql);
             String querycustomersql = "select  *  from customerinfo where uid=?";
             sstmt = sconn.prepareStatement(querycustomersql);            
             String readline = br.readLine();
             int index = 1;
           
             while(readline != null){
            	  String name = "xxd";
            	 System.out.println("index="+index+",readline="+readline);
            	 String datas []  = readline.split("\t");
            	 if(datas == null||datas.length!=2){
            		 name = "error";
            		 readline = br.readLine();
            		 continue;
            	 }
            	 String uid = datas[0].trim();
            	 String phone = datas[1].trim();
            	 System.out.println("uid="+uid+",phone="+phone);
            	 sstmt.setString(1, uid);
            	 rs = sstmt.executeQuery();           	             	
            	 if(rs == null||!rs.next()){//如果客户不存在，则需要新增客户信息  
            		 String insql = "insert into customerinfo(uid,phone) values(?,?)";
            		 instmt = inconn.prepareStatement(insql);
            		 instmt.setString(1, uid);
            		 instmt.setString(2, phone);
            		 System.out.println("insert customerinfo sql:"+insql);
            	 }else{            		
            		 String myphone = rs.getString("phone");
            		 String upsql = "";
            		 if(myphone != null&&!"".equals(myphone)){
            			 if(!myphone.trim().equals(phone.trim())){
            				  upsql = "update customerinfo set oldphone=phone,phone='"+phone+"' where uid='"+uid+"'";
            			 }else{
            				 upsql = "update customerinfo set phone='"+phone+"' where uid='"+uid+"'";     
            			 }
            		 }else{//如果用户存在，并且手机号为空
            			  upsql = "update customerinfo set phone='"+phone+"' where uid='"+uid+"'";            			 
            		 }
            		 instmt = inconn.prepareStatement(upsql);           		
            		 System.out.println("update customerinfo sql:"+upsql);
            	 }     
            	
            	 instmt.execute();
            	 System.out.println("uid:"+uid+",phone:"+phone);
             	 stmt.setString(1, null);
            	 stmt.setString(2, uid);
            	 stmt.setString(3, phone==null?"":phone.trim());
            	 stmt.setString(4, name);
            	 stmt.execute();
            	 readline = br.readLine();
            	 index++;
             }
		}catch(Exception e){
			throw e;
		}finally{
			try{
				if(br != null){
					br.close();
					br = null;
				}
				if(fis != null){
					fis.close();
					fis = null;
				}
				if(instmt != null){
					instmt.close();
					instmt = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(sstmt != null){
					sstmt.close();
					sstmt = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
	}
	
	
	public static void importData3() throws Exception {
		Connection conn = null;
        PreparedStatement instmt = null;
        FileInputStream fis = null;
        BufferedReader br = null;
		try{
			 conn = ConnUtil.getConnection();
			 fis = new FileInputStream(filename+"jy.txt");
			 br = new BufferedReader(new InputStreamReader(fis));   
			 String readline = br.readLine();
			 int i = 1;
             while(readline != null){
            	 String uid = readline.trim();
            	 String updatesql = "insert into tmp_payuser values(?,?)";
            	 instmt = conn.prepareStatement(updatesql);
            	 instmt.setString(1, null);
        		 instmt.setString(2,uid );            	 
            	 instmt.execute();
            	 readline = br.readLine();
            	 System.out.println("line="+(i++)+",uid="+uid);
             }
             System.out.println("========import success==========");
		}catch(Exception e){
			e.printStackTrace();
			throw e;
		}finally{
			try{
				if(br != null){
					br.close();
					br = null;
				}
				if(fis != null){
					fis.close();
					fis = null;
				}
				if(instmt != null){
					instmt.close();
					instmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
	}
	public static void importPayGames(){
		Connection conn = null;
		Connection qconn = null;
		String path = "/tmp/data/payrecord.txt";
        PreparedStatement instmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        FileInputStream fis = null;
        BufferedReader br = null;
		try{
			 conn = ConnUtil.getConnection();
			 qconn = ConnUtil.getConnection();
			 stmt = qconn.createStatement();
			 fis = new FileInputStream(new File(path));
			 br = new BufferedReader(new InputStreamReader(fis));
             String readline = br.readLine();
             readline = br.readLine();//读取第二行数据
             int line = 1;
            
             while(readline != null){
            	 if(StringTools.isEmpty(readline))continue;
            	 String datas [] = readline.split("\t");
            	 String uid = datas[0].trim();
            	 String gameids = datas[1].trim();
            	 String querysql = "select payGameIds from customerdetailquery where uid='"+uid+"'";
            	 String ids = gameids;
            	 rs = stmt.executeQuery(querysql);
            	 if(rs != null&&rs.next()){
            		 String payGameIds = rs.getString("payGameIds");
            		 payGameIds = payGameIds==null?"":payGameIds.trim();
            		 if(StringTools.isEmpty(payGameIds)){
            			 ids = gameids;
            		 }else{
            			 ids = payGameIds+","+gameids;
            		 }
            	 }
              Set<String> gameset = new TreeSet<String>();
           	   if(ids.indexOf(",")==-1){//如果只玩过一款游戏
           		   if(!StringTools.isEmpty(ids)){
           			   gameset.add(ids);
           		   }
           	   }else{//如果玩过多款游戏
           		   String myids[]  = ids.split(",");
           		   for(String id:myids){
           			   if(!StringTools.isEmpty(id)){
           				   gameset.add(id);
           			   }
           		   }
           	   }
           	   String logingameids = "";
	 			for(String game:gameset){
	 				logingameids += (game+",");
	 			}
	 			if(gameset != null){//清空集合中的数据
					gameset.clear();
					gameset = null;
				}
            	 String updatesql = "update customerdetailquery set payGameIds=?  where uid=?";
            	 instmt = conn.prepareStatement(updatesql);
            	 instmt.setString(1, logingameids);
            	 instmt.setString(2, uid);
            	 instmt.execute();
            	 System.out.println("line="+(line++)+",uid="+uid);
            	 readline = br.readLine();
             }
		}catch(Exception e){
			e.printStackTrace();

		}finally{
			try{
				if(br != null){
					br.close();
					br = null;
				}
				if(fis != null){
					fis.close();
					fis = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(qconn != null){
					qconn.close();
					qconn = null;
				}
				if(instmt != null){
					instmt.close();
					instmt = null;
				}
	            if(conn != null){
	            	conn.close();
	            	conn = null;
	            }
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
		
	}
	
	public static void importData() throws Exception {
		Connection inconn = null;
		Workbook wb = null;   
        PreparedStatement instmt = null;
        ResultSet rs = null;
		try{
			inconn = ConnUtil.getConnection();
			 wb = new HSSFWorkbook(new FileInputStream(filename+".xls"));   
			 Sheet sheet = wb.getSheet(sheetname);  //获取Sheet1   
             long count = sheet.getPhysicalNumberOfRows();
             DecimalFormat df = new DecimalFormat("0");     
             for(int i=0;i<count;i++){
            	 System.out.println("i="+i);
            	 Row row = sheet.getRow(i);        
            	 Cell cell0  = row.getCell(0);
            	if(cell0 == null)continue;
            	 String uid = (cell0.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell0.getNumericCellValue())+"":cell0.getStringCellValue();
            	if(uid == null||"".equals(uid))continue;
            	uid = uid.trim();
            	 String customer =row.getCell(1).getStringCellValue()+"";
            	 if(customer != null){
            		 customer = customer.trim();
            	 }
            	 String updatesql = "update customerdetailquery set customerService=? where uid=?";
            	 instmt = inconn.prepareStatement(updatesql);
            	 instmt.setString(1, customer);
        		 instmt.setString(2, uid);            	 
            	 instmt.execute();
            	 System.out.println("line="+(i+1)+",uid="+uid);
             }
		}catch(Exception e){
			e.printStackTrace();
			throw e;
		}finally{
			try{
				if(instmt != null){
					instmt.close();
					instmt = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
	}
	
	
	public static void importData2() throws Exception {
		Connection conn = null;
		Connection qconn = null;
		Connection inconn = null;
		Workbook wb = null;   
		PreparedStatement stmt = null;
		PreparedStatement qstmt = null;
        PreparedStatement instmt = null;
        ResultSet qrs = null;
        ResultSet rs = null;
		try{
			conn = ConnUtil.getConnection();
			qconn = ConnUtil.getConnection();
			inconn = ConnUtil.getConnection();
			 wb = new HSSFWorkbook(new FileInputStream(filename+".xls"));   
			 Sheet sheet = wb.getSheet(sheetname);  //获取Sheet1   
             long count = sheet.getPhysicalNumberOfRows();
             DecimalFormat df = new DecimalFormat("0");     
             
            String cgsql = "select * from customergrade ORDER BY vipGrade ASC ";
 			conn = ConnUtil.getConnection();
 			stmt = conn.prepareStatement(cgsql);
 			rs = stmt.executeQuery();
 			List<Integer> vipGradeList = new ArrayList<Integer>();
 			List<Long> amountFromList = new ArrayList<Long>();
 			List<Long> amountToList = new ArrayList<Long>();
 			while(rs.next()){
 				amountFromList.add(rs.getLong("amountFrom"));
 				amountToList.add(rs.getLong("amountTo"));
             	vipGradeList.add(rs.getInt("vipGrade"));
 			}
             for(int i=0;i<count;i++){
            	 Row row = sheet.getRow(i);        
            	 Cell cell0  = row.getCell(0);
            	if(cell0 == null)continue;
            	 String uid = (cell0.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell0.getNumericCellValue())+"":cell0.getStringCellValue();
            	if(uid == null||"".equals(uid))continue;
            	uid = uid.trim();
            	Cell cell1 = row.getCell(1);
            	 String money =(cell1.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell1.getNumericCellValue())+"":cell1.getStringCellValue();
            	 if(money != null){
            		 money = money.trim();
            	 }
            	String sql = "select * from customerdetailquery where uid=?";
            	instmt = qconn.prepareStatement(sql);
            	instmt.setString(1, uid);
            	qrs = instmt.executeQuery();
            	 long payTotalAmt = Long.parseLong(money);
            	 int vipgrade = 0;
            	  for(int ii=0;i<amountFromList.size();i++){
                  	long amountFrom = amountFromList.get(ii);
                  	long amountTo = amountToList.get(ii);
                  	Integer vipGrade = vipGradeList.get(ii);
                  	if(amountFrom <= payTotalAmt && amountTo >= payTotalAmt){
                  		vipgrade = vipGrade;
                  		break;
                  	}
                  }
            	 
            	 if(qrs == null||!qrs.next()){//新增
            		 String usql = "insert into customerdetailquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";               	
            		 qstmt = inconn.prepareStatement(usql);
            		 qstmt.setString(1, null);
            		 qstmt.setString(2, uid);
            		 qstmt.setString(3, "");
            		 qstmt.setInt(4, vipgrade);                	
            		 qstmt.setInt(5, 1);
            		 qstmt.setLong(6, 0);
            		 qstmt.setLong(7, 0);
            		 qstmt.setLong(8, payTotalAmt);                	
            		 qstmt.setString(9, "");
            		 qstmt.setString(10, "");
            		 qstmt.setInt(11, 0);
            		 qstmt.setInt(12, 0);
            		 qstmt.setString(13, "");
            		 qstmt.setString(14, "");
            		 qstmt.setString(15, "");
            		 qstmt.setString(16, "");
            		 qstmt.setString(17, "");
            		 qstmt.setLong(18, payTotalAmt);
            		 qstmt.setInt(19, 1);
            		 qstmt.setInt(20, 0);
            		 qstmt.setInt(21, 0);
            		 qstmt.setLong(22, payTotalAmt);
            		 qstmt.setInt(23, vipgrade);
            		 qstmt.setInt(24, 0);
            		 qstmt.setString(25, "");
            		 qstmt.setString(26, "");
            		 qstmt.setString(27, "");
            		 qstmt.setLong(28, 0);	
            		 qstmt.setString(29, "");	
            		 qstmt.setString(30, "");	
            		 qstmt.setString(31, "");	
            		 qstmt.setString(32, "");
            		 qstmt.setInt(33, 0);
            		 qstmt.setLong(34, 0);
            		 qstmt.setString(35,"");
            		 qstmt.setString(36,"1");
            		 qstmt.execute();
            	 }else{//修改
            		 long spayTotalAmt= qrs.getLong("payTotalAmt");
            		 long slivepaytotalamt= qrs.getLong("livepayTotalAmt");
            		 payTotalAmt += spayTotalAmt;
            		 for(int ii=0;i<amountFromList.size();i++){
                       	long amountFrom = amountFromList.get(ii);
                       	long amountTo = amountToList.get(ii);
                       	Integer vipGrade = vipGradeList.get(ii);
                       	if(amountFrom <= payTotalAmt && amountTo >= payTotalAmt){
                       		vipgrade = vipGrade;
                       		break;
                       	}
                       }
            		 String updatesql = "update customerdetailquery set payTotalAmt=?,livepaytotalamt=?,vipgrade=?,livevipgrade=? where uid=?";
            		 qstmt = inconn.prepareStatement(updatesql);
            		 qstmt.setLong(1,payTotalAmt );
            		 qstmt.setLong(2,payTotalAmt );
            		 qstmt.setInt(3,vipgrade );
            		 qstmt.setInt(4,vipgrade );
            		 qstmt.setString(5,uid);
            		 qstmt.execute();
            	 }
           	
            	 System.out.println("line="+(i+1)+",uid="+uid);
             }
		}catch(Exception e){
			e.printStackTrace();
			throw e;
		}finally{
			try{
				if(qstmt != null){
					qstmt.close();
					qstmt = null;
				}
				if(qrs != null){
					qrs.close();
					qrs = null;
				}				
				if(instmt != null){
					instmt.close();
					instmt = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(qconn != null){
					qconn.close();
					qconn = null;
				}
				if(inconn != null){
					inconn.close();
					inconn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
	}
	
	/**
	 * 获得账号uid
	 * @param account
	 * @return
	 * @throws Exception
	 */
	public static String getUid(String account) throws Exception{	
		account = account.trim();
		System.out.println("amount url:"+(URL+account));
		String responseText = HttpClientUtil.get(URL+account);
		System.out.println("responseText:"+responseText);
		if(responseText == null||"".equals(responseText))return null;
		responseText = responseText.replace("{","").replace("}", "").replaceAll("\"", "");
		String strs []  = responseText.split(",");
		if(strs == null||strs.length<=1)return null;
		return strs[0].split(":")[1].split("=")[1];
	}
	
	private static String getFormatTime(String time) throws Exception{
		if(time == null||"".equals(time)||"1900/1/0".equals(time)) return "";
		Date date = sdf.parse(time);
		return  sdf2.format(date);
	}
	
	/**
	 * 通过excel导入收集手机号和客户资料
	 * @throws Exception
	 */
	public static void gather() throws Exception {
		Connection conn = null;
		Connection sconn = null;
		Connection inconn = null;
		Workbook wb = null;   
        PreparedStatement stmt = null;
        PreparedStatement sstmt = null;
        PreparedStatement instmt = null;
        ResultSet rs = null;
		try{
			conn = ConnUtil.getConnection();		
			sconn = ConnUtil.getConnection();
			inconn = ConnUtil.getConnection();
			String sql = "insert into userphone values(?,?,?,?)";
			 wb = new HSSFWorkbook(new FileInputStream(filename+".xls"));   
			 Sheet sheet = wb.getSheet(sheetname);  //获取Sheet1   
             long count = sheet.getPhysicalNumberOfRows();
             DecimalFormat df = new DecimalFormat("0"); 
             stmt = conn.prepareStatement(sql);
             String querycustomersql = "select  *  from customerinfo where uid=?";
             sstmt = sconn.prepareStatement(querycustomersql);            
             for(int i=0;i<count;i++){
            	 System.out.println("i="+i);
            	 Row row = sheet.getRow(i);        
            	 Cell cell0  = row.getCell(0);
            	if(cell0 == null)continue;
            	 String account = (cell0.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell0.getNumericCellValue())+"":cell0.getStringCellValue();
            	if(account == null||"".equals(account))continue;
            	account = account.trim();
            	 String phone = df.format(row.getCell(1).getNumericCellValue())+"";
            	 if(phone != null){
            		 phone = phone.trim();
            	 }
            	 String qq = df.format(row.getCell(2).getNumericCellValue())+"";
            	 if(qq != null){
            		 qq = qq.trim();
            	 }
            	 
            	 String email = "";
            	 Cell cell3 = row.getCell(3);
            	 if(cell3 != null){
            		 email = (cell3.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell3.getNumericCellValue())+"":cell3.getStringCellValue();
            	 }
            			
            	 if(email != null){
            		 if("0".equals(email)){
            			 email = "";
            		 }else{
            			 email = email.trim();
            		 }
            	 }
            	 Cell cell = row.getCell(4);            	
            	 String birthday = "";
            	 if(cell != null){
            		 if( cell.getCellType() == HSSFCell.CELL_TYPE_NUMERIC){
                         Date date = cell.getDateCellValue();   
                         birthday =  sdf2.format(date); 
                 	}else{
                 		birthday = "-1";
                 	}
                 	 //birthday = getFormatTime(birthday);
            	 }
            	 
            	 String realname = "";
            	 Cell cell5 = row.getCell(5);
            	 if(cell5 != null)
            	    realname = (cell5.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell5.getNumericCellValue())+"":cell5.getStringCellValue();
            	
            	 Cell cell6 = row.getCell(6);
            	 String address = "";
            	 if(cell6 != null){
            		 address = (cell6.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell6.getNumericCellValue())+"":cell6.getStringCellValue();
            	 }
            	 
            	 String uid = getUid(account);
            	 sstmt.setString(1, uid);
            	 rs = sstmt.executeQuery();
            	 
            	
            	 if(rs == null||!rs.next()){//如果客户不存在，则需要新增客户信息  
            		 String insql = "insert into customerinfo(uid,username,birthday,qq,email,address) values(?,?,?,?,?,?)";
            		 instmt = inconn.prepareStatement(insql);
            		 instmt.setString(1, uid);
            		 instmt.setString(2, realname);
            		 instmt.setString(3, birthday);
            		 instmt.setString(4, qq);
            		 instmt.setString(5, email);
            		 instmt.setString(6, address);
            		 System.out.println("insert customerinfo sql:"+insql);
            	 }else{
            		 String upsql = "update customerinfo set username=?,birthday=?,qq=?,email=?,address=? where uid=?";
            		 instmt = inconn.prepareStatement(upsql);
            		 instmt.setString(1, realname);
            		 instmt.setString(2, birthday);
            		 instmt.setString(3, qq);
            		 instmt.setString(4, email);
            		 instmt.setString(5, address);
            		 instmt.setString(6, uid);
            		 System.out.println("update customerinfo sql:"+upsql);
            	 }
            	 instmt.execute();
            	 System.out.println("uid:"+uid+",phone:"+phone);
             	 stmt.setString(1, null);
            	 stmt.setString(2, uid);
            	 stmt.setString(3, phone==null?"":phone.trim());
            	 stmt.setString(4, "vivi");
            	 stmt.execute();
             }
		}catch(Exception e){
			throw e;
		}finally{
			try{
				if(instmt != null){
					instmt.close();
					instmt = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(sstmt != null){
					sstmt.close();
					sstmt = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
	}
	
	
	public static void run(int index,String actno) throws Exception{
		Connection conn = null;
		Workbook wb = null;   
        PreparedStatement stmt = null;
		try{
			conn = ConnUtil.getConnection();			
			String sql = "insert into userphone values(?,?,?,?)";
			 wb = new HSSFWorkbook(new FileInputStream(filename+index+".xls"));   
			 Sheet sheet = wb.getSheet(sheetname+index);  //获取Sheet1   
             long count = sheet.getPhysicalNumberOfRows();
             DecimalFormat df = new DecimalFormat("0"); 
             stmt = conn.prepareStatement(sql);
             for(int i=0;i<count;i++){
            	 Row row = sheet.getRow(i);           	 
            	 String uid = df.format(row.getCell(0).getNumericCellValue())+"";
            	 String phone = df.format(row.getCell(1).getNumericCellValue())+"";
            	 System.out.println("uid:"+uid+",phone:"+phone);
            	stmt.setString(1, null);
            	stmt.setString(2, uid);
            	stmt.setString(3, phone);
            	stmt.setString(4, actno);
            	stmt.execute();
             }
		}catch(Exception e){
			throw e;
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
}
