package com.xunlei.niux.manager.web.vo;

import com.xunlei.niux.manager.web.task.customer.CustomerNewPayDTO;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.util.StringTools;
import java.io.PrintStream;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class CustomerQueryTask
{
    private static final Logger logger = Logger.getLogger(CustomerQueryTask.class.getName());
    private static String time = null;
    private static String BASEURL = "http://tw07286.sandai.net:8002/";
    private static String customerInterface = BASEURL + "getPayByUidAndAmont?";
    private static String bigCustomerInterface = BASEURL + "getPayAndLoginRecord?";
    private static final int BIGAMOUNT = 300;
    private static List<String> gemeIdList = null;

    static {
        if (time == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            time = sdf.format(cal.getTime());
        }
    }

    private static void init() {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (gemeIdList == null)
            gemeIdList = new ArrayList();
        try
        {
            conn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            String sql = "select gameid from games s1 where s1.status!=0";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String gameId = rs.getString("gameid");
                gemeIdList.add(gameId);
            }
            gemeIdList.add("all");
        } catch (Exception e) {
            e.printStackTrace();
            try
            {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        if ((args != null) && (args.length >= 1)) {
            time = args[0];
        }
        make();
    }

    public static void make() {
        logger.info("------------------------");
        logger.info("init gameList start......");
        init();
        logger.info("customertotal start......");
        deleteCustomer("customertotal");
        logger.info("===customertotal delete");
        makeCustomerTotal();
        logger.info("customertotal done.....");
        logger.info("------------------------");

        logger.info("customernewpersist start......");
        deleteCustomer("customernewpersist");
        logger.info("===customernewpersist delete");
        makeNewPersistCustomer();
        logger.info("customernewpersist done.....");
        logger.info("------------------------");

        logger.info("customernewpay start......");
        deleteCustomer("customernewpay");
        logger.info("===customernewpay delete");
        makeNewPayCustomer();
        logger.info("customernewpay done");
        logger.info("------------------------");

        logger.info("customergameinfo start......");
        deleteCustomer("customergameinfo");
        logger.info("===customergameinfo delete");
        makeGameVipCustomer();
        logger.info("customergameinfo done");
        logger.info("------------------------");

        logger.info("newcustomerquery start.....");
        deleteCustomer("customerquery", 1);
        logger.info("===newcustomerquery delete");
        makeAddCustomer();
        logger.info("newcustomerquery done");
        logger.info("------------------------");

        logger.info("bigcustomer start......");
        deleteCustomer("customerbigpayquery");
        logger.info("===bigcustomer delete");
        makeBigPayCustomer();
        updateBigPayCustomer();
        logger.info("bigcustomer done");

        logger.info("lostcustomerquery start......");
        deleteCustomer("customerquery", 2);
        logger.info("===lostcustomerquery delete");
        makeLostCustomer();
        logger.info("lostcustomerquery done");
        logger.info("------------------------");

        logger.info("reset new and promote status start.....");
        resetCustomerStatus();
        logger.info("reset new and promote status done");
    }

    private static void makeStatus()
    {
        logger.info("reset new and promote status start.....");
        resetCustomerStatus();
        logger.info("reset new and promote status done");
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            String sql = "select * from customerchangeinfo where daytime='" + time + "'";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String uid = rs.getString("uid");
                int isnew = rs.getInt("isnew");
                int ispromote = rs.getInt("ispromote");
                String updatesql = null;
                if (isnew == 1) {
                    updatesql = "update customerdetailquery set isnew=1 where uid='" + uid + "'";
                }
                if (ispromote == 1) {
                    updatesql = "update customerdetailquery set ispromote=1 where uid='" + uid + "'";
                }
                if (updatesql != null) {
                    ctstmt = ctconn.prepareStatement(updatesql);
                    ctstmt.execute();
                }
            }
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成主表的新增晋级状态", null, starttime, endtime, true);
        } catch (Exception e) {
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成主表的新增晋级状态", e.getMessage(), starttime, endtime, false);
            e.printStackTrace();
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void makeNewPersistCustomer()
    {
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            for (String gameId : gemeIdList) {
                StringBuilder sql = getMakePersistStringBuilder(gameId);
                rs = stmt.executeQuery(sql.toString());
                if (rs == null) return;
                String insertsql = "insert into customernewpersist(peopleCount,vip1,vip2,vip3,vip4,vip5,vip6,vip7,vip8,vip9,vip10,daytime,gameId) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
                ctstmt = ctconn.prepareStatement(insertsql);
                CustomerNewPayDTO dto = getCustomerNewPayDTO(rs);
                if (dto != null) {
                    ctstmt.setLong(1, dto.getPayTotalAmt().longValue());
                    ctstmt.setLong(2, dto.getVip1().longValue());
                    ctstmt.setLong(3, dto.getVip2().longValue());
                    ctstmt.setLong(4, dto.getVip3().longValue());
                    ctstmt.setLong(5, dto.getVip4().longValue());
                    ctstmt.setLong(6, dto.getVip5().longValue());
                    ctstmt.setLong(7, dto.getVip6().longValue());
                    ctstmt.setLong(8, dto.getVip7().longValue());
                    ctstmt.setLong(9, dto.getVip8().longValue());
                    ctstmt.setLong(10, dto.getVip9().longValue());
                    ctstmt.setLong(11, dto.getVip10().longValue());
                    ctstmt.setString(12, time);
                    ctstmt.setString(13, gameId.equals("all") ? "0000" : gameId);
                    ctstmt.execute();
                }
            }

            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成新客户数分布", null, starttime, endtime, true);
        } catch (Exception e) {
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成新客户数分布", e.getMessage(), starttime, endtime, false);
            e.printStackTrace();
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void makePersistCustomer()
    {
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            StringBuffer sql = new StringBuffer();
            sql.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 1) ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 2) ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 3) ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 4) ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 5) ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 6) ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 7) ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 8) ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 9) ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 10) ");
            rs = stmt.executeQuery(sql.toString());
            if (rs == null) return;
            String insertsql = "insert into customerpersist(peopleCount,vipGrade,daytime) values(?,?,?)";
            ctstmt = ctconn.prepareStatement(insertsql);
            int vipGrade = 1;
            while (rs.next()) {
                ctstmt.setString(1, rs.getString(1) == null ? "0" : rs.getString(1));
                ctstmt.setInt(2, vipGrade);
                ctstmt.setString(3, time);
                ctstmt.execute();
                vipGrade++;
            }

            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成客户数分布", null, starttime, endtime, true);
        } catch (Exception e) {
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成客户数分布", e.getMessage(), starttime, endtime, false);
            e.printStackTrace();
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static StringBuilder getMakePersistStringBuilder(String gameId) {
        String gameCondtion = "";
        if (!"all".equals(gameId)) {
            gameCondtion = gameCondtion + " and payGameId='" + gameId + "'";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 1 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 2 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 3 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 4 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 5 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 6 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 7 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 8 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 9 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 10 " + gameCondtion + ") ");
//        System.out.println(sql);
        return sql;
    }

    private static StringBuilder getMakePayStringBuilder(String gameId) {
        String gameCondtion = "";
        if (!"all".equals(gameId)) {
            gameCondtion = gameCondtion + " and payGameId='" + gameId + "'";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "'  AND vipGrade = 1 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE  lastPayTime = '" + time + "'  AND vipGrade = 2  " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "'  AND vipGrade = 3 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "'  AND vipGrade = 4 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "'  AND vipGrade = 5 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "'  AND vipGrade = 6 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "'  AND vipGrade = 7 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "'  AND vipGrade = 8 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "'  AND vipGrade = 9 " + gameCondtion + ") ")
                .append("UNION ALL ")
                .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "'  AND vipGrade = 10 " + gameCondtion + ") ");
//        System.out.println(sql);
        return sql;
    }

    private static CustomerNewPayDTO getCustomerNewPayDTO(ResultSet rs)
    {
        CustomerNewPayDTO dto = null;
        int i = 0;
        try {
            while (rs.next()) {
                i++;
                switch (i) {
                    case 1:
                        dto = new CustomerNewPayDTO();
                        dto.setVip1(Long.valueOf(rs.getLong(1))); break;
                    case 2:
                        dto.setVip2(Long.valueOf(rs.getLong(1))); break;
                    case 3:
                        dto.setVip3(Long.valueOf(rs.getLong(1))); break;
                    case 4:
                        dto.setVip4(Long.valueOf(rs.getLong(1))); break;
                    case 5:
                        dto.setVip5(Long.valueOf(rs.getLong(1))); break;
                    case 6:
                        dto.setVip6(Long.valueOf(rs.getLong(1))); break;
                    case 7:
                        dto.setVip7(Long.valueOf(rs.getLong(1))); break;
                    case 8:
                        dto.setVip8(Long.valueOf(rs.getLong(1))); break;
                    case 9:
                        dto.setVip9(Long.valueOf(rs.getLong(1))); break;
                    case 10:
                        dto.setVip10(Long.valueOf(rs.getLong(1)));
                }
            }
            dto.setPayTotalAmt(Long.valueOf(dto.getVip1().longValue() + dto.getVip2().longValue() + dto.getVip3().longValue() + dto.getVip4().longValue() + dto.getVip5().longValue() + dto.getVip6().longValue() + dto.getVip7().longValue() + dto.getVip8().longValue() + dto.getVip9().longValue() + dto.getVip10().longValue()));
        } catch (SQLException e) {
            logger.error("customerNewPayDTO error", e);
            return null;
        }
        return dto;
    }

    public static void makeNewPayCustomer()
    {
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            for (String gameId : gemeIdList) {
                StringBuilder sql = getMakePayStringBuilder(gameId);
                rs = stmt.executeQuery(sql.toString());
                if (rs == null) return;
                String insertsql = "insert into customernewpay(payTotalAmt,vip1,vip2,vip3,vip4,vip5,vip6,vip7,vip8,vip9,vip10,daytime,gameId) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
                ctstmt = ctconn.prepareStatement(insertsql);
                CustomerNewPayDTO dto = getCustomerNewPayDTO(rs);
                if (dto != null) {
                    ctstmt.setLong(1, dto.getPayTotalAmt().longValue());
                    ctstmt.setLong(2, dto.getVip1().longValue());
                    ctstmt.setLong(3, dto.getVip2().longValue());
                    ctstmt.setLong(4, dto.getVip3().longValue());
                    ctstmt.setLong(5, dto.getVip4().longValue());
                    ctstmt.setLong(6, dto.getVip5().longValue());
                    ctstmt.setLong(7, dto.getVip6().longValue());
                    ctstmt.setLong(8, dto.getVip7().longValue());
                    ctstmt.setLong(9, dto.getVip8().longValue());
                    ctstmt.setLong(10, dto.getVip9().longValue());
                    ctstmt.setLong(11, dto.getVip10().longValue());
                    ctstmt.setString(12, time);
                    ctstmt.setString(13, gameId.equals("all") ? "0000" : gameId);
                    ctstmt.execute();
                }
            }
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成客户新付费分布", null, starttime, endtime, true);
        } catch (Exception e) {
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成客户新付费分布", e.getMessage(), starttime, endtime, false);
            e.printStackTrace();
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void makePayCustomer()
    {
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            for (Iterator localIterator = gemeIdList.iterator(); localIterator.hasNext();
                 rs.next())
            {
                String gameId = (String)localIterator.next();
                StringBuilder sql = getMakePayStringBuilder(gameId);
                rs = stmt.executeQuery(sql.toString());
                if (rs == null) return;
                String insertsql = "insert into customerpay(payTotalAmt,vipGrade,daytime,gameId) values(?,?,?,?)";
                ctstmt = ctconn.prepareStatement(insertsql);
                int vipGrade = 1;
                while(rs.next()) {
                    ctstmt.setString(1, rs.getString(1) == null ? "0" : rs.getString(1));
                    ctstmt.setInt(2, vipGrade);
                    ctstmt.setString(3, time);
                    ctstmt.setString(4, gameId.equals("all") ? "0000" : gameId);
                    ctstmt.execute();
                    vipGrade++;
                }
            }

            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成客户付费分布", null, starttime, endtime, true);
        } catch (Exception e) {
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成客户付费分布", e.getMessage(), starttime, endtime, false);
            e.printStackTrace();
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteCustomer(String tableName)
    {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try
        {
            conn = ConnUtil.getConn();
            String sql = "delete from " + tableName + " where daytime=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, time);
            pstmt.execute();
        }
        catch (Exception e)
        {
            e.printStackTrace();
            try
            {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteCustomer(String tableName, int type)
    {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try
        {
            conn = ConnUtil.getConn();
            String sql = "delete from " + tableName + " where daytime=? and type=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, time);
            pstmt.setInt(2, type);
            pstmt.execute();
        }
        catch (Exception e)
        {
            e.printStackTrace();
            try
            {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void makeCustomerTotal()
    {
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            for (int vipGrade = 1; vipGrade <= 10; vipGrade++) {
                StringBuffer sql = new StringBuffer();
                sql.append("(SELECT COUNT(*) FROM customerdetailquery  ")
                        .append(" where vipGrade=" + vipGrade + ")")
                        .append("UNION ALL ")
                        .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1  ")
                        .append(" and vipGrade=" + vipGrade + ")")
                        .append("UNION ALL ")
                        .append(" (SELECT count(*) FROM customerdetailquery WHERE ((TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 5) AND vipGrade>=1 and vipGrade<=7  and vipGrade=" + vipGrade + ") or ((TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 2) AND vipGrade>=8 and vipGrade<=10 and vipGrade=" + vipGrade + "))")
                        .append("UNION ALL ")
                        .append("(SELECT COUNT(*) FROM customerdetailquery WHERE isnew = 1  ")
                        .append(" and vipGrade=" + vipGrade + ")")
                        .append("UNION ALL ")
                        .append("(SELECT COUNT(*) FROM customerdetailquery WHERE ispromote = 1  ")
                        .append(" and vipGrade=" + vipGrade + ")")
                        .append("UNION ALL ")
                        .append("(SELECT COUNT(*) FROM customerdetailquery WHERE 1=1 ")
                        .append(" and bvipGrade=" + vipGrade + ")")
                        .append("UNION ALL ")
                        .append("(SELECT COUNT(*) FROM customerdetailquery WHERE isBack = 1   ")
                        .append(" and vipGrade=" + vipGrade + ")")
                        .append("UNION ALL ")
                        .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery  where lastPayTime='" + time + "'")
                        .append(" and vipGrade=" + vipGrade + ")")
                        .append("UNION ALL ")
                        .append("(SELECT SUM(payTotalAmt) FROM customerdetailquery WHERE isnew = 1 ")
                        .append(" and vipGrade=" + vipGrade + ")");
                rs = stmt.executeQuery(sql.toString());
                if (rs == null) return;
                String insertsql = "insert into customertotal(customertotal,persisttotal,lostcustomertotal,addcustomertotal,promotetotal,reducetotal,backtotal,paytotal,addpaytotal,daytime,vipGrade) values(?,?,?,?,?,?,?,?,?,?,?)";
                ctstmt = ctconn.prepareStatement(insertsql);
                int jj = 1;
                while (rs.next()) {
                    ctstmt.setString(jj, rs.getString(1) == null ? "0" : rs.getString(1));
                    jj++;
                }
                ctstmt.setString(10, time);
                ctstmt.setInt(11, vipGrade);
                ctstmt.execute();
            }

            StringBuffer sql = new StringBuffer();
            sql.append("(SELECT COUNT(*) FROM customerdetailquery)  ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1)  ")
                    .append("UNION ALL ")
                    .append(" (SELECT count(*) FROM customerdetailquery WHERE ((TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 5) AND vipGrade>=1 and vipGrade<=7  ) or ((TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 2) AND vipGrade>=8 and vipGrade<=10 ))")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE isnew = 1)  ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE ispromote = 1)  ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE bvipGrade > 0)  ")
                    .append("UNION ALL ")
                    .append("(SELECT COUNT(*) FROM customerdetailquery WHERE isBack = 1)   ")
                    .append("UNION ALL ")
                    .append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery where lastPayTime='" + time + "')  ")
                    .append("UNION ALL ")
                    .append("(SELECT SUM(payTotalAmt) FROM customerdetailquery WHERE isnew = 1) ");
            rs = stmt.executeQuery(sql.toString());
            if (rs == null) return;
            String insertsql = "insert into customertotal(customertotal,persisttotal,lostcustomertotal,addcustomertotal,promotetotal,reducetotal,backtotal,paytotal,addpaytotal,daytime,vipGrade) values(?,?,?,?,?,?,?,?,?,?,?)";
            ctstmt = ctconn.prepareStatement(insertsql);
            int jj = 1;
            while (rs.next()) {
                ctstmt.setString(jj, rs.getString(1) == null ? "0" : rs.getString(1));
                jj++;
            }
            ctstmt.setString(10, time);
            ctstmt.setInt(11, 100);
            ctstmt.execute();
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成客户统计记录", null, starttime, endtime, true);
        } catch (Exception e) {
            e.printStackTrace();
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成客户统计记录", e.getMessage(), starttime, endtime, false);
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetCustomerStatus()
    {
        Connection ctconn = null;
        PreparedStatement ctstmt = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            ctconn = ConnUtil.getConn();
            String insertsql = "UPDATE customerdetailquery SET isNew = 0,isPromote=0,bvipGrade=0 WHERE isNew=1 OR isPromote=1 OR bvipGrade>0";
            ctstmt = ctconn.prepareStatement(insertsql);
            ctstmt.execute();
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("重置客户详情中的相关状态", null, starttime, endtime, true);
        } catch (Exception e) {
            e.printStackTrace();
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("重置客户详情中的相关状态", e.getMessage(), starttime, endtime, false);
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void makeAddCustomer()
    {
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM customerdetailquery WHERE isnew = 1 OR isPromote = 1 ");
            rs = stmt.executeQuery(sql.toString());
            if (rs == null) return;
            String insertsql = "insert into customerquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ctstmt = ctconn.prepareStatement(insertsql);
            while (rs.next()) {
                ctstmt.setString(1, null);
                ctstmt.setString(2, rs.getString("uid"));
                ctstmt.setString(3, rs.getString("account"));
                ctstmt.setInt(4, rs.getInt("vipGrade"));
                ctstmt.setInt(5, rs.getInt("vipStatus"));
                ctstmt.setLong(6, rs.getLong("gameCount"));
                ctstmt.setLong(7, rs.getLong("payCount"));
                ctstmt.setLong(8, rs.getLong("payTotalAmt"));
                ctstmt.setString(9, rs.getString("lastPayTime"));
                ctstmt.setString(10, rs.getString("lastLoginTime"));
                ctstmt.setLong(11, rs.getLong("callCount"));
                ctstmt.setLong(12, rs.getLong("integral"));
                ctstmt.setString(13, rs.getString("phone"));
                ctstmt.setString(14, rs.getString("contactNumber"));
                ctstmt.setString(15, rs.getString("qq"));
                ctstmt.setString(16, rs.getString("email"));
                ctstmt.setInt(17, 1);
                ctstmt.setString(18, time);
                ctstmt.setString(19, "");
                ctstmt.setString(20, rs.getString("upGameId"));
                ctstmt.setString(21, rs.getString("payGameId"));
                ctstmt.setString(22, rs.getString("loginGameId"));
                ctstmt.setString(23, rs.getString("lastCallTime"));
                ctstmt.setString(24, rs.getString("lastCaller"));
                ctstmt.setString(25, rs.getString("customerService"));
                ctstmt.execute();
            }
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成新增客户记录", null, starttime, endtime, true);
        } catch (Exception e) {
            e.printStackTrace();
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成新增客户记录", e.getMessage(), starttime, endtime, false);
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void makeGameVipCustomer()
    {
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT  upgameid,COUNT(*) co ,SUM(orderTotalAmt) ota ,liveVipGrade FROM customerdetailquery ")
                    .append("  WHERE (isnew = 1 OR ispromote = 1) AND upgameid <> '' ")
                    .append("  GROUP BY upgameid,livevipgrade  order by upgameid asc,livevipgrade desc;");
            rs = stmt.executeQuery(sql.toString());
            if (rs == null) return;
            String insertsql = "insert into customergameinfo values(?,?,?,?,?,?,?,?,?)";
            ctstmt = ctconn.prepareStatement(insertsql);
            while (rs.next()) {
                ctstmt.setString(1, null);
                ctstmt.setString(2, time);
                ctstmt.setString(3, rs.getString("upgameid"));
                ctstmt.setLong(4, rs.getLong("co"));
                ctstmt.setLong(5, rs.getLong("ota"));
                ctstmt.setInt(6, rs.getInt("liveVipGrade"));
                ctstmt.setString(7, "");
                ctstmt.setString(8, "");
                ctstmt.setString(9, "");
                ctstmt.execute();
            }

            StringBuffer sumsql = new StringBuffer("");
            sumsql.append("SELECT  upgameid,COUNT(*) co ,SUM(orderTotalAmt) ota  FROM customerdetailquery ")
                    .append("  WHERE (isnew = 1 OR ispromote = 1) AND upgameid <> ''  ")
                    .append("  GROUP BY upgameid  ORDER BY upgameid ASC; ");
            rs = stmt.executeQuery(sumsql.toString());
            if (rs == null) return;
            while (rs.next()) {
                ctstmt.setString(1, null);
                ctstmt.setString(2, time);
                ctstmt.setString(3, rs.getString("upgameid"));
                ctstmt.setLong(4, rs.getLong("co"));
                ctstmt.setLong(5, rs.getLong("ota"));
                ctstmt.setInt(6, 100);
                ctstmt.setString(7, "");
                ctstmt.setString(8, "");
                ctstmt.setString(9, "");
                ctstmt.execute();
            }
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成游戏vip等级新增用户统计记录", null, starttime, endtime, true);
        } catch (Exception e) {
            e.printStackTrace();
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成游戏vip等级新增用户统计记录", e.getMessage(), starttime, endtime, false);
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void makeLostCustomer()
    {
        Connection conn = null;
        Connection ctconn = null;
        Connection uconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        PreparedStatement utstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            uconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            StringBuffer sql = new StringBuffer();
            sql.append("(SELECT * FROM customerdetailquery WHERE (TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 5) AND vipGrade>=1 and vipGrade<=7 ) ")
                    .append("  UNION  all")
                    .append(" (SELECT * FROM customerdetailquery WHERE (TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 2) AND vipGrade>=8 and vipGrade<=10 )");
            rs = stmt.executeQuery(sql.toString());
            if (rs == null) return;
            String insertsql = "insert into customerquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ctstmt = ctconn.prepareStatement(insertsql);
            String updatesql = "update customerdetailquery set vipStatus=2 where uid=?";
            utstmt = uconn.prepareStatement(updatesql);
            Set gameset = new HashSet();
            while (rs.next()) {
                String uid = rs.getString("uid");
                ctstmt.setString(1, null);
                ctstmt.setString(2, uid);
                ctstmt.setString(3, rs.getString("account"));
                ctstmt.setInt(4, rs.getInt("vipGrade"));
                ctstmt.setInt(5, 2);
                ctstmt.setLong(6, rs.getLong("gameCount"));
                ctstmt.setLong(7, rs.getLong("payCount"));
                ctstmt.setLong(8, rs.getLong("payTotalAmt"));
                ctstmt.setString(9, rs.getString("lastPayTime"));
                ctstmt.setString(10, rs.getString("lastLoginTime"));
                ctstmt.setLong(11, rs.getLong("callCount"));
                ctstmt.setLong(12, rs.getLong("integral"));
                ctstmt.setString(13, rs.getString("phone"));
                ctstmt.setString(14, rs.getString("contactNumber"));
                ctstmt.setString(15, rs.getString("qq"));
                ctstmt.setString(16, rs.getString("email"));
                ctstmt.setInt(17, 2);
                ctstmt.setString(18, time);
                if (!StringTools.isEmpty(uid)) {
                    uid = uid.trim();
                }
                String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(bigCustomerInterface + "uid=" + uid + "&date=" + time);
                ObjectMapper mapper = new ObjectMapper();
                JsonRecord record = (JsonRecord)mapper.readValue(jsonStr, JsonRecord.class);

                String gameName = "";
                if (gameset != null) gameset.clear();
                List recordList = record.getList();
                for (int i = 0; i < recordList.size(); i++) {
                    Record rd = (Record)recordList.get(i);
                    gameset.add(URLDecoder.decode(rd.getGameName(), "utf8"));
                }
                for (Iterator iter = gameset.iterator(); iter.hasNext(); ) {
                    gameName = gameName + (String)iter.next() + ",";
                }
                if ((gameName != null) && (gameName.indexOf(".") != -1))
                    gameName = gameName.substring(0, gameName.lastIndexOf(","));
                ctstmt.setString(19, gameName);
                ctstmt.setString(20, "");
                ctstmt.setString(21, rs.getString("payGameId"));
                ctstmt.setString(22, rs.getString("loginGameId"));
                ctstmt.setString(23, rs.getString("lastCallTime"));
                ctstmt.setString(24, rs.getString("lastCaller"));
                ctstmt.setString(25, rs.getString("customerService"));
                ctstmt.execute();

                utstmt.setString(1, uid);
                utstmt.execute();
            }
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成流失客户记录", null, starttime, endtime, true);
        } catch (Exception e) {
            e.printStackTrace();
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成流失客户记录", e.getMessage(), starttime, endtime, false);
            try
            {
                if (utstmt != null) {
                    utstmt.close();
                    utstmt = null;
                }
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (uconn != null) {
                    uconn.close();
                    uconn = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (utstmt != null) {
                    utstmt.close();
                    utstmt = null;
                }
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (uconn != null) {
                    uconn.close();
                    uconn = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void makeBigPayCustomer()
    {
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        String starttime = TaskLogUtil.getNowTime();
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM customerdetailquery WHERE lastPayTime = '" + time + "' and lastModifyAmt>=" + 300);
            rs = stmt.executeQuery(sql.toString());
            if (rs == null) return;
            String insertsql = "insert into customerbigpayquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ctstmt = ctconn.prepareStatement(insertsql);
            Set gameSet = new HashSet();
            String gameId = null;
            String serverIds = "";
            double bigPayAmt = 0.0D;
            while (rs.next()) {
                String uid = rs.getString("uid");
                String url = customerInterface + "uid=" + uid + "&time=" + time + "&amount=" + 300;
                logger.info("makeBigPayCustomer:"+url);
                String jsonStr = null;
                try {
                    jsonStr = HttpClientUtil.getInfoForHttpGetMothed(url);
                } catch (Exception e2) {
                    logger.error("Fatal getPayByUidAndAmont: resp:"+jsonStr,e2);
                }
                try
                {
                    if (jsonStr != null)
                    {
                        ObjectMapper mapper = new ObjectMapper();
                        BigPayJsonRecord record = (BigPayJsonRecord)mapper.readValue(jsonStr, BigPayJsonRecord.class);
                        List<BigPayRecord> recordList = record.getList();
                        gameSet.clear();
                        bigPayAmt = 0.0D;
                        serverIds = "";
                        if ((recordList != null) && (recordList.size() != 0))
                        {
                            for (BigPayRecord detail : recordList) {
                                gameSet.add(detail.getGameId());
                            }

                            for (Iterator iter = gameSet.iterator(); iter.hasNext(); ) {
                                String gameid = (String)iter.next();
                                for (BigPayRecord detail : recordList) {
                                    if (gameid.equals(detail.getGameId())) {
                                        bigPayAmt += detail.getAmount();
                                        serverIds = serverIds + detail.getServerId() + ",";
                                        gameId = gameid;
                                    }
                                }
                                if (bigPayAmt >= 300.0D) {
                                    ctstmt.setString(1, null);
                                    ctstmt.setString(2, uid);
                                    ctstmt.setString(3, rs.getString("account"));
                                    ctstmt.setInt(4, rs.getInt("vipGrade"));
                                    ctstmt.setInt(5, rs.getInt("vipStatus"));
                                    ctstmt.setLong(6, rs.getLong("gameCount"));
                                    ctstmt.setLong(7, rs.getLong("payCount"));
                                    ctstmt.setLong(8, rs.getLong("payTotalAmt"));
                                    ctstmt.setString(9, rs.getString("lastPayTime"));
                                    ctstmt.setString(10, rs.getString("lastLoginTime"));
                                    ctstmt.setLong(11, rs.getLong("callCount"));
                                    ctstmt.setLong(12, rs.getLong("integral"));
                                    ctstmt.setString(13, rs.getString("phone"));
                                    ctstmt.setLong(14, (long)bigPayAmt);
                                    ctstmt.setString(15, rs.getString("contactNumber"));
                                    ctstmt.setString(16, rs.getString("qq"));
                                    ctstmt.setString(17, rs.getString("email"));
                                    ctstmt.setString(18, time);
                                    ctstmt.setString(19, gameId);
                                    ctstmt.setString(20, serverIds);
                                    ctstmt.setString(21, rs.getString("lastCaller"));
                                    ctstmt.setString(22, rs.getString("lastCallTime"));
                                    ctstmt.setString(23, rs.getString("customerService"));
                                    ctstmt.execute();
                                }
                            }
                        }
                    } } catch (Exception ee) { ee.printStackTrace(); }

            }

            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成大额充值客户记录", null, starttime, endtime, true);
        } catch (Exception e) {
            e.printStackTrace();
            String endtime = TaskLogUtil.getNowTime();
            TaskLogUtil.addLog("生成大额充值客户记录", e.getMessage(), starttime, endtime, false);
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateBigPayCustomer()
    {
        Connection conn = null;
        Connection ctconn = null;
        Statement stmt = null;
        PreparedStatement ctstmt = null;
        ResultSet rs = null;
        try {
            conn = ConnUtil.getConn();
            ctconn = ConnUtil.getConn();
            stmt = ConnUtil.getStatement(conn);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM customerbigpayquery");
            rs = stmt.executeQuery(sql.toString());
            if (rs == null) return;
            String insertsql = "update customerbigpayquery set bigPayAmt=?,gameId=?,serverIds=? where uid=? and daytime=?";
            ctstmt = ctconn.prepareStatement(insertsql);
            Set gameSet = new HashSet();
            String gameId = null;
            String serverIds = "";
            double bigPayAmt = 0.0D;
            while (rs.next()) {
                String uid = rs.getString("uid");
                String mytime = rs.getString("daytime");
                String url = customerInterface + "uid=" + uid + "&time=" + mytime + "&amount=" + 300;
                logger.info("updateBigPayCustomer:"+url);
                String jsonStr = null;
                try {
                    jsonStr = HttpClientUtil.getInfoForHttpGetMothed(url);
                } catch (Exception e2) {
                    logger.error("Fatal updateBigPayCustomer:resp"+jsonStr,e2);
                }
                if (jsonStr != null)
                {
                    ObjectMapper mapper = new ObjectMapper();
                    BigPayJsonRecord record = (BigPayJsonRecord)mapper.readValue(jsonStr, BigPayJsonRecord.class);
                    List<BigPayRecord> recordList = record.getList();
                    gameSet.clear();
                    bigPayAmt = 0.0D;
                    serverIds = "";
                    if ((recordList != null) && (recordList.size() != 0))
                    {
                        for (BigPayRecord detail : recordList) {
                            gameSet.add(detail.getGameId());
                        }

                        for (Iterator iter = gameSet.iterator(); iter.hasNext(); ) {
                            String gameid = (String)iter.next();
                            for (BigPayRecord detail : recordList) {
                                if (gameid.equals(detail.getGameId())) {
                                    bigPayAmt += detail.getAmount();
                                    serverIds = serverIds + detail.getServerId() + ",";
                                    gameId = gameid;
                                }
                            }
                            if (bigPayAmt >= 300.0D) {
                                ctstmt.setLong(1, (long)bigPayAmt);
                                ctstmt.setString(2, gameId);
                                ctstmt.setString(3, serverIds);
                                ctstmt.setString(4, uid);
                                ctstmt.setString(5, mytime);
                                ctstmt.execute();
                            }
                        }
                    }
                }
            } } catch (Exception e) { e.printStackTrace();
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally
        {
            try
            {
                if (ctstmt != null) {
                    ctstmt.close();
                    ctstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (ctconn != null) {
                    ctconn.close();
                    ctconn = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}