package com.xunlei.niux.manager.web.vo;

import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class CustomerQueryRepairTask
{
	private static final Logger logger = Logger.getLogger(CustomerQueryRepairTask.class.getName());
	private static String time = null;
	private static String customerInterface = "http://tw07286.sandai.net:8002/getPayByUidAndAmont?";
	private static String bigCustomerInterface = "http://tw07286.sandai.net:8002/getPayAndLoginRecord?";

	public static void main(String[] args)
	{
		time = args[0];
		make();
	}

	public static void make() {
		logger.info("------------------------");
		logger.info("开始生成客户统计记录......");
		deleteCustomer("customertotal");
		logger.info("===客户统计记录删除完毕！");
		makeCustomerTotal();
		logger.info("客户统计记录生成完毕！");
		logger.info("------------------------");

		logger.info("开始生成客户数分布记录......");
		deleteCustomer("customerpersist");
		logger.info("===客户数分布记录删除完毕！");
		makePersistCustomer();
		logger.info("客户数分布记录生成完毕！");
		logger.info("------------------------");

		logger.info("开始生成客户付费分布记录......");
		deleteCustomer("customerpay");
		logger.info("===客户付费分布记录删除完毕！");
		makePayCustomer();
		logger.info("客户付费分布记录生成完毕！");
		logger.info("------------------------");

		logger.info("开始生成大额充值客户记录......");
		deleteCustomer("customerbigpayquery");
		logger.info("===客户付费分布记录删除完毕！");
		makeBigPayCustomer();
		updateBigPayCustomer();
		logger.info("大额充值客户记录生成完毕！");

		logger.info("开始重置客户的新增和晋级状态......");
		resetCustomerStatus();
		logger.info("客户的新增和晋级状态重置完毕！");
	}

	public static void makePersistCustomer()
	{
		Connection conn = null;
		Connection ctconn = null;
		Statement stmt = null;
		PreparedStatement ctstmt = null;
		ResultSet rs = null;
		String starttime = TaskLogUtil.getNowTime();
		try {
			conn = ConnUtil.getConnection();
			ctconn = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			StringBuffer sql = new StringBuffer();
			sql.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 1) ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 2) ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 3) ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 4) ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 5) ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 6) ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 7) ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 8) ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 9) ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1 AND vipGrade = 10) ");
			rs = stmt.executeQuery(sql.toString());
			if (rs == null) return;
			String insertsql = "insert into customerpersist(peopleCount,vipGrade,daytime) values(?,?,?)";
			ctstmt = ctconn.prepareStatement(insertsql);
			int vipGrade = 1;
			while (rs.next()) {
				ctstmt.setString(1, rs.getString(1) == null ? "0" : rs.getString(1));
				ctstmt.setInt(2, vipGrade);
				ctstmt.setString(3, time);
				ctstmt.execute();
				vipGrade++;
			}

			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成客户数分布", null, starttime, endtime, true);
		} catch (Exception e) {
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成客户数分布", e.getMessage(), starttime, endtime, false);
			e.printStackTrace();
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void makePayCustomer()
	{
		Connection conn = null;
		Connection ctconn = null;
		Statement stmt = null;
		PreparedStatement ctstmt = null;
		ResultSet rs = null;
		String starttime = TaskLogUtil.getNowTime();
		try {
			conn = ConnUtil.getConnection();
			ctconn = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			StringBuffer sql = new StringBuffer();
			sql.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 1) ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 2) ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 3) ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 4) ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 5) ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 6) ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 7) ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 8) ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 9) ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery WHERE lastPayTime = '" + time + "' AND vipGrade = 10) ");
			rs = stmt.executeQuery(sql.toString());
			if (rs == null) return;
			String insertsql = "insert into customerpay(payTotalAmt,vipGrade,daytime) values(?,?,?)";
			ctstmt = ctconn.prepareStatement(insertsql);
			int vipGrade = 1;
			while (rs.next()) {
				ctstmt.setString(1, rs.getString(1) == null ? "0" : rs.getString(1));
				ctstmt.setInt(2, vipGrade);
				ctstmt.setString(3, time);
				ctstmt.execute();
				vipGrade++;
			}
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成客户付费分布", null, starttime, endtime, true);
		} catch (Exception e) {
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成客户付费分布", e.getMessage(), starttime, endtime, false);
			e.printStackTrace();
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void deleteCustomer(String tableName)
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		try
		{
			conn = ConnUtil.getConnection();
			String sql = "delete from " + tableName + " where daytime=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, time);
			pstmt.execute();
		}
		catch (Exception e)
		{
			e.printStackTrace();
			try
			{
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void deleteCustomer(String tableName, int type)
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		try
		{
			conn = ConnUtil.getConnection();
			String sql = "delete from " + tableName + " where daytime=? and type=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, time);
			pstmt.setInt(2, type);
			pstmt.execute();
		}
		catch (Exception e)
		{
			e.printStackTrace();
			try
			{
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void makeCustomerTotal()
	{
		Connection conn = null;
		Connection ctconn = null;
		Statement stmt = null;
		PreparedStatement ctstmt = null;
		ResultSet rs = null;
		String starttime = TaskLogUtil.getNowTime();
		try {
			conn = ConnUtil.getConnection();
			ctconn = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			for (int vipGrade = 1; vipGrade <= 10; vipGrade++) {
				StringBuffer sql = new StringBuffer();
				sql.append("(SELECT COUNT(*) FROM customerdetailquery  ")
						.append(" where vipGrade=" + vipGrade + ")")
						.append("UNION ALL ")
						.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1  ")
						.append(" and vipGrade=" + vipGrade + ")")
						.append("UNION ALL ")
						.append(" (SELECT count(*) FROM customerdetailquery WHERE ((TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 5) AND vipGrade>=1 and vipGrade<=7  and vipGrade=" + vipGrade + ") or ((TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 2) AND vipGrade>=8 and vipGrade<=10 and vipGrade=" + vipGrade + "))")
						.append("UNION ALL ")
						.append("(SELECT COUNT(*) FROM customerdetailquery WHERE isnew = 1  ")
						.append(" and vipGrade=" + vipGrade + ")")
						.append("UNION ALL ")
						.append("(SELECT COUNT(*) FROM customerdetailquery WHERE ispromote = 1  ")
						.append(" and vipGrade=" + vipGrade + ")")
						.append("UNION ALL ")
						.append("(SELECT COUNT(*) FROM customerdetailquery WHERE 1=1 ")
						.append(" and bvipGrade=" + vipGrade + ")")
						.append("UNION ALL ")
						.append("(SELECT COUNT(*) FROM customerdetailquery WHERE isBack = 1   ")
						.append(" and vipGrade=" + vipGrade + ")")
						.append("UNION ALL ")
						.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery  where lastPayTime='" + time + "'")
						.append(" and vipGrade=" + vipGrade + ")")
						.append("UNION ALL ")
						.append("(SELECT SUM(payTotalAmt) FROM customerdetailquery WHERE isnew = 1 ")
						.append(" and vipGrade=" + vipGrade + ")");
				rs = stmt.executeQuery(sql.toString());
				if (rs == null) return;
				String insertsql = "insert into customertotal(customertotal,persisttotal,lostcustomertotal,addcustomertotal,promotetotal,reducetotal,backtotal,paytotal,addpaytotal,daytime,vipGrade) values(?,?,?,?,?,?,?,?,?,?,?)";
				ctstmt = ctconn.prepareStatement(insertsql);
				int jj = 1;
				while (rs.next()) {
					ctstmt.setString(jj, rs.getString(1) == null ? "0" : rs.getString(1));
					jj++;
				}
				ctstmt.setString(10, time);
				ctstmt.setInt(11, vipGrade);
				ctstmt.execute();
			}

			StringBuffer sql = new StringBuffer();
			sql.append("(SELECT COUNT(*) FROM customerdetailquery)  ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE vipStatus = 1)  ")
					.append("UNION ALL ")
					.append(" (SELECT count(*) FROM customerdetailquery WHERE ((TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 5) AND vipGrade>=1 and vipGrade<=7  ) or ((TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 2) AND vipGrade>=8 and vipGrade<=10 ))")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE isnew = 1)  ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE ispromote = 1)  ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE bvipGrade > 0)  ")
					.append("UNION ALL ")
					.append("(SELECT COUNT(*) FROM customerdetailquery WHERE isBack = 1)   ")
					.append("UNION ALL ")
					.append("(SELECT SUM(lastModifyAmt) FROM customerdetailquery where lastPayTime='" + time + "')  ")
					.append("UNION ALL ")
					.append("(SELECT SUM(payTotalAmt) FROM customerdetailquery WHERE isnew = 1) ");
			rs = stmt.executeQuery(sql.toString());
			if (rs == null) return;
			String insertsql = "insert into customertotal(customertotal,persisttotal,lostcustomertotal,addcustomertotal,promotetotal,reducetotal,backtotal,paytotal,addpaytotal,daytime,vipGrade) values(?,?,?,?,?,?,?,?,?,?,?)";
			ctstmt = ctconn.prepareStatement(insertsql);
			int jj = 1;
			while (rs.next()) {
				ctstmt.setString(jj, rs.getString(1) == null ? "0" : rs.getString(1));
				jj++;
			}
			ctstmt.setString(10, time);
			ctstmt.setInt(11, 100);
			ctstmt.execute();
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成客户统计记录", null, starttime, endtime, true);
		} catch (Exception e) {
			e.printStackTrace();
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成客户统计记录", e.getMessage(), starttime, endtime, false);
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void resetCustomerStatus()
	{
		Connection ctconn = null;
		PreparedStatement ctstmt = null;
		String starttime = TaskLogUtil.getNowTime();
		try {
			ctconn = ConnUtil.getConnection();
			String insertsql = "UPDATE customerdetailquery SET isNew = 0,isPromote=0,bvipGrade=0 WHERE isNew=1 OR isPromote=1 OR bvipGrade>0";
			ctstmt = ctconn.prepareStatement(insertsql);
			ctstmt.execute();
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("重置客户详情中的相关状态", null, starttime, endtime, true);
		} catch (Exception e) {
			e.printStackTrace();
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("重置客户详情中的相关状态", e.getMessage(), starttime, endtime, false);
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void makeAddCustomer()
	{
		Connection conn = null;
		Connection ctconn = null;
		Statement stmt = null;
		PreparedStatement ctstmt = null;
		ResultSet rs = null;
		String starttime = TaskLogUtil.getNowTime();
		try {
			conn = ConnUtil.getConnection();
			ctconn = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT * FROM customerdetailquery WHERE isnew = 1 OR isPromote = 1 ");
			rs = stmt.executeQuery(sql.toString());
			if (rs == null) return;
			String insertsql = "insert into customerquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			ctstmt = ctconn.prepareStatement(insertsql);
			int count = 0;
			while (rs.next()) {
				ctstmt.setString(1, null);
				ctstmt.setString(2, rs.getString("uid"));
				ctstmt.setString(3, rs.getString("account"));
				ctstmt.setInt(4, rs.getInt("vipGrade"));
				ctstmt.setInt(5, rs.getInt("vipStatus"));
				ctstmt.setLong(6, rs.getLong("gameCount"));
				ctstmt.setLong(7, rs.getLong("payCount"));
				ctstmt.setLong(8, rs.getLong("payTotalAmt"));
				ctstmt.setString(9, rs.getString("lastPayTime"));
				ctstmt.setString(10, rs.getString("lastLoginTime"));
				ctstmt.setLong(11, rs.getLong("callCount"));
				ctstmt.setLong(12, rs.getLong("integral"));
				ctstmt.setString(13, rs.getString("phone"));
				ctstmt.setString(14, rs.getString("contactNumber"));
				ctstmt.setString(15, rs.getString("qq"));
				ctstmt.setString(16, rs.getString("email"));
				ctstmt.setInt(17, 1);
				ctstmt.setString(18, time);
				ctstmt.setString(19, "");
				ctstmt.execute();
				count++;
			}
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成新增客户记录", null, starttime, endtime, true);
		} catch (Exception e) {
			e.printStackTrace();
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成新增客户记录", e.getMessage(), starttime, endtime, false);
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void makeLostCustomer()
	{
		Connection conn = null;
		Connection ctconn = null;
		Connection uconn = null;
		Statement stmt = null;
		PreparedStatement ctstmt = null;
		PreparedStatement utstmt = null;
		ResultSet rs = null;
		String starttime = TaskLogUtil.getNowTime();
		try {
			conn = ConnUtil.getConnection();
			ctconn = ConnUtil.getConnection();
			uconn = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			StringBuffer sql = new StringBuffer();
			sql.append("(SELECT * FROM customerdetailquery WHERE (TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 5) AND vipGrade>=1 and vipGrade<=7 ) ")
					.append("  UNION  all")
					.append(" (SELECT * FROM customerdetailquery WHERE (TO_DAYS('" + time + "') - TO_DAYS(lastLoginTime) = 2) AND vipGrade>=8 and vipGrade<=10 )");
			rs = stmt.executeQuery(sql.toString());
			if (rs == null) return;
			String insertsql = "insert into customerquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			ctstmt = ctconn.prepareStatement(insertsql);
			String updatesql = "update customerdetailquery set vipStatus=2 where uid=?";
			utstmt = uconn.prepareStatement(updatesql);
			Set gameset = new HashSet();
			while (rs.next()) {
				String uid = rs.getString("uid");
				ctstmt.setString(1, null);
				ctstmt.setString(2, uid);
				ctstmt.setString(3, rs.getString("account"));
				ctstmt.setInt(4, rs.getInt("vipGrade"));
				ctstmt.setInt(5, 2);
				ctstmt.setLong(6, rs.getLong("gameCount"));
				ctstmt.setLong(7, rs.getLong("payCount"));
				ctstmt.setLong(8, rs.getLong("payTotalAmt"));
				ctstmt.setString(9, rs.getString("lastPayTime"));
				ctstmt.setString(10, rs.getString("lastLoginTime"));
				ctstmt.setLong(11, rs.getLong("callCount"));
				ctstmt.setLong(12, rs.getLong("integral"));
				ctstmt.setString(13, rs.getString("phone"));
				ctstmt.setString(14, rs.getString("contactNumber"));
				ctstmt.setString(15, rs.getString("qq"));
				ctstmt.setString(16, rs.getString("email"));
				ctstmt.setInt(17, 2);
				ctstmt.setString(18, time);
				String jsonStr = getInfoForHttpGetMothed(bigCustomerInterface + "uid=" + uid + "&date=" + time);
				ObjectMapper mapper = new ObjectMapper();
				JsonRecord record = (JsonRecord)mapper.readValue(jsonStr, JsonRecord.class);

				String gameName = "";
				if (gameset != null) gameset.clear();
				List recordList = record.getList();
				for (int i = 0; i < recordList.size(); i++) {
					Record rd = (Record)recordList.get(i);
					gameset.add(URLDecoder.decode(rd.getGameName(), "utf8"));
				}
				for (Iterator iter = gameset.iterator(); iter.hasNext(); ) {
					gameName = gameName + (String)iter.next() + ",";
				}
				if ((gameName != null) && (gameName.indexOf(".") != -1))
					gameName = gameName.substring(0, gameName.lastIndexOf(","));
				ctstmt.setString(19, gameName);
				ctstmt.execute();

				utstmt.setString(1, uid);
				utstmt.execute();
			}
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成流失客户记录", null, starttime, endtime, true);
		} catch (Exception e) {
			e.printStackTrace();
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成流失客户记录", e.getMessage(), starttime, endtime, false);
			try
			{
				if (utstmt != null) {
					utstmt.close();
					utstmt = null;
				}
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (uconn != null) {
					uconn.close();
					uconn = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (utstmt != null) {
					utstmt.close();
					utstmt = null;
				}
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (uconn != null) {
					uconn.close();
					uconn = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void makeBigPayCustomer()
	{
		Connection conn = null;
		Connection ctconn = null;
		Statement stmt = null;
		PreparedStatement ctstmt = null;
		ResultSet rs = null;
		String starttime = TaskLogUtil.getNowTime();
		try {
			conn = ConnUtil.getConnection();
			ctconn = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT * FROM customerdetailquery WHERE lastPayTime = '" + time + "' and lastModifyAmt>=5000");
			rs = stmt.executeQuery(sql.toString());
			if (rs == null) return;
			String insertsql = "insert into customerbigpayquery values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			ctstmt = ctconn.prepareStatement(insertsql);
			Set gameSet = new HashSet();
			String gameId = null;
			String serverIds = "";
			double bigPayAmt = 0.0D;
			while (rs.next()) {
				String uid = rs.getString("uid");

				String jsonStr = getInfoForHttpGetMothed(customerInterface + "uid=" + uid + "&time=" + time + "&amount=5000");
				if (jsonStr != null)
				{
					ObjectMapper mapper = new ObjectMapper();
					BigPayJsonRecord record = (BigPayJsonRecord)mapper.readValue(jsonStr, BigPayJsonRecord.class);
					List<BigPayRecord> recordList = record.getList();
					gameSet.clear();
					bigPayAmt = 0.0D;
					serverIds = "";
					if ((recordList != null) && (recordList.size() != 0))
					{
						for (BigPayRecord detail : recordList) {
							gameSet.add(detail.getGameId());
						}

						for (Iterator iter = gameSet.iterator(); iter.hasNext(); ) {
							String gameid = (String)iter.next();
							for (BigPayRecord detail : recordList) {
								if (gameid.equals(detail.getGameId())) {
									bigPayAmt += detail.getAmount();
									serverIds = serverIds + detail.getServerId() + ",";
									gameId = gameid;
								}
							}
							if (bigPayAmt >= 5000.0D) {
								ctstmt.setString(1, null);
								ctstmt.setString(2, uid);
								ctstmt.setString(3, rs.getString("account"));
								ctstmt.setInt(4, rs.getInt("vipGrade"));
								ctstmt.setInt(5, rs.getInt("vipStatus"));
								ctstmt.setLong(6, rs.getLong("gameCount"));
								ctstmt.setLong(7, rs.getLong("payCount"));
								ctstmt.setLong(8, rs.getLong("payTotalAmt"));
								ctstmt.setString(9, rs.getString("lastPayTime"));
								ctstmt.setString(10, rs.getString("lastLoginTime"));
								ctstmt.setLong(11, rs.getLong("callCount"));
								ctstmt.setLong(12, rs.getLong("integral"));
								ctstmt.setString(13, rs.getString("phone"));
								ctstmt.setLong(14, (long)bigPayAmt);
								ctstmt.setString(15, rs.getString("contactNumber"));
								ctstmt.setString(16, rs.getString("qq"));
								ctstmt.setString(17, rs.getString("email"));
								ctstmt.setString(18, time);
								ctstmt.setString(19, gameId);
								ctstmt.setString(20, serverIds);
								ctstmt.execute();
							}
						}
					}
				}
			}
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成大额充值客户记录", null, starttime, endtime, true);
		} catch (Exception e) {
			e.printStackTrace();
			String endtime = TaskLogUtil.getNowTime();
			TaskLogUtil.addLog("生成大额充值客户记录", e.getMessage(), starttime, endtime, false);
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void updateBigPayCustomer()
	{
		Connection conn = null;
		Connection ctconn = null;
		Statement stmt = null;
		PreparedStatement ctstmt = null;
		ResultSet rs = null;
		try {
			conn = ConnUtil.getConnection();
			ctconn = ConnUtil.getConnection();
			stmt = ConnUtil.getStatement(conn);
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT * FROM customerbigpayquery");
			rs = stmt.executeQuery(sql.toString());
			if (rs == null) return;
			String insertsql = "update customerbigpayquery set bigPayAmt=?,gameId=?,serverIds=? where uid=? and daytime=?";
			ctstmt = ctconn.prepareStatement(insertsql);
			Set gameSet = new HashSet();
			String gameId = null;
			String serverIds = "";
			double bigPayAmt = 0.0D;
			while (rs.next()) {
				String uid = rs.getString("uid");
				String mytime = rs.getString("daytime");

				String jsonStr = getInfoForHttpGetMothed(customerInterface + "uid=" + uid + "&time=" + mytime + "&amount=5000");
				if (jsonStr != null)
				{
					ObjectMapper mapper = new ObjectMapper();
					BigPayJsonRecord record = (BigPayJsonRecord)mapper.readValue(jsonStr, BigPayJsonRecord.class);
					List<BigPayRecord> recordList = record.getList();
					gameSet.clear();
					bigPayAmt = 0.0D;
					serverIds = "";
					if ((recordList != null) && (recordList.size() != 0))
					{
						for (BigPayRecord detail : recordList) {
							gameSet.add(detail.getGameId());
						}

						for (Iterator iter = gameSet.iterator(); iter.hasNext(); ) {
							String gameid = (String)iter.next();
							for (BigPayRecord detail : recordList) {
								if (gameid.equals(detail.getGameId())) {
									bigPayAmt += detail.getAmount();
									serverIds = serverIds + detail.getServerId() + ",";
									gameId = gameid;
								}
							}
							if (bigPayAmt >= 5000.0D) {
								ctstmt.setLong(1, (long)bigPayAmt);
								ctstmt.setString(2, gameId);
								ctstmt.setString(3, serverIds);
								ctstmt.setString(4, uid);
								ctstmt.setString(5, mytime);
								ctstmt.execute();
							}
						}
					}
				}
			} } catch (Exception e) {
			logger.error("更新异常",e);
		}
		finally
		{
			try
			{
				if (ctstmt != null) {
					ctstmt.close();
					ctstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (stmt != null) {
					stmt.close();
					stmt = null;
				}
				if (ctconn != null) {
					ctconn.close();
					ctconn = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static String getInfoForHttpGetMothed(String url)
	{
		try
		{
			logger.info(" Get/URL :" + url);
			HttpGet httpget = new HttpGet(url);
			HttpClient client = new DefaultHttpClient();
			String backStr = "";
			ResponseHandler responseHandler = new BasicResponseHandler();
			return (String)client.execute(httpget, responseHandler);
		}
		catch (Exception e) {
			logger.error("fatal:"+url,e);
		}
		return "";
	}
}