package com.xunlei.niux.manager.web.vo;



import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;
import com.xunlei.niux.manager.web.util.HttpClientUtil;


/**
 * 生成充值客户信息
 * @author lisu
 * 2013-03-02
 */
public class CustomerFileTask {
	private static final Logger logger = Logger.getLogger(CustomerFileTask.class.getName());
	private static String time = null;
	private static String ftime = null;
	private static String BaseUrl = "http://twin13024.sandai.net";
	private static String newUserUrl =  BaseUrl+":8089/scanPlatNewForUser";
	
	static{
		if(time == null){
			 Calendar cal = Calendar.getInstance();
			 cal.add(Calendar.DAY_OF_MONTH, -1);
			 SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			 time = sdf.format(cal.getTime());//当前时间的前一天
			 sdf = new SimpleDateFormat("yyyyMMdd");
			 ftime = sdf.format(cal.getTime());
		}
	}
	
	
	public static void main(String args[]){
	    if(args != null && args.length>=1){
		   time = args[0];
		   ftime = time.replaceAll("-", "");
	    }
		make();	  
	}
	
	/**
	 * 生成文件到文件服务器，更新客户信息，并且生成大客户记录
	 */
	public static void make(){	
		   logger.info("开始删除文件路径....");
		   deleteCustomerPath();
		   logger.info("文件路径删除完毕！");
		   logger.info("开始生成充值客户文件......");	
		   makeFile();
		   logger.info("充值客户文件生成完毕！");	
	}
	
	
	
	/**
	 * 生成充值客户信息文件
	 */
	public static  void makeFile(){		
		String date = ftime;//当前时间的前一天
		String starttime = TaskLogUtil.getNowTime();
		String url = newUserUrl+"?date="+date+"&type=2";
		logger.info("file system url:"+url);
		String message = null;
		int flag = 0;
		 try{
		      String responseString =  HttpClientUtil.getHtml(url);	  
		      logger.info("responseString:"+responseString);
		      if(responseString != null && !"".equals(responseString)){
		    		String str[] = responseString.split("&");
		    		String status = str[0].split("=")[1];
		    		message = str[1].split("=")[1];
		    		flag = Integer.parseInt(status);
		    		if(flag != 1){
		    			throw new Exception(URLDecoder.decode(message,"utf8"));
		    		}
		    	}
		       String endtime = TaskLogUtil.getNowTime();
		       TaskLogUtil.addLog("生成充值客户文件", null, starttime, endtime, true);
		    }catch(Exception e){
		    	logger.info("生成充值客户文件任务执行失败，原因：" + e.getMessage());
		    	String endtime = TaskLogUtil.getNowTime();
				TaskLogUtil.addLog("生成充值客户文件", e.getMessage(), starttime, endtime, false);
		    }finally{
		    	
		    }
	}
	

	
	
	 /**
     * 删除客户路径
     */
	public static void deleteCustomerPath(){	      
		   String date = ftime;//当前时间的前一天
		   Connection ctconn = null;
		   PreparedStatement ctstmt = null;
		   try{
		       ctconn = ConnUtil.getConnection();			  		   
               String insertsql = "delete from bigcustomerquery where daytime='"+date+"'";
               ctstmt = ctconn.prepareStatement(insertsql);	    
               ctstmt.execute();
		   }catch(Exception e){
			   e.printStackTrace();
		   }finally{
			   try{
				   if(ctstmt != null){//关闭连接
					  ctstmt.close();
					  ctstmt = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }				
	}
	
	
	
	
}
