package com.xunlei.niux.manager.web.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SafeContentUtil {

	private static final String regEx = "<[^>]+>"; //定义HTML标签的正则表达式
	
	 /**
     * 去掉html格式
     * @param content
     * @return
     */
    public static  String removeHtml(String content){   	    
        Pattern pattern = Pattern.compile(regEx,Pattern.CASE_INSENSITIVE);    
        Matcher  matcher = pattern.matcher(content);    
        content = matcher.replaceAll(""); //过滤html标签    
    	return content;
    }
    
    public static String checkContent(String content){
		content = content.replaceAll("\n", "");
		content = content.replaceAll("\r","");
		content = content.replaceAll("\t","");
		content = content.replaceAll("&nbsp;", "");
		content = content.trim();
		return content;
    }
}
