package com.xunlei.niux.manager.web.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;

/**
 * Property文件读写工具类
 * @author lisu
 * 2013-04-17
 */
public class PropertyUtil {
	
	public static void main(String args[]){
		writeData("abc","123","test","c:/web-game-key.properties.properties");
		writeData("abc","123456","c:/web-game-key.properties.properties");
		writeData("weiduangame","000079,000080,000083,000085,000086,000090","c:/games.properties");
	}

	
	/**
	 * 如果文件中存在gameid，则替换原文件改行的内容，如果不存在，则追加到最后
	 * @param gameid 游戏编号
	 * @param value 每行的值
	 * @param annotation 注释
	 * @param filePath 文件路径
	 */
	public static void writerString(String gameid,String publicKey,String privateKey,String annotation,String filePath){
		File file = new File(filePath);
		InputStream in = null;
		OutputStream out = null;
		BufferedReader br = null;
		BufferedWriter bw = null;
		boolean status = true;
		try {			
			if (!file.exists()){
				file.createNewFile();
				status = false;			
				out = new BufferedOutputStream(new FileOutputStream(filePath));
				bw = new BufferedWriter(new OutputStreamWriter(out));
				if(annotation != null){
					bw.write(annotation);
					bw.newLine();
				}
				    
				bw.write(publicKey);
				bw.newLine();
				bw.write(privateKey);
				bw.newLine();
				bw.newLine();
			}else{
				in = new BufferedInputStream(new FileInputStream(filePath));
				out = new BufferedOutputStream(new FileOutputStream(status?filePath.replace(".properties", "a.properties"):filePath));
				br = new BufferedReader(new InputStreamReader(in));	
				bw = new BufferedWriter(new OutputStreamWriter(out));
				String readLine = br.readLine();
				boolean flag = false;
				while(readLine != null){
					if(readLine.indexOf(gameid+"_publicKey")>-1 ){//如果已经存在某游戏的配置
						readLine = publicKey;
						flag = true;
					}
					if(readLine.indexOf(gameid+"_privateKey")>-1){
						readLine = privateKey;
						flag = true;
					}
					bw.write(readLine);
					bw.newLine();
					readLine = br.readLine();
				}
				if(!flag){
					if(annotation != null){
						bw.write(annotation);
						bw.newLine();
					}
					    
					bw.write(publicKey);
					bw.newLine();
					bw.write(privateKey);
					bw.newLine();
					bw.newLine();
				}
				
			}
			   
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			try{
				if(bw != null){
					bw.flush();
					bw.close();
					bw = null;
				}
				if(out != null){
					out.close();
					out = null;
				}
				if(br != null){
					br.close();
					br = null;
				}
				if(in != null){
					in.close();
					in = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
			if(status){
				if(file.isFile())
					file.delete();
				file = new File(filePath.replace(".properties", "a.properties"));
				file.renameTo(new File(filePath));//更改文件名称
			}
			
		}
			
	}
	
	/**
	 * 根据Key 读取Value
	 * 
	 * @param key
	 * @return
	 */
	public static String readData(String key,String filePath) {
		Properties props = new Properties();
		InputStream in = null;
		try {
			File file = new File(filePath);
			if (!file.exists())
				file.createNewFile();
			in = new BufferedInputStream(new FileInputStream(filePath));
			props.load(in);
			in.close();
			String value = props.getProperty(key);
			return value;
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try{
				if(in != null){
					in.close();
					in = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return null;
	}

	
	/**
	 * 修改或添加键值对 如果key存在，修改 反之，添加。
	 * 
	 * @param key 键
	 * @param value 值
	 * @param annotation 注释
	 * @param filePath property文件完整路径
	 */
	public static void writeData(String key, String value,String annotation,String filePath) {
		Properties prop = new Properties();
		InputStream fis = null;
		OutputStream fos = null;
		try {
			File file = new File(filePath);
			if (!file.exists())
				file.createNewFile();
			fis = new FileInputStream(file);
			prop.load(fis);
			fis.close();//一定要在修改值之前关闭fis
			fos = new FileOutputStream(filePath);
			prop.setProperty(key, value);
			prop.store(fos, "test");
			fos.flush();
		} catch (IOException e) {
            e.printStackTrace();
		}finally{
			try{
				if(fos != null){
					fos.close();
					fos = null;
				}
				if(fis != null){
					fis.close();
					fis = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	
	
	/**
	 * 修改或添加键值对 如果key存在，修改 反之，添加。
	 * 
	 * @param key 键
	 * @param value 值
	 * @param filePath property文件完整路径
	 * 
	 */
	public static void writeData(String key, String value,String filePath) {
		Properties prop = new Properties();
		InputStream fis = null;
		OutputStream fos = null;
		try {
			File file = new File(filePath);
			if (!file.exists())
				file.createNewFile();
			fis = new FileInputStream(file);
			prop.load(fis);
			fis.close();//一定要在修改值之前关闭fis
			fos = new FileOutputStream(filePath);
			prop.setProperty(key, value);
			prop.store(fos, "key manager");
			fos.flush();
		} catch (IOException e) {
            e.printStackTrace();
		}finally{
			try{
				if(fos != null){
					fos.close();
					fos = null;
				}
				if(fis != null){
					fis.close();
					fis = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
}
