package com.xunlei.niux.manager.web.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;


import freemarker.template.Configuration;
import freemarker.template.Template;

public class FreemarkerUtil {
	private static final Logger logger = Logger.getLogger(FreemarkerUtil.class.getName());
	/**
	 * 模板生成html页面
	 * @param templateFilePathAndName 模板路径和名字
	 * @param propMap 模板属性
	 * @param htmlFilePath html路径
	 * @param htmlFileName html文件名
	 * @return
	 */
	public static void buildHtml(String tempPath,String templateFileName,Map<String,Object> propMap,String htmlFilePath,String htmlFileName){
		Writer out=null;
		try{
			Configuration configuration=new Configuration();
			configuration.setEncoding(Locale.getDefault(), "UTF-8");
			configuration.setDirectoryForTemplateLoading(new File(tempPath));
			logger.info(templateFileName);
			Properties p=new Properties();
			p.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("freemarker.properties"));
			configuration.setSettings(p);
			Template template=configuration.getTemplate(templateFileName);
			template.setEncoding("UTF-8"); 
			File file=FileUtil.createFile(htmlFilePath, htmlFileName);
			out=new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file),"UTF-8"));
			template.process(propMap, out);
		}catch(Exception e){
			logger.error(e);
			throw new RuntimeException(e);
		}finally{
			FileUtil.close(out);
		}
	}
}
