package com.xunlei.niux.manager.web.util;
import java.util.List;

import javax.mail.internet.MimeMessage;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailSender {
	private static JavaMailSender sender;

	static{
		init();
	}
	
	private static void init() {
		if(sender == null){
			ApplicationContext ctx = new ClassPathXmlApplicationContext("applicationContext_mail.xml");
			sender = (JavaMailSender) ctx.getBean("mailSender"); 
		}		
	}
	public static void sendMail(String[] toMails,String subject,String content) throws Exception{
		JavaMailSenderImpl senderImpl = new JavaMailSenderImpl();  
		MimeMessage mailMessage = senderImpl.createMimeMessage();  
		MimeMessageHelper messageHelper = new MimeMessageHelper(mailMessage,true,"utf-8");			
		messageHelper.setTo(toMails);		
		messageHelper.setFrom("xlniux@xunlei.com");
		messageHelper.setSubject(subject);//主题  
		messageHelper.setText(content,true);  
		sender.send(mailMessage); 	
	}
	
	public static void sendMail(String subject,String content,String ... toMails) throws Exception{
		JavaMailSenderImpl senderImpl = new JavaMailSenderImpl();  
		MimeMessage mailMessage = senderImpl.createMimeMessage();  
		MimeMessageHelper messageHelper = new MimeMessageHelper(mailMessage,true,"utf-8");			
		messageHelper.setTo(toMails);		
		messageHelper.setFrom("xlniux@xunlei.com");
		messageHelper.setSubject(subject);//主题  
		messageHelper.setText(content,true);  
		sender.send(mailMessage); 	
	}
	
	public static void sendMail(List<String> toMails,String subject,String content) throws Exception{
		if(toMails == null||toMails.size()==0)return;
		String mails []  = new String[toMails.size()];
		int i = 0;
		for(String mail:toMails){
			mails[i] = mail;
			i++;
		}
		sendMail(mails,subject,content);
	}

	public static void main(String args[]){
		try {
			sendMail("lisu@xunlei.com","test","test");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
