package com.xunlei.niux.manager.web.task.product;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ThreadExecutor {
	   private static final Logger logger = Logger.getLogger("releaseproductlog");
       private static final ThreadExecutor instance = new ThreadExecutor();
       private ThreadPoolExecutor exceutor ; 
       
       private ThreadExecutor(){
    	   exceutor = new ThreadPoolExecutor(10,20,10,
            		 TimeUnit.SECONDS,
            		 new ArrayBlockingQueue<Runnable>(1000),
            		 new ThreadPoolExecutor.AbortPolicy());
    	   Runtime.getRuntime().addShutdownHook(new Thread(){
    		   public void run(){
    			   shutdown();
    			   logger.info("退出时回收线程池资源：ThreadExecutor.destroy()");
    		   }
    	   });
       }
       
       public static ThreadExecutor getInstance(){
    	   return instance;
       }

       public  void execute(Runnable task){
    	    exceutor.execute(task);
       }
       
       public void shutdown(){
    	   exceutor.shutdown();
       }
}
