package com.xunlei.niux.manager.web.task.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.json.JSONObject;

import com.xunlei.niux.manager.web.task.AbstractBaseTask;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.SignUtil;
import com.xunlei.niux.manager.web.vo.ConnUtil;
import com.xunlei.util.StringTools;


/**
 * 发放奖品定时任务
 * 每隔半小时检查一次，补发超过半小时没有补发成功的奖品
 * 对积分商城中扣了积分，但是没有发放奖品的用户，重新发放奖品。
 * @author lisu
 *  2015-02-04
 */
public class ReleaseProductTask extends AbstractBaseTask {

      public static void main(String[] args) {
    	  releaseProduct();
      }
      
    private static final String ACTURL = "http://act.niu.xunlei.com/commonactivity/getGift_v2.do?";
  	private static final Logger logger = Logger.getLogger(ReleaseProductTask.class.getName());
  	private static final String ACTNO = "jifenmarket";
  	private static final String PRODUCTKEY = "mpobwhb9fkar6t7";
  		
  	
  	public static void release(ExchangeProductDTO product,PreparedStatement pstmt){	
  		Map<String,String> params = new HashMap<String,String>();
  		params.put("actno", ACTNO);
  		params.put("giftid", product.getGiftid());
  		params.put("userid", product.getUserId());
  		String sign = SignUtil.sign(params, PRODUCTKEY);
  		StringBuilder url = new StringBuilder(ACTURL)
  		.append("actno=").append(ACTNO).append("&giftid=").append(product.getGiftid())
  		.append("&userid=").append(product.getUserId())
  		.append("&sign=").append(sign);
  		try{
  			String responseText = HttpClientUtil.getInfoForHttpGetMothed(url.toString());
  			if(StringTools.isEmpty(responseText))return;
  			JSONObject data = new JSONObject(responseText);
  			int code = data.getInt("rtn");
  			if(code == 0){
  				updateBonusProductRecordStatus(product.getSeqId(),pstmt);
  				logger.info("release product success params:"+params);
  			}else{
  				logger.info("release product fail params:"+params+",code:"+code);
  			}
  		}catch(Exception e){
  			logger.error("release product error params:"+params+",reason:"+e.getMessage(),e);
  		}
  		
  	}
  	
  	public static void updateBonusProductRecordStatus(long seqId,PreparedStatement pstmt) throws SQLException{
  			pstmt.setLong(1, seqId);
			pstmt.execute();
  	}
  	
      
      private static void releaseProduct(){
    	  Connection conn = null;
    	  Connection uconn = null;
    	  Statement stmt = null;
    	  PreparedStatement pstmt = null;
    	  ResultSet rs = null;
    	  try{
    		  conn = ConnUtil.getConn();
    		  uconn = ConnUtil.getConn();
    		  stmt = conn.createStatement();
    		  String updateSql = "update bonusproductchargerecord set chargeFlag=3 where seqId=?";
    		  pstmt = uconn.prepareStatement(updateSql);
    		  String sql = "select * from bonusproductchargerecord where chargeFlag=2 and recordTime<now()";
    		  rs = stmt.executeQuery(sql);
    		  while(rs.next()){
    			  ExchangeProductDTO product = new ExchangeProductDTO() ;
    			  product.setSeqId(rs.getLong("seqId"));
    			  product.setGiftid(rs.getString("productId"));
    			  product.setUserId(rs.getString("userId"));
    			  release(product,pstmt);       		
    		  }   		 
    	  }catch(Exception e){
    		  e.printStackTrace();
    	  }finally{
    		  try{
    			  if(pstmt != null){
    				  pstmt.close();
    				  pstmt = null;
    			  }
    			  if(uconn != null){
    				  uconn.close();
    				  uconn = null;
    			  }
    			  if(rs != null){
    				  rs.close();
    				  rs = null;
    			  }
    			  if(stmt != null){
    				  stmt.close();
    				  stmt = null;
    			  }
    			  if(conn != null){
    				  conn.close();
    				  conn = null;
    			  }
    		  }catch(Exception e){
    			  e.printStackTrace();
    		  }
    	  }
      }
}
