package com.xunlei.niux.manager.web.task.product;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import com.xunlei.common.util.StringTools;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.manager.web.proxy.JRedisProxy;
import com.xunlei.niux.manager.web.task.AbstractBaseTask;
import com.xunlei.niux.manager.web.util.AccountUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.vo.ConnUtil;


public class BonusProductTask extends AbstractBaseTask{
	private static final String QUERY_JINZUAN_URL = "http://jinzuan.niu.xunlei.com:9090/member/getmemberinfo.do?uid=";
	//private static final String QUERY_JINZUAN_URL = "http://10.10.10.202:9090/member/getmemberinfo.do?uid=";
	private static final Logger logger = Logger.getLogger(BonusProductTask.class.getName());

	public static void main(String[] args) {
		logger.info("BonusProductTask start .........");
		logger.info("getAllProduct start .........");
		List<ExchangeProductDTO> allProductList = getAllProduct();
		logger.info("getBonusProductRecord start .........");
		getBonusProductRecord(allProductList);
		logger.info("getBonusProductRank start .........");
		getBonusProductRank(allProductList);
		logger.info("clear start");
		clear(allProductList);
		logger.info("BonusProductTask end!");
	}
	
	private static void clear(List<ExchangeProductDTO> allProductList){
		if(allProductList != null){
			allProductList.clear();
			allProductList = null;
		}
	}

	private static List<ExchangeProductDTO> getAllProduct(){
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		List<ExchangeProductDTO> list = new ArrayList<ExchangeProductDTO>();
		try{
			conn = ConnUtil.getConn();
			stmt = conn.createStatement();
			String sql = "SELECT * FROM bonusproductcharge s1 INNER JOIN gift s2 ON s1.productId = s2.giftId";
			rs = stmt.executeQuery(sql);			
			while(rs.next()){
				String giftName = rs.getString("giftName");
				String giftid = rs.getString("productId");
				String giftPic = rs.getString("giftPic");
				ExchangeProductDTO dto = new ExchangeProductDTO();
				dto.setGiftid(giftid);
				dto.setGiftName(giftName);
				dto.setGiftImgUrl(giftPic);
				list.add(dto);;
			}			
		}catch(Exception e){
			e.printStackTrace();
			logger.info("getAllProduct exception", e);
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return list;
	}
	
	private static ExchangeProductDTO findProductDTO(List<ExchangeProductDTO> allProductList,String giftid){
		for(ExchangeProductDTO dto:allProductList){
			if(dto.getGiftid().equals(giftid))return dto;
		}
		return null;
	}
	
	private static int getJinZuanStatus(String userId){
		String responseText = HttpClientUtil.getInfoForHttpGetMothed(QUERY_JINZUAN_URL+userId);
		try {
			System.out.println("");
			System.out.println("==============responseText"+responseText);
			JSONObject json = new JSONObject(responseText);			
			int rtn = json.getInt("rtn");
			System.out.println("=============rtn:"+rtn);
			if(rtn==0){
				JSONObject   data = json.getJSONObject("data");
				String memberExpireDate = data.getString("memberExpireDate");
				System.out.println("memberExpireDate:"+memberExpireDate);
				if(StringTools.isNotEmpty(memberExpireDate)){
					String nowDay = nowDay();
					String time = " 00:00:00";
					if(compareTime(memberExpireDate+time,nowDay+time)){
						return 1;
					}
				}
			}
		} catch (JSONException e) {
			return 0;
		}
		return 0;
	}
	
	/**
	 * 获取兑换动态
	 * @param allProductList
	 */
	private static void getBonusProductRecord(List<ExchangeProductDTO> allProductList){
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try{
			conn = ConnUtil.getConn();
			stmt = conn.createStatement();
			String sql = "select * from bonusproductchargerecord where chargeFlag=3 order by recordTime desc limit 20";
			rs = stmt.executeQuery(sql);
			List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
			while(rs.next()){
				String userId = rs.getString("userId");
				String giftid = rs.getString("productId");
				long bonus = rs.getLong("bonus");
				//String giftImgUrl  = rs.getString("giftImgUrl"); 
				Map<String,Object> map = new HashMap<String,Object>();
				map.put("userId", userId);
				String userName = AccountUtil.getAccount(userId);
				map.put("userName", StringTools.isEmpty(userName)?"真命天子":userName);
				map.put("giftid", giftid);
				map.put("bonus", bonus);
				ExchangeProductDTO dto = findProductDTO(allProductList,giftid);
				if(dto == null)continue;
				map.put("giftImgUrl", dto.getGiftImgUrl());
				map.put("giftName", dto.getGiftName());
				map.put("isJinZuan", getJinZuanStatus(userId));
				list.add(map);
			}
			String json = JsonObjectUtil.getDataJsonObject(list);
			System.out.println("json:"+json);
			JRedisProxy.getInstance().set("productChargeList",json, 2592000);//记录最多保留1个月
		}catch(Exception e){
			e.printStackTrace();
			logger.info("getBonusProductRecord exception", e);
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	

	/**
	 * 获取排行榜
	 * @param allProductList
	 */
	private static void getBonusProductRank(List<ExchangeProductDTO> allProductList){
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try{
			conn = ConnUtil.getConn();
			stmt = conn.createStatement();
			String sql = "SELECT * FROM bonusproductcharge ORDER BY exchangeCount DESC LIMIT 5;";
			rs = stmt.executeQuery(sql);
			List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
			while(rs.next()){
				String giftid = rs.getString("productId");
				long bonus = rs.getLong("bonus");
				Map<String,Object> map = new HashMap<String,Object>();
				map.put("giftid", giftid);
				map.put("bonus", bonus);
				ExchangeProductDTO dto = findProductDTO(allProductList,giftid);
				if(dto == null)continue;
				map.put("giftImgUrl", dto.getGiftImgUrl());
				map.put("giftName", dto.getGiftName());
				list.add(map);
			}
			String json = JsonObjectUtil.getDataJsonObject(list);
			System.out.println("json:"+json);
			JRedisProxy.getInstance().set("productGiftRank",json, 2592000);//记录最多保留1个月
		}catch(Exception e){
			e.printStackTrace();
			logger.info("getBonusProductRecord exception", e);
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
}
