package com.xunlei.niux.manager.web.task.peoplecount;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import com.xunlei.niux.manager.web.proxy.JRedisProxy;
import com.xunlei.util.StringTools;

public class GamePeopleCountTask {
	private static  final String  driver = "com.mysql.jdbc.Driver";
	private static final String acturl = "jdbc:mysql://10.1.2.83:3306/niux_new_activity?characterEncoding=utf8";
	private static final String actuser = "yeyouser";
	private static final String actpwd= "t14283";
	
	private static final Logger logger = Logger.getLogger(GamePeopleCountTask.class.getName());
	private static StringBuffer sb = new StringBuffer("SELECT act.actNo sactNo FROM activity_activity AS act")
	.append(" JOIN activity_photo AS photo ON act.actNo = photo.actNo ")
	.append(" WHERE photo.actLocation = 'officalIndex' ")
	.append(" ORDER BY photo.displayOrder ASC")
	.append(" LIMIT 12");
	
	
	public static Connection getActConn(){
		Connection conn = null;
		try {
			Class.forName(driver);
			conn = DriverManager.getConnection(acturl, actuser, actpwd);
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			e.printStackTrace();
		} 
		return conn;
	}

	public static void main(String[] args) {
		logger.info("PeopleCountTask start .........");
		updatePeopleCount();
		logger.info("PeopleCountTask end!");
	}

	
	private static void updatePeopleCount(){
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try{
			conn = getActConn();
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sb.toString());
			while(rs.next()){
				String actno = rs.getString("sactNo");
				String count = JRedisProxy.getInstance().get(actno);
				long total = 0;
				if(StringTools.isEmpty(count)){
					total = getBaseData();
				}else{
					total = Long.parseLong(count)+getGrowData();
				}
				JRedisProxy.getInstance().set(actno, total+"", 2592000);//记录最多保留1个月
			}
		}catch(Exception e){
			e.printStackTrace();
			logger.info("PeopleCountTask exception", e);
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	private static long getGrowData(){
		return Math.round(Math.random()*40)+60;
	}
	

	/**
	 * 获得从2000-10000直接的随机数
	 * @return
	 */
	private static long getBaseData(){
		return Math.round(Math.random()*8000)+2000;
	}
}
