package com.xunlei.niux.manager.web.task.guest;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.vo.ConnUtil;

public class GuestTask {
	 private static final Logger logger = Logger.getLogger(GuestTask.class.getName());
	 private static SimpleDateFormat daysdf = new SimpleDateFormat("yyyy-MM-dd");	    
	 private static  String wholePeopleGuestPath = "/usr/local/templatedata/formal/niuofficial/gamedata";
	 private static  String SYNCPICCOMMOND = "rsync_niuofficial_formal.sh";//rsync_niuofficial_formal.sh
	 
	 public static void main(String args[]){
		 System.out.println("=========GuestTask  Start ==========");
		 makeFile();
		 System.out.println("=========GuestTask  End ==========");
	 }
	 
	 public static void makeFile() {
		   Connection conn = null;
		   Statement stmt = null;
		   ResultSet rs = null;
			try{
				conn = ConnUtil.getConn();
				String sql = "select * from wholepeopleguest order by dayTime desc,showId desc";
				stmt = conn.createStatement();
				rs = stmt.executeQuery(sql);
				Calendar cal = Calendar.getInstance();			
				String nowDay = daysdf.format(cal.getTime());
				List<WholePeopleGuest> emList  = new ArrayList<WholePeopleGuest>();
				while(rs.next()){
					WholePeopleGuest wpg = new WholePeopleGuest();
					wpg.setSeqId(rs.getLong("seqId"));
					wpg.setShowId(rs.getInt("showId"));
					wpg.setHomeNo(rs.getString("homeNo"));
					wpg.setHomeTeam(rs.getString("homeTeam"));
					wpg.setCustomerNo(rs.getString("customerNo"));
					wpg.setCustomerTeam(rs.getString("customerTeam"));
					wpg.setScore(rs.getInt("score"));
					wpg.setDayTime(rs.getString("dayTime"));
					emList.add(wpg);
				}
				System.out.println("emList.size:"+emList.size());
				Map<String,Object> map=new HashMap<String,Object>();
				List<WholePeopleGuest> nowList = new ArrayList<WholePeopleGuest>();
				for(WholePeopleGuest wpg:emList){
					if(wpg.getDayTime().equals(nowDay)){
						nowList.add(wpg);
					}
				}
				List<WholePeopleGuest> beforeList = new ArrayList<WholePeopleGuest>();
				for(WholePeopleGuest wpg:emList){
					if(!wpg.getDayTime().equals(nowDay)){
						beforeList.add(wpg);
					}
				}
				 map.put("beforeList", beforeList);
				 map.put("nowList", nowList);
				 String jsonStr=JsonObjectUtil.getDataJsonObject(map);
				 File file = FileUtil.createFile(wholePeopleGuestPath,"shijibei.json");
				 FileUtil.writeByChar(file, jsonStr);
				 
				 if(nowList != null){
					 nowList.clear();
					 nowList = null;
				 }
				 if(beforeList != null){
					 beforeList.clear();
					 beforeList = null;
				 }
				 if(emList != null){
					 emList.clear();
					 emList = null;
				 }
				 //同步文件到外网
				 sync();
			}catch(Exception e){
				e.printStackTrace();			
			}finally{
				try{
					if(rs != null){
						rs.close();
						rs = null;
					}
					if(stmt != null){
						stmt.close();
						stmt = null;
					}
					if(conn != null){
						conn.close();
						conn = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
				
			}
		}
	 
	 public static File createFile(String dirPath,String fileName){
			dirPath=dirPath==null?"":dirPath.replaceAll("\\\\", "/");
			File dir=new File(dirPath);
			if((!dir.exists())&&(!dir.isDirectory())){
				dir.mkdirs();
			}
			String filepath=dirPath.endsWith("/")?dirPath+fileName:dirPath+"/"+fileName;
			System.out.println(filepath);
			return new File(filepath);
		}
	
	 public static void sync(){
		 try {
			 logger.info("开始同步全民竞猜文件,地址:/usr/local/bin/"+SYNCPICCOMMOND);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMOND);			
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	 }
}
