package com.xunlei.niux.manager.web.task.dts;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import com.xunlei.niux.manager.web.vo.ConnUtil;

public class ResourceCache {
	  private static final String LINKLOCID = "290";//后台配置
	  private static Map<String,ResourceData> resourceMap = new ConcurrentHashMap<String,ResourceData>();
	  
	  static{
		  if(resourceMap.size()==0){
			  init();
		  }
	  }
	  
	  private static final ResourceCache instance = new ResourceCache();
	  private ResourceCache(){
		  
	  }
	  
	  public static ResourceCache getInstance(){
		  return instance;
	  }
	  
	 private static String getGameName(String gameId){
		   Connection conn = null;
		   Statement stmt = null;
		   ResultSet rs = null;
		   try{
			   conn = ConnUtil.getConn();
			   stmt = ConnUtil.getStatement(conn);		
			   String sql = "select * from games where gameid='"+gameId+"'";
			   rs = stmt.executeQuery(sql);			
			   if(rs.next()){
				   return rs.getString("gameName");
			   }
		   }catch(Exception e){

		   }finally{
			   try{
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
		   return null;
	 }
	  
	  private static void  init (){
		   Connection conn = null;
		   Statement stmt = null;
		   ResultSet rs = null;
		   try{
			   conn = ConnUtil.getConn();
			   stmt = ConnUtil.getStatement(conn);		
			   String sql = "select * from linkinfo where linklocid='"+LINKLOCID+"'";
			   rs = stmt.executeQuery(sql);			
			   while(rs.next()){
				   String gameId = rs.getString("gameId");
				   String peopelCount = rs.getString("ext1");
				   String onlinePeopleNumUrl = rs.getString("ext2");
				   String onlinePeopleNumKey = rs.getString("ext3");
				   String percent = rs.getString("ext4");
				   String changePercent = rs.getString("ext5");
				   ResourceData data = new ResourceData();
				   data.setGameId(gameId);
				   data.setGameName(getGameName(gameId));
				   data.setOnlinePeopleNumKey(onlinePeopleNumKey);
				   data.setOnlinePeopleNumUrl(onlinePeopleNumUrl);
				   data.setPercent(Double.parseDouble(percent));
				   data.setChangePercent(Double.parseDouble(changePercent));
				   data.setOnlinePeopleNum(Long.parseLong(peopelCount));
				   resourceMap.put(gameId, data);
			   }
		   }catch(Exception e){

		   }finally{
			   try{
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
	}
	  
	  public ResourceData getResourceData(String gameId){
		  return resourceMap.get(gameId);
	  }
	  
	  public Map<String,ResourceData> getResource(){
		 
		  return resourceMap;
	  }
	  
	  public Set<Entry<String, ResourceData>> getResourceSet(){
		  return  resourceMap.entrySet();
	  }
}
