package com.xunlei.niux.manager.web.task.dts;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import com.xunlei.niux.manager.web.vo.ConnUtil;

public class BuilderThread implements Runnable{
	
	private static final String TEMPLDATEID = "000027";
	private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private String gameId;
	
	public BuilderThread(String gameId){
		this.gameId = gameId;
	}

	@Override
	public void run() {
		builder();
	}

	private void builder(){
		   Connection conn = null;
		   PreparedStatement stmt = null;
		   ResultSet rs = null;
		   try{
			   conn = ConnUtil.getConn();
			   String nowtime = SDF.format(new Date());
			   String sql = "insert into templateschema(templateid,schematime,isexecuted,inputby,inputtime,ext1) values(?,?,?,?,?,?)";
			   stmt =  conn.prepareStatement(sql);	
			   stmt.setString(1,TEMPLDATEID);
			   stmt.setString(2,nowtime);
			   stmt.setInt(3, 0);
			   stmt.setString(4, "系统");
			   stmt.setString(5, nowtime);
			   stmt.setString(6, gameId);
			   stmt.execute();
		   }catch(Exception e){
			   e.printStackTrace();
		   }finally{
			   try{
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(stmt != null){
					   stmt.close();
					   stmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
	}
}
