package com.xunlei.niux.manager.web.task.data;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.vo.ConnUtil;

public class InsertDataTask {
	 private static final Logger logger = Logger.getLogger(InsertDataTask.class.getName());
	 private static SimpleDateFormat daysdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");	    
	 
	 public static void main(String args[]){
		 System.out.println("=========InsertDataTask  Start ==========");
		 makeFile();
		 System.out.println("=========InsertDataTask  End ==========");
	 }
	 
	 public static void makeFile() {
		   Connection conn = null;
		   Connection inconn = null;
		   Statement stmt = null;
		   PreparedStatement psmt = null;
		   ResultSet rs = null;
			try{
				conn = ConnUtil.getConn();
				inconn = ConnUtil.getConn();
				String sql = "SELECT * FROM linkinfo WHERE linklocid='1276' and gameidbytuijian not in (select gameidbytuijian from linkinfo WHERE linklocid='1601')";
				String insertsql = "INSERT INTO linkinfo(linklocid,linkurl,validatetime,displayorder,ext1,ext2,inputby,inputtime,gameidbytuijian,linklocgroupid,displaysort) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
				stmt = conn.createStatement();
				rs = stmt.executeQuery(sql);
				Calendar cal = Calendar.getInstance();		
				psmt = inconn.prepareStatement(insertsql);
				String nowDay = daysdf.format(cal.getTime());
				while(rs.next()){
					psmt.setString(1, "1601");
					psmt.setString(2, rs.getString("linkurl"));
					psmt.setString(3,nowDay);
					psmt.setString(4,rs.getString("displayorder"));
					psmt.setString(5, rs.getString("ext4"));
					psmt.setString(6, rs.getString("ext2"));
					psmt.setString(7, "lisu");
					psmt.setString(8, nowDay);
					psmt.setString(9, rs.getString("gameidbytuijian"));
					psmt.setString(10, "llg_1601");
					psmt.setString(11, rs.getString("displaysort"));
					psmt.execute();
				}
			}catch(Exception e){
				e.printStackTrace();			
			}finally{
				try{
					if(rs != null){
						rs.close();
						rs = null;
					}
					if(stmt != null){
						stmt.close();
						stmt = null;
					}
					if(conn != null){
						conn.close();
						conn = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
				
			}
		}

}
