package com.xunlei.niux.manager.web.task.customer;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.manager.web.vo.ConnUtil;


/**
 * 大客户系统定时任务
 * @author lisu
 *  2014-02-14
 */
public class UpdateAllGameCountTask {
	
	   private static final Logger logger = Logger.getLogger(UpdateAllGameCountTask.class.getName());
       private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
       private static String daytime;//指定日期
       private static String beforetime;//当前日期前一天
       
       static{
    	   if(daytime==null){
			  Calendar cal = Calendar.getInstance();
			  cal.add(Calendar.DAY_OF_MONTH, -1);
			  beforetime = format.format(cal.getTime());//当前时间的前一天
			  daytime = beforetime ;//默认指定日期为当前时间的前一天
    		   daytime = daytime.split(" ")[0];
    	   }    	   
       }
       
       
       public static void main(String args[]){
    	   if(args != null&&args.length>0){
    		   daytime = args[0];
    	   }
    	   makeCustomerReport();//开始跑数据           
       }
       
       private static void addLog(String message){
    	   logger.info("nowtime:"+format.format(new Date())+",daytime:"+daytime+","+message);
       }
       
     
       
       /**
        *  生成销售报表
        */
       private static void makeCustomerReport(){
    	  addLog("updateAllGameCount start ...");
    	  vipGradeCount();
    	  addLog("updatePercent start ...");
       }
      
       
       private static void updateAllGameCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT  SUM(peopleCount) ,SUM(contactCount),SUM(saleCount),SUM(rebateCount),SUM(addCount),SUM(addContactCount),SUM(addSaleCount),SUM(addRebateCount)  FROM customerreport WHERE daytime='"+daytime+"'";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String insertsql = "insert into customerreport values(null,?,'101',?,?,'0',?,'0',?,'0',?,?,?,?,?)";
    			pstmt = sconn.prepareStatement(insertsql);
    			while(rs.next()){
    				long peopleCount = rs.getLong(1);
    				long contactCount = rs.getLong(2);
    				long saleCount = rs.getLong(3);
    				long rebateCount = rs.getLong(4);
    				long addCount = rs.getLong(5);
    				long addContactCount = rs.getLong(6);
    				long addSaleCount = rs.getLong(7);
    				long addRebateCount = rs.getLong(8);
    				pstmt.setString(1, "00");
    				pstmt.setLong(2, peopleCount);
    				pstmt.setLong(3, contactCount);
    				pstmt.setLong(4, saleCount);
    				pstmt.setLong(5, rebateCount);
    				pstmt.setLong(6, addCount);
    				pstmt.setLong(7, addContactCount);
    				pstmt.setLong(8, addSaleCount);
    				pstmt.setLong(9, addRebateCount);
    				pstmt.setString(10, daytime);
    				pstmt.execute();
    				addLog("daytime:"+daytime+",updateAllGameCount insertsql:"+insertsql);
    			}    	
    			
    		    String updatesql = "UPDATE customerreport SET contactPercent=IFNULL(100*contactCount/peopleCount,0),salePercent=IFNULL(100*saleCount/contactCount,0),rebatePercent=IFNULL(100*rebateCount/saleCount,0)  WHERE vipgrade=101 and daytime='"+daytime+"'";
			    pstmt = sconn.prepareStatement(updatesql);
			    pstmt.execute();
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	       	   
       }
       
       
       private static void vipGradeCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT  vipGrade,SUM(peopleCount) ,SUM(contactCount),SUM(saleCount),SUM(rebateCount),SUM(addCount),SUM(addContactCount),SUM(addSaleCount),SUM(addRebateCount)  FROM customerreport WHERE daytime='"+daytime+"' and vipGrade<=10  group by vipGrade";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String insertsql = "insert into customerreport values(null,?,?,?,?,'0',?,'0',?,'0',?,?,?,?,?)";
    			pstmt = sconn.prepareStatement(insertsql);
    			while(rs.next()){
    				int vipgrade = rs.getInt(1);
    				long peopleCount = rs.getLong(2);
    				long contactCount = rs.getLong(3);
    				long saleCount = rs.getLong(4);
    				long rebateCount = rs.getLong(5);
    				long addCount = rs.getLong(6);
    				long addContactCount = rs.getLong(7);
    				long addSaleCount = rs.getLong(8);
    				long addRebateCount = rs.getLong(9);
    				pstmt.setString(1, "00");
    				pstmt.setInt(2, vipgrade);
    				pstmt.setLong(3, peopleCount);
    				pstmt.setLong(4, contactCount);
    				pstmt.setLong(5, saleCount);
    				pstmt.setLong(6, rebateCount);
    				pstmt.setLong(7, addCount);
    				pstmt.setLong(8, addContactCount);
    				pstmt.setLong(9, addSaleCount);
    				pstmt.setLong(10, addRebateCount);
    				pstmt.setString(11, daytime);
    				pstmt.execute();
    				addLog("daytime:"+daytime+",vipGradeCount insertsql:"+insertsql);
    			}    	
    			
    		    String updatesql = "UPDATE customerreport SET contactPercent=IFNULL(100*contactCount/peopleCount,0),salePercent=IFNULL(100*saleCount/contactCount,0),rebatePercent=IFNULL(100*rebateCount/saleCount,0)  WHERE vipgrade=101 and daytime='"+daytime+"'";
			    pstmt = sconn.prepareStatement(updatesql);
			    pstmt.execute();
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	       	   
       }
   
}
