package com.xunlei.niux.manager.web.task.customer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.apache.log4j.Logger;

import com.xunlei.common.util.StringTools;
import com.xunlei.niux.manager.web.vo.ConnUtil;


/**
 * 大客户系统定时任务
 * @author lisu
 *  2014-02-14
 */
public class CustomerTask {
	
	   private static final Logger logger = Logger.getLogger(CustomerTask.class.getName());
       private static final String BASEURL = "/data/bigUser/";//文件基础路径
       private static final String SYNCHFILENAME = "rsync_customer_file.sh";//同步登录文件的脚本名称
       private static final SimpleDateFormat yyyymmdd = new SimpleDateFormat("yyyyMMdd");
       private static final SimpleDateFormat yyyy_mm_dd = new SimpleDateFormat("yyyy-MM-dd");
       private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
 	   private static List<Integer> vipGradeList = new ArrayList<Integer>();
	   private static List<Long> amountFromList = new ArrayList<Long>();
	   private static List<Long> amountToList = new ArrayList<Long>();
       private static String daytime;//指定日期
       private static String beforetime;//当前日期前一天
       
       static{
    	   if(daytime==null){
			  Calendar cal = Calendar.getInstance();
			  cal.add(Calendar.DAY_OF_MONTH, -1);
			  beforetime = format.format(cal.getTime());//当前时间的前一天
			  daytime = beforetime ;//默认指定日期为当前时间的前一天
    		   daytime = daytime.split(" ")[0];
    	   }    	   
       }
       
       
       public static void main(String args[]){
    	   if(args != null&&args.length>0){
    		   daytime = args[0];
    	   }
    	   make();//开始跑数据           
       }
       
       private static void addLog(String message){
    	   logger.info("nowtime:"+format.format(new Date())+",daytime:"+daytime+","+message);
       }
       
       private static void make(){
    	   makeCustomerData();  
       }
       
       /**
        * 生成大客户数据
        */
       private static void makeCustomerData(){
    	   addLog("updateCustomerLostStatus start...");
    	   updateCustomerLostStatus();//更新大客户的流失状态
    	   addLog("resetCustomerStatus start...");
    	   resetCustomerStatus();//重置大客户的其他状态
    	   addLog("parseLoginFile start...");
    	   parseLoginFile();//生成登录数据，包含回流状态
    	   addLog("updateCustomerAddStatus start...");
    	   updateCustomerAddStatus();//更新大客户新增、晋级状态
    	   addLog("loadCustomerGrade start...");
    	   loadCustomerGrade();//加载vip等级的相关信息
    	   addLog("makePayData start...");
    	   makePayData();//生成支付数据
    	   addLog("makeCustomerData end...");
       }
       
       /**
        * 加载vip等级的相关信息
        */
      private static void loadCustomerGrade(){
    	  Connection conn = null;
    	  PreparedStatement pstmt = null;
    	  ResultSet rs = null;
    	  try{
    		conn = ConnUtil.getConn();    
  			String sql = "select * from customergrade ORDER BY vipGrade ASC ";
  			pstmt = conn.prepareStatement(sql);
  			rs = pstmt.executeQuery();
  			while(rs.next()){
  				amountFromList.add(rs.getLong("amountFrom"));
  				amountToList.add(rs.getLong("amountTo"));
              	vipGradeList.add(rs.getInt("vipGrade"));
  			} 			
    	  }catch(Exception e){
    		  e.printStackTrace();
    	  }finally{
    		 try{
    			 if(rs != null){
    				 rs.close();
    				 rs  = null;
    			 }
    			 if(pstmt != null){
    				 pstmt.close();
    				 pstmt = null;
    			 }
    			 if(conn != null){
    				 conn.close();
    				 conn = null;
    			 }
    		 }catch(Exception e){
    			 e.printStackTrace();
    		 }
    	  }    	  
      }
       
     /**
      * 更新大客户新增、晋级状态 和 晋级前的vip等级 
      */
    private static void updateCustomerAddStatus(){
    	   Connection ctconn = null;
 		   PreparedStatement ctstmt = null;
 		   try{
 		       ctconn = ConnUtil.getConn();			  		   
 		       StringBuffer sql = new StringBuffer();
 				  sql.append("update customerdetailquery s1 inner join (select * from customerchangeinfo where daytime='"+daytime+"') s2 ")
 				  .append(" on s1.uid = s2.uid ")
                  .append(" set s1.isnew = s2.isnew,s1.ispromote=s2.ispromote,s1.bvipgrade=s2.bvipgrade ");				   
               ctstmt = ctconn.prepareStatement(sql.toString());	 
               addLog("updateCustomerAddStatussql:"+sql);
               ctstmt.execute();
 		   }catch(Exception e){
 			   e.printStackTrace();
 		   }finally{
 			   try{
 				   if(ctstmt != null){//关闭连接
 					  ctstmt.close();
 					  ctstmt = null;
 				   }
 				   if(ctconn != null){
 					   ctconn.close();
 					   ctconn = null;
 				   }
 			   }catch(Exception e){
 				   e.printStackTrace();
 			   }
 		   }				   		    	
    }
       
   	/**
   	 * 从远程服务器自动拉回最新的配置文件到本地服务器
   	 */
   	private static void getFile(){
   		try {
   			addLog("开始拉回"+daytime+"登录文件,地址:/usr/local/bin/"+SYNCHFILENAME);
   			Process p = Runtime.getRuntime().exec("/usr/local/bin/"+SYNCHFILENAME);	
   			p.waitFor();//等待脚本执行完，才执行下面的内容 
   			addLog(daytime+"登录文件拉回成功！");
   		} catch (IOException e) {
   			addLog(e.getMessage());
   		}catch(Exception e1){
   			addLog(e1.getMessage());
   		}
   	}
       
       /**
   	 * 更新大客户流失状态，确保计算之前的数据的准确性。
   	 * 后面也有相关的计算，后面主要是为了计算流失之后又重新登录的情况，状态变回为保有状态，
   	 * 但是如果接口挂了或者网络异常，导致定时任务出现异常，
   	 * 则大客户流失状态可能会出现异常。这里可以保证大客户流失状态在出现异常的情况下，
   	 * 数据也是准确的。
   	 */
   	private static void updateCustomerLostStatus(){
   		  Connection ctconn = null;
   		   PreparedStatement ctstmt = null;
   		   try{
   		       ctconn = ConnUtil.getConn();			  		   
   		       StringBuffer sql = new StringBuffer();
   				  sql.append("update customerdetailquery set  vipStatus=2 WHERE ((lastLoginTime<> '' AND (((TO_DAYS('"+beforetime+"') - TO_DAYS(lastLoginTime) >= 5) AND vipGrade>=1 and vipGrade<=7 )  or ((TO_DAYS('"+beforetime+"') - TO_DAYS(lastLoginTime) >= 2) AND vipGrade>=8 and vipGrade<=10 )))  or  lastLoginTime='')") ;				   
                 ctstmt = ctconn.prepareStatement(sql.toString());	 
                 addLog("updatecustomerloststatussql:"+sql);
                 ctstmt.execute();
   		   }catch(Exception e){
   			   e.printStackTrace();
   		   }finally{
   			   try{
   				   if(ctstmt != null){//关闭连接
   					  ctstmt.close();
   					  ctstmt = null;
   				   }
   				   if(ctconn != null){
   					   ctconn.close();
   					   ctconn = null;
   				   }
   			   }catch(Exception e){
   				   e.printStackTrace();
   			   }
   		   }				   		
   	}
       
   	
   	/**
     * 重置客户的各种状态
     */
	public static void resetCustomerStatus(){
		   Connection ctconn = null;
		   PreparedStatement ctstmt = null;
		   try{
		       ctconn = ConnUtil.getConn();			  		   
               String insertsql = "UPDATE customerdetailquery SET isBack=0,isnew=0,isPromote=0 WHERE  isBack = 1 or isnew=1 or  isPromote=1";
               ctstmt = ctconn.prepareStatement(insertsql);	 
               addLog("insertsql:"+insertsql);
               ctstmt.execute();
		   }catch(Exception e){
			   e.printStackTrace();
		   }finally{
			   try{
				   if(ctstmt != null){//关闭连接
					  ctstmt.close();
					  ctstmt = null;
				   }
				   if(ctconn != null){
					   ctconn.close();
					   ctconn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }				
	}
   	
	/**
	 * 根据充值总金额计算vip等级
	 * @param payTotalAmt
	 * @return
	 */
	private static int getVipGrade(double payTotalAmt){
		 for(int i=0;i<amountFromList.size();i++){
         	long amountFrom = amountFromList.get(i);
         	long amountTo = amountToList.get(i);
         	Integer vipGrade = vipGradeList.get(i);
         	if(amountFrom <= payTotalAmt && amountTo >= payTotalAmt){
         		return vipGrade;
         	}
         }
		 return 0;
	}
   	
       /**
        * 生成支付数据
        */
       private static void makePayData(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Connection uconn = null;
    	   Statement stmt = null;
    	   PreparedStatement pstmt = null;
    	   PreparedStatement ustmt = null;
    	   ResultSet rs = null;
    	   ResultSet rrs = null;
    	   try{
    		  conn = ConnUtil.getPayConn();
    		  sconn = ConnUtil.getConn();
    		  uconn = ConnUtil.getConn();
    		  stmt = conn.createStatement();
    		  StringBuffer querysb = new StringBuffer("SELECT ToInnerUserid,GROUP_CONCAT(CONCAT('0',gameid)) sgameid,GROUP_CONCAT(successtime) ssuccesstime,SUM(payMondey) totalmoney,MAX(successtime) msuccesstime FROM paydetailok    ")
    		  .append(" WHERE OrderIdStatus='S' AND SuccessTime>='"+daytime+" 00:00:00' AND SuccessTime <='"+daytime+" 23:59:59' AND giftflag <> '1' AND payMondey > 0  ")
    		  .append(" GROUP BY ToInnerUserid ");
    		  addLog("getpaydatasql:"+querysb);
    		   rs = stmt.executeQuery(querysb.toString());    		   
    		   while(rs.next()){
    			   String uid = rs.getString("ToInnerUserid");
    			   String gameids = rs.getString("sgameid");
    			   String ssuccesstime = rs.getString("ssuccesstime");
    			   String msuccesstime = rs.getString("msuccesstime");
    			   double totalmoney = rs.getDouble("totalmoney");
    			   String lastPayGameid = "";
    			   String sql = "select payGameIds,payTotalAmt from customerdetailquery where uid = '"+uid+"'";
    			   addLog("query customersql:"+sql);
    			   pstmt = sconn.prepareStatement(sql);
    			   rrs = pstmt.executeQuery();
    			   if(rrs != null&& rrs.next()){//如果该客户已经存在   				   
    				   if(gameids.indexOf(",")==-1){
    					   lastPayGameid = gameids;
    				   }else{
    					   String times[] = ssuccesstime.split(",");
    					   String ids[] = gameids.split(",");
    					   for(int i=0;i<times.length;i++){
    						   if(StringTools.isEmpty(times[i]))continue;
    						   if(msuccesstime.indexOf(times[i])!=-1){
    							   lastPayGameid = ids[i];
    							   break;
    						   }
    					   }
    				   }
    				   String historyPayGameIds = rrs.getString("payGameIds");//历史充值的所有的游戏
    				   double historytotalmoney = rrs.getDouble("payTotalAmt");//历史充值总金额
    				   String newHistoryGameIds = getNewHistoryLoginGameIds(gameids,historyPayGameIds);//充值过的所有游戏
    				   int count = 0;
    				   if(newHistoryGameIds.indexOf(",") !=-1){
    					  String ids []  = newHistoryGameIds.split(",");
    					  for(String id:ids){
    						  if(!StringTools.isEmpty(id))count++;
    					  }
    				   }else{
    					   count = 1;
    				   }
    				   StringBuffer updatesb = new StringBuffer("update customerdetailquery set lastModifyAmt='")
    				   .append(totalmoney).append("',payGameId='").append(lastPayGameid).append("'")
    				   .append(",payCount='").append(count).append("'").append(",payTotalAmt='").append(totalmoney+historytotalmoney).append("'")
    				   .append(",lastPayTime='").append(msuccesstime.split(" ")[0]).append("',payGameIds='").append(newHistoryGameIds).append("'")
    				   .append(",vipGrade='").append(getVipGrade(totalmoney+historytotalmoney)).append("'")
    				   .append("   where uid='").append(uid).append("'");
    				   ustmt = uconn.prepareStatement(updatesb.toString());
    				   addLog("update customerdetailquery pay data uid="+uid+",updatesql:"+updatesb);
    				   ustmt.execute();
    			   }else{
    				   String insertsql = "insert customerloginlog values(?,?,?,?,?,?)";//记录新增时没有回调的情况
    				   ustmt = conn.prepareStatement(insertsql);
    				   ustmt.setString(1,null);
    				   ustmt.setString(2, uid);
    				   ustmt.setString(3, lastPayGameid);
    				   ustmt.setString(4, gameids);
    				   ustmt.setString(5, daytime);
    				   ustmt.setInt(6, 1);    				   
    			   }   			   
    		   }
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(ustmt != null){
    				   ustmt.close();
    				   ustmt = null;
    			   }
    			   if(uconn != null){
    				   uconn.close();
    				   uconn = null;
    			   }
    			   if(rrs != null){
    				   rrs.close();
    				   rrs = null;
    			   }
    			   if(pstmt != null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(sconn != null){
    				   sconn.close();
    				   sconn = null;
    			   }
    			   if(rs != null){//关闭数据库连接
    				   rs.close();
    				   rs = null;
    			   }
    			   if(stmt != null){
    				   stmt.close();
    				   stmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }
    	   }
       }
       
       
       /**
        * 解析登录文件，生成大客户系统的数据
        */
       private static void parseLoginFile(){
    	   FileInputStream fis = null;
    	   BufferedReader br = null;
    	   Connection conn = null;
    	   Connection sconn = null;
    	   PreparedStatement pstmt = null;
    	   PreparedStatement upstmt = null;
    	   ResultSet rs = null;
    	   try{
    		   conn = ConnUtil.getConn();	
    		   sconn = ConnUtil.getConn();	
    		  
    		   String dateDir = getFormatDate(daytime);
    		   String url = BASEURL +dateDir+".txt";
    		   addLog("login geturl:"+url);
    		   File file = new File(url);
    		   fis = new FileInputStream(file);
    		   br = new BufferedReader(new InputStreamReader(fis));
    		   String readline = br.readLine();
    		   while(readline != null){
    			   readline = readline.trim();
    			   String datas[] = readline.split("\t");
    			   String uid = datas[0].trim();
    			   String lastLoginGameid = datas[1].trim();
    			   String gameids = datas[2].trim();
    			   String querysql = "select loginGameIds,vipstatus from customerdetailquery where uid = '"+uid+"'";
    			   pstmt = sconn.prepareStatement(querysql);
    			   addLog("query customerdetailquery querysql:"+querysql);
    			   rs = pstmt.executeQuery();
    			   if(rs != null&& rs.next()){//如果该客户已经存在
    				   String historyGameIds = rs.getString("loginGameIds");//玩过的所有的游戏
    				   int vipstatus = rs.getInt("vipstatus");
    				   String newHistoryGameIds = getNewHistoryLoginGameIds(gameids,historyGameIds);
    				   int count = 0;
    				   if(newHistoryGameIds.indexOf(",") !=-1){
    					  String ids []  = newHistoryGameIds.split(",");
     					  for(String id:ids){
     						  if(!StringTools.isEmpty(id))count++;
     					  }
    				   }else{
    					   count = 1;
    				   }
    				   StringBuffer updateSql = new StringBuffer("update customerdetailquery set gameCount='")
    				   .append(count).append("',vipStatus=1,isBack=").append(isBack(vipstatus))
    				   .append(",loginGameId='").append(lastLoginGameid).append("',loginGameIds='").append(newHistoryGameIds).append("'")
    				   .append(",lastLoginTime='").append(daytime).append("'   where uid='").append(uid).append("'");
    				   addLog("login data daytime:"+daytime+",uid:"+uid+",updatesql:"+updateSql);
    				   upstmt = conn.prepareStatement(updateSql.toString());
    			   }else{//支付成功回调时会自动插入新增或晋级的客户数据
    				   String insertsql = "insert customerloginlog values(?,?,?,?,?,?)";//记录新增时没有回调的情况
    				   upstmt = conn.prepareStatement(insertsql);
    				   upstmt.setString(1,null);
    				   upstmt.setString(2, uid);
    				   upstmt.setString(3, lastLoginGameid);
    				   upstmt.setString(4, gameids);
    				   upstmt.setString(5, daytime);
    				   upstmt.setInt(6, 0);
    			   }
    			   upstmt.execute();
    			   readline = br.readLine();
    		   }
    	   }catch(Exception e){
    		   logger.error("customertask exception:"+e.getMessage());
    	   }finally{
    		   try{
    			   if(br != null){//关闭数据库连接
    				   br.close();
    				   br = null;
    			   }
    			   if(fis != null){
    				   fis.close();
    				   fis = null;
    			   }
    			   if(upstmt != null){
    				   upstmt.close();
    				   upstmt = null;
    			   }
    			   if(sconn != null){
    				   sconn.close();
    				   sconn = null;
    			   }
    			   if(rs != null){
    				   rs.close();
    				   rs = null;
    			   }
    			   if(pstmt != null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    		   }catch(Exception e){
    			   logger.error("customertask file close exception:"+e.getMessage());
    		   }    		   
    	   }
       }
       
       /**
        * 判断玩家是否回流
        * @param vipstatus
        * @param lastLoginTime
        * @return 1：表示是回流  0：表示不是回流
        * @throws Exception
        */
       private static int isBack(int vipstatus) throws Exception{
    	    if(vipstatus==1)return 0;    	  
    	    	return 1;   
       }

       /**
        * 返回新的玩过的游戏编号
        * @param gameids  前一天玩过的所有游戏
        * @param historyGameIds 之前玩过的所有游戏
        * @return
        */
       private static String getNewHistoryLoginGameIds(String gameids,String historyGameIds) throws Exception{
    	   if(StringTools.isEmpty(gameids))return historyGameIds;
    	   Set<String> gameset = new TreeSet<String>();
    	   if(StringTools.isEmpty(historyGameIds))historyGameIds="";
    	   gameids = historyGameIds+gameids;
    	   if(gameids.indexOf(",")==-1){//如果只玩过一款游戏
    		   if(!StringTools.isEmpty(gameids)){
    			   gameset.add(gameids);
    		   }
    	   }else{//如果玩过多款游戏
    		   String ids[]  = gameids.split(",");
    		   for(String id:ids){
    			   if(!StringTools.isEmpty(id)){
    				   gameset.add(id);
    			   }
    		   }
    	   }
    	   String logingameids = "";
			for(String game:gameset){
				logingameids += (game+",");
			}
			if(gameset != null){//清空集合中的数据
				gameset.clear();
				gameset = null;
			}
    	   return logingameids;
       }       
       
       /**
        * 将指定的时间转换成指定的格式
        * @param daytime
        * @return
        */
       private static String getFormatDate(String daytime) throws ParseException{
			Date date = yyyy_mm_dd.parse(daytime);			            
    	   return yyyymmdd.format(date);
       }     
       
}
