package com.xunlei.niux.manager.web.task.customer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.manager.web.vo.ConnUtil;


/**
 * 大客户系统定时任务
 * @author lisu
 *  2014-02-14
 */
public class CustomerReportTask {
	
	   private static final Logger logger = Logger.getLogger(CustomerReportTask.class.getName());
       private static final String BASEURL = "/data/bigUser/";//文件基础路径
       private static final SimpleDateFormat yyyymmdd = new SimpleDateFormat("yyyyMMdd");
       private static final SimpleDateFormat yyyy_mm_dd = new SimpleDateFormat("yyyy-MM-dd");
       private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
       private static String daytime;//指定日期
       private static String beforetime;//当前日期前一天
       
       static{
    	   if(daytime==null){
			  Calendar cal = Calendar.getInstance();
			  cal.add(Calendar.DAY_OF_MONTH, -1);
			  beforetime = format.format(cal.getTime());//当前时间的前一天
			  daytime = beforetime ;//默认指定日期为当前时间的前一天
    		   daytime = daytime.split(" ")[0];
    	   }    	   
       }
       
       
       public static void main(String args[]){
    	   if(args != null&&args.length>0){
    		   daytime = args[0];
    	   }
    	   make();//开始跑数据           
       }
       
       private static void addLog(String message){
    	   logger.info("nowtime:"+format.format(new Date())+",daytime:"+daytime+","+message);
       }
       
       /**
        * 初始化数据
        */
       private static void init(){
    	   Connection sconn = null;
    	   Statement stmt = null;
    	   ResultSet rs = null;
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    	   
    	   try{
    		   sconn = ConnUtil.getConn();
    		   conn = ConnUtil.getConn();    		   
    		   stmt = sconn.createStatement();
    		   String querysql = "select uid ,loginGameIds,vipgrade from customerdetailquery";
    		   rs = stmt.executeQuery(querysql);
    		   
    		   while(rs.next()){
    			   String uid = rs.getString(1);
    			   String gameids = rs.getString(2);//历史登录过的所有游戏
    			   int vipgrade = rs.getInt(3);
    			   if(StringTools.isEmpty(gameids))continue;
    			   String sql = "insert into customerreporttmp value(null,?,?,?,?)";
    			   pstmt = conn.prepareStatement(sql);
    			   if(gameids.indexOf(",")==-1){//如果只登陆过一款游戏
    				   pstmt.setString(1,formatGameId(gameids));
    				   pstmt.setString(2, uid);
    				   pstmt.setInt(3,vipgrade);
    				   pstmt.setString(4, daytime);
    				   pstmt.execute();
    			   }else{
    				   String mygameids[] = gameids.split(",");
    				   for(String gameid:mygameids){
    					   if(StringTools.isEmpty(gameid))continue;
        				   pstmt.setString(1,formatGameId(gameid));
        				   pstmt.setString(2, uid);
        				   pstmt.setInt(3,vipgrade);
        				   pstmt.setString(4, daytime);
        				   pstmt.execute();
    				   }
    			   }
    		   }   		   	   
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(pstmt !=null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    			   if(rs != null){
    				   rs.close();
    				   rs = null;
    			   }
    			   if(stmt != null){
    				   stmt.close();
    				   stmt = null;
    			   }
    			   if(sconn != null){
    				   sconn.close();
    				   sconn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }    		   
    	   }   	       	   
       }
       
       private static  String formatGameId(String gameid){
    	   if(StringTools.isEmpty(gameid))return "";
    	   if(gameid.length()>6){
    		   gameid = gameid.substring(gameid.length()-5,gameid.length());
    	   }
    	   if(gameid.length()<6){
    		   gameid = "0"+gameid;
    	   }
    	   return gameid;
       }
       
       private static void make(){
     	   addLog("deleteCustomerReport start...");
     	   deleteCustomerReport();     	  
    	   makeInitCustomerReportCount();
    	   makeCustomerReport();    
    	   deleteCustomerReporttmp();
       }
       
   
       /**
        * 将指定的时间转换成指定的格式
        * @param daytime
        * @return
        */
       private static String getFormatDate(String daytime) throws ParseException{
			Date date = yyyy_mm_dd.parse(daytime);			            
    	   return yyyymmdd.format(date);
       }     
       
       
       /**
        * 初始化总人数
        */
       private static void makeInitCustomerReportCount(){
    	   addLog("init data start ...");
    	   init();
    	   addLog("initMakeLoginPeopleCount start ...");
    	   initMakeLoginPeopleCount();
    	   addLog("initMakeContactPeopleCount start ...");
    	   initMakeContactPeopleCount();
     	   addLog("updatemakeSalePeopleCount start ...");
     	   updatemakeSalePeopleCount();
     	   addLog("makeRebatePeopleCount start ...");	   
     	   updatemakeRebatePeopleCount();
     	   addLog("initMakeRebatePeopleCount end ...");
       }
       
       /**
        *  生成销售报表
        */
       private static void makeCustomerReport(){
    	   addLog("deleteCustomerReportTmp start ...");
    	   deleteCustomerReportTmp();     	  
    	  addLog("insertTmpData start ...");
    	  insertTmpData();
    	  addLog("updateVipGrade start ...");
    	  updateVipGrade();
    	  addLog("makeAddPeopleCount start ...");
    	  makeAddPeopleCount();
     	  addLog("makeAddContactPeopleCount start ...");
     	  makeAddContactPeopleCount();
     	  addLog("makeAddSalePeopleCount start ...");
     	  makeAddSalePeopleCount();
     	  addLog("makeAddRebatePeopleCount start ...");
     	  makeAddRebatePeopleCount();     	  
    	  addLog("updateTotalCount start ...");
    	  updateTotalCount();
    	  addLog("updateAllGameCount start ...");
    	  updateAllGameCount();
    	  addLog("updateAllGameCount start ...");
    	  vipGradeCount();
    	  addLog("updatePercent start ...");
     	  updatePercent();
     	  addLog("updatePercent end ...");
       }
       
       private static void updateTotalCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT gameid, SUM(peopleCount) ,SUM(contactCount),SUM(saleCount),SUM(rebateCount),SUM(addCount),SUM(addContactCount),SUM(addSaleCount),SUM(addRebateCount)  FROM customerreport WHERE daytime='"+daytime+"' GROUP BY gameid ";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "insert into customerreport values(null,?,'100',?,?,'0',?,'0',?,'0',?,?,?,?,?)";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				long peopleCount = rs.getLong(2);
    				long contactCount = rs.getLong(3);
    				long saleCount = rs.getLong(4);
    				long rebateCount = rs.getLong(5);
    				long addCount = rs.getLong(6);
    				long addContactCount = rs.getLong(7);
    				long addSaleCount = rs.getLong(8);
    				long addRebateCount = rs.getLong(9);
    				pstmt.setString(1, gameid);
    				pstmt.setLong(2, peopleCount);
    				pstmt.setLong(3, contactCount);
    				pstmt.setLong(4, saleCount);
    				pstmt.setLong(5, rebateCount);
    				pstmt.setLong(6, addCount);
    				pstmt.setLong(7, addContactCount);
    				pstmt.setLong(8, addSaleCount);
    				pstmt.setLong(9, addRebateCount);
    				pstmt.setString(10, daytime);
    				pstmt.execute();
    				addLog("daytime:"+daytime+",updateTotalCount updatesql:"+updatesql);
    			}    			    		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
    	   
       }
       
       private static void updateAllGameCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT  SUM(peopleCount) ,SUM(contactCount),SUM(saleCount),SUM(rebateCount),SUM(addCount),SUM(addContactCount),SUM(addSaleCount),SUM(addRebateCount)  FROM customerreport WHERE daytime='"+daytime+"'";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String insertsql = "insert into customerreport values(null,?,'101',?,?,'0',?,'0',?,'0',?,?,?,?,?)";
    			pstmt = sconn.prepareStatement(insertsql);
    			while(rs.next()){
    				long peopleCount = rs.getLong(1);
    				long contactCount = rs.getLong(2);
    				long saleCount = rs.getLong(3);
    				long rebateCount = rs.getLong(4);
    				long addCount = rs.getLong(5);
    				long addContactCount = rs.getLong(6);
    				long addSaleCount = rs.getLong(7);
    				long addRebateCount = rs.getLong(8);
    				pstmt.setString(1, "00");
    				pstmt.setLong(2, peopleCount);
    				pstmt.setLong(3, contactCount);
    				pstmt.setLong(4, saleCount);
    				pstmt.setLong(5, rebateCount);
    				pstmt.setLong(6, addCount);
    				pstmt.setLong(7, addContactCount);
    				pstmt.setLong(8, addSaleCount);
    				pstmt.setLong(9, addRebateCount);
    				pstmt.setString(10, daytime);
    				pstmt.execute();
    				addLog("daytime:"+daytime+",updateAllGameCount insertsql:"+insertsql);
    			}    	
//			    String updatesql = "UPDATE customerreport SET contactPercent=IFNULL(100*contactCount/peopleCount,0),salePercent=IFNULL(100*saleCount/contactCount,0),rebatePercent=IFNULL(100*rebateCount/saleCount,0)  WHERE vipgrade=101 and daytime='"+daytime+"'";
//			    pstmt = sconn.prepareStatement(updatesql);
//			    pstmt.execute();
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
    	   
       }
       
       /**
        * 转移数据到历史表
        */
       private static  void removeHistoryCount(){
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    
    		try{
    			conn = ConnUtil.getConn();    		
    			String updatesql = "INSERT INTO customerreportcount(daytime,gameid,vipGrade,totalCount,contactCount,saleCount,rebateCount) SELECT daytime,gameid,vipGrade,peopleCount,contactCount,saleCount,rebateCount FROM customerreport WHERE daytime='"+daytime+"' and vipgrade<>100 and gameid<> '00'";
    			pstmt = conn.prepareStatement(updatesql);    			
    			pstmt.execute();
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       
       private static  void addHistoryCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   ResultSet rrs = null;
    	   PreparedStatement rpstmt = null;    
    	   String querysql = "select * from customerreportcount where daytime='"+formatBeforeDay(daytime)+"'";//前天
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();   			
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set peopleCount=peopleCount+?,contactCount=contactCount+?,saleCount=saleCount+?,rebateCount=rebateCount+? where gameid=? and vipgrade=? and daytime=?";
    			//String updatesql = "update  customerreport set peopleCount=?,contactCount=?,saleCount=?,rebateCount=? where gameid=? and vipgrade=? and daytime=?";
    			String rquerysql = "select * from customerreport where gameid=? and vipgrade=? and daytime=?";
    			String insertsql = "insert into customerreport values(null,?,?,?,?,'0',?,'0',?,'0','0','0','0','0',?)";   		
    			while(rs.next()){
    				String gameid = rs.getString("gameid");
    				if(gameid.indexOf("null")!=-1){
    					gameid = gameid.substring(gameid.indexOf("null")+1);
    				}
    				int vipgrade = rs.getInt("vipGrade");
    				long totalCount = rs.getLong("totalCount");
    				long contactCount = rs.getLong("contactCount");
    				long saleCount = rs.getLong("saleCount");
    				long rebateCount = rs.getLong("rebateCount");
    				rpstmt = conn.prepareStatement(rquerysql);
    				rpstmt.setString(1,gameid);
    				rpstmt.setInt(2, vipgrade);
    				rpstmt.setString(3, daytime);
    				rrs = rpstmt.executeQuery();
    				if(rrs == null||!rrs.next()){//如果之前没有记录
    					pstmt = sconn.prepareStatement(insertsql);
    					pstmt.setString(1, gameid);
    					pstmt.setInt(2, vipgrade);
    					pstmt.setLong(3, totalCount);
    					pstmt.setLong(4, contactCount);
    					pstmt.setLong(5, saleCount);
    					pstmt.setLong(6, rebateCount);
    					pstmt.setString(7, daytime);   					
    					addLog("addHistoryCount insertsql:"+insertsql);
    				}else{
    					pstmt = sconn.prepareStatement(updatesql);
    					pstmt.setLong(1, totalCount);
    					pstmt.setLong(2, contactCount);
    					pstmt.setLong(3, saleCount);
    					pstmt.setLong(4, rebateCount);
    					pstmt.setString(5, gameid);
    					pstmt.setInt(6, vipgrade);
    					pstmt.setString(7, daytime);			
    					addLog("addHistoryCount updatesql:"+updatesql);
    				}
    				pstmt.execute();//增加新记录
    			}
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    
    				if(rrs != null){
    					rrs.close();
    					rrs = null;
    				}
    				if(rpstmt != null){
    					rpstmt.close();
    					rpstmt = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       /**
        * 生成新增有返利玩家人数的数据
        */
       private static void makeAddRebatePeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid,s1.vipGrade,COUNT(*) peoplecount FROM (SELECT * FROM customerreporttmp  WHERE daytime='"+daytime+"') s1  "+
           "   INNER JOIN (SELECT DISTINCT uid FROM rebateapply  WHERE checkstatus=1 AND lastCheckTime>='"+daytime+" 00:00:00' AND lastCheckTime<='"+daytime+" 23:59:59')s2 "+
    	    "  ON s1.uid = s2.uid  INNER JOIN (SELECT uid FROM customerdetailquery WHERE isnew=1 OR isPromote=1) s3  ON s1.uid = s3.uid  GROUP BY s1.gameid,s1.vipGrade ";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set addRebateCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("makeAddRebatePeopleCount updatesql:"+updatesql);
    			}    		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       /**
        * 生成新增销售玩家人数的数据
        */
       private static void makeAddSalePeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid,s1.vipGrade,COUNT(*) peoplecount FROM (SELECT * FROM customerreporttmp  WHERE daytime='"+daytime+"') s1"+
           "   INNER JOIN (SELECT DISTINCT uid FROM callrecord  WHERE calltime>='"+daytime+" 00:00:00' AND calltime<='"+daytime+" 23:59:59')s2 "+
    	    "  ON s1.uid = s2.uid   INNER JOIN (SELECT uid FROM customerdetailquery WHERE isnew=1 OR isPromote=1) s3  ON s1.uid = s3.uid  GROUP BY s1.gameid,s1.vipGrade ";
    		try{
//    			conn = ConnUtil.getBackConnection();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set addSaleCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("makeAddSalePeopleCount updatesql:"+updatesql);
    			}   		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       /**
        * 生成新增有联系方式玩家人数的数据
        */
       private static void makeAddContactPeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid,s1.vipGrade,COUNT(*) peoplecount FROM (SELECT * FROM customerreporttmp  WHERE daytime='"+daytime+"') s1"+
           "   INNER JOIN (SELECT uid FROM customerdetailquery WHERE (isnew=1 OR isPromote=1) AND (phone <> '' OR qq <> '' OR email<>'' OR contactNumber <> ''))s2 ON s1.uid = s2.uid "+
    	    "   GROUP BY s1.gameid,s1.vipGrade";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set addContactCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("makeAddContactPeopleCount updatesql:"+updatesql);
    			}
    			
    			//生成汇总数据
    			querysql = "SELECT gameid,SUM(addContactCount) speoplecount FROM customerreport WHERE daytime='"+daytime+"' GROUP BY gameid";
    			rs = stmt.executeQuery(querysql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				long count = rs.getLong(2);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, 100);//汇总默认数据
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("makeAddContactPeopleTotal updatesql:"+updatesql);
    			}
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       /**
        * 生成新增玩家人数的数据
        */
       private static void makeAddPeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid,s1.vipGrade,COUNT(*) peoplecount FROM (SELECT * FROM customerreporttmp  WHERE daytime='"+daytime+"') s1"+
           "   INNER JOIN (SELECT uid FROM customerdetailquery WHERE isnew=1 OR isPromote=1)s2 ON s1.uid = s2.uid "+
    	    "  GROUP BY s1.gameid,s1.vipGrade";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set addCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("makeAddPeopleCount updatesql:"+updatesql);
    			}    		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       /**
        * 生成返利人数的数据
        */
       private static void makeRebatePeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid,s1.vipGrade,COUNT(*) peoplecount FROM (SELECT * FROM customerreporttmp  WHERE daytime='"+daytime+"') s1"+
           "  INNER JOIN (SELECT DISTINCT uid  FROM rebateapply  WHERE checkstatus=1 AND lastCheckTime>='"+daytime+" 00:00:00' AND lastCheckTime<='"+daytime+" 23:59:59')s2 "+
    	    "  ON s1.uid = s2.uid  GROUP BY s1.gameid,s1.vipGrade";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set rebateCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("makeRebatePeopleCount updatesql:"+updatesql);
    			}    			   		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       /**
        * 生成返利人数的数据
        */
       private static void initMakeRebatePeopleCount(){
    	   Connection sconn = null;
    	   Statement stmt = null;
    	   ResultSet rs = null;
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    	   
    	   try{
    		   sconn = ConnUtil.getConn();
    		   conn = ConnUtil.getConn();    		   
    		   stmt = sconn.createStatement();
    		   String querysql = "SELECT s1.uid,s1.gameid,s2.vipgrade FROM (SELECT uid,gameid FROM rebateapply WHERE gameid<>'' GROUP BY uid,gameid) s1 INNER JOIN customerdetailquery s2 ON s1.uid = s2.uid;";
    		   rs = stmt.executeQuery(querysql);
    		   
    		   while(rs.next()){
    			   String uid = rs.getString(1);
    			   String gameids = rs.getString(2);//历史登录过的所有游戏
    			   int vipgrade = rs.getInt(3);
    			   if(StringTools.isEmpty(gameids))continue;
    			   String sql = "insert into customerreporttmp value(null,?,?,?,?)";
    			   pstmt = conn.prepareStatement(sql);
				   pstmt.setString(1,gameids);
				   pstmt.setString(2, uid);
				   pstmt.setInt(3,vipgrade);
				   pstmt.setString(4, daytime);
				   pstmt.execute();    			 
    		   }   		   	   
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(pstmt !=null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    			   if(rs != null){
    				   rs.close();
    				   rs = null;
    			   }
    			   if(stmt != null){
    				   stmt.close();
    				   stmt = null;
    			   }
    			   if(sconn != null){
    				   sconn.close();
    				   sconn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }    		   
    	   }   	       	   
       }
       
       /**
        * 生成有联系方式的数据
        */
       private static void updatemakeSalePeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT count(s1.uid),s1.gameid,s2.vipgrade FROM (SELECT uid,gameid FROM callrecord WHERE gameid<>'' GROUP BY uid,gameid) s1 INNER JOIN customerdetailquery s2 ON s1.uid = s2.uid  group by s1.gameid,s2.vipgrade;";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set saleCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(2);
    				int vipgrade = rs.getInt(3);
    				long count = rs.getLong(1);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("updatemakeSalePeopleCount updatesql:"+updatesql);
    			}  		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       
       private static void updatemakeRebatePeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT count(s1.uid),s1.gameid,s2.vipgrade FROM (SELECT uid,gameid FROM rebateapply WHERE gameid<>'' GROUP BY uid,gameid) s1 INNER JOIN customerdetailquery s2 ON s1.uid = s2.uid  group by s1.gameid,s2.vipgrade;";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set rebateCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(2);
    				int vipgrade = rs.getInt(3);
    				long count = rs.getLong(1);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("updatemakeRebatePeopleCount updatesql:"+updatesql);
    			}  		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       /**
        * 生成有联系方式的数据
        */
       private static void makeSalePeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid,s1.vipGrade,COUNT(*) peoplecount FROM (SELECT * FROM customerreporttmp  WHERE daytime='"+daytime+"') s1"+
           "  INNER JOIN (SELECT DISTINCT uid FROM callrecord  WHERE calltime>='"+daytime+" 00:00:00' AND calltime<='"+daytime+" 23:59:59')s2 "+
    	    "  ON s1.uid = s2.uid  GROUP BY s1.gameid,s1.vipGrade";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set saleCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("makeSalePeopleCount updatesql:"+updatesql);
    			}    			    		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       
       /**
        * 生成有联系方式的数据
        */
       private static void initMakeSalePeopleCount(){
    	   Connection sconn = null;
    	   Statement stmt = null;
    	   ResultSet rs = null;
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    	   
    	   try{
    		   sconn = ConnUtil.getConn();
    		   conn = ConnUtil.getConn();    		   
    		   stmt = sconn.createStatement();
    		   String querysql = "SELECT s1.uid,s1.gameid,s2.vipgrade FROM (SELECT uid,gameid FROM callrecord WHERE gameid<>'' GROUP BY uid,gameid) s1 INNER JOIN customerdetailquery s2 ON s1.uid = s2.uid;";
    		   rs = stmt.executeQuery(querysql);
    		   
    		   while(rs.next()){
    			   String uid = rs.getString(1);
    			   String gameids = rs.getString(2);//历史登录过的所有游戏
    			   int vipgrade = rs.getInt(3);
    			   if(StringTools.isEmpty(gameids))continue;
    			   String sql = "insert into customerreporttmp value(null,?,?,?,?)";
    			   pstmt = conn.prepareStatement(sql);
				   pstmt.setString(1, formatGameId(gameids));
				   pstmt.setString(2, uid);
				   pstmt.setInt(3,vipgrade);
				   pstmt.setString(4, daytime);
				   pstmt.execute();    			 
    		   }   		   	   
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(pstmt !=null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    			   if(rs != null){
    				   rs.close();
    				   rs = null;
    			   }
    			   if(stmt != null){
    				   stmt.close();
    				   stmt = null;
    			   }
    			   if(sconn != null){
    				   sconn.close();
    				   sconn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }    		   
    	   }   	       	   
       }
       
       /**
        * 生成有联系方式的数据
        */
       private static void makeContactPeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid sgameid,s1.vipGrade svipgrade,COUNT(*) peoplecount FROM (SELECT * FROM customerreporttmp  WHERE daytime='"+daytime+"') s1"+
           "  INNER JOIN customerdetailquery s2 ON s1.uid = s2.uid   WHERE phone <> '' OR qq <> '' OR email<>'' OR contactNumber <> ''  GROUP BY s1.gameid,s1.vipGrade";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set contactCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, gameid);
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("makeContactPeopleCount updatesql:"+updatesql);
    			}    		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       /**
        * 生成有联系方式的数据
        */
       private static void initMakeContactPeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid sgameid,s1.vipGrade svipgrade,COUNT(*) peoplecount FROM (SELECT distinct gameid,vipGrade,uid FROM customerreporttmp  WHERE daytime='"+daytime+"') s1"+
           "  INNER JOIN customerdetailquery s2 ON s1.uid = s2.uid   WHERE phone <> '' OR qq <> '' OR email<>'' OR contactNumber <> ''  GROUP BY s1.gameid,s1.vipGrade";
    		try{
//    			conn = ConnUtil.getBackConnection();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String updatesql = "update  customerreport set contactCount=? where gameid=? and vipgrade=? and daytime=?";
    			pstmt = sconn.prepareStatement(updatesql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setLong(1, count);
    				pstmt.setString(2, formatGameId(gameid));
    				pstmt.setInt(3, vipgrade);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    				addLog("initmakeContactPeopleCount updatesql:"+updatesql);
    			}
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       
       /**
        * 生成登录总人数数据
        */
       private static void initMakeLoginPeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid sgameid,s1.vipGrade svipgrade,COUNT(*) peoplecount FROM (SELECT distinct gameid,vipGrade,uid FROM customerreporttmp  WHERE daytime='"+daytime+"') s1"+
           "   INNER JOIN customerdetailquery s2 ON s1.uid = s2.uid GROUP BY s1.gameid,s1.vipGrade";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String insertsql = "insert into customerreport values(null,?,?,?,'0','0','0','0','0','0','0','0','0','0',?)";
    			pstmt = sconn.prepareStatement(insertsql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setString(1, formatGameId(gameid));
    				pstmt.setInt(2, vipgrade);
    				pstmt.setLong(3, count);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    			}
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       
       
       /**
        * 生成登录总人数数据
        */
       private static void makeLoginPeopleCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT s1.gameid sgameid,s1.vipGrade svipgrade,COUNT(*) peoplecount FROM (SELECT * FROM customerreporttmp  WHERE daytime='"+daytime+"') s1"+
           "   INNER JOIN customerdetailquery s2 ON s1.uid = s2.uid GROUP BY s1.gameid,s1.vipGrade";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String insertsql = "insert into customerreport values(null,?,?,?,'0','0','0','0','0','0','0','0','0','0',?)";
    			pstmt = sconn.prepareStatement(insertsql);
    			while(rs.next()){
    				String gameid = rs.getString(1);
    				int vipgrade = rs.getInt(2);
    				long count = rs.getLong(3);
    				pstmt.setString(1, gameid);
    				pstmt.setInt(2, vipgrade);
    				pstmt.setLong(3, count);
    				pstmt.setString(4, daytime);
    				pstmt.execute();
    			}
    			
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	   
       }
       
       
       /**
        * 更新各种比例
        */
       private static void updatePercent(){
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    	   
    	   try{
    		   conn = ConnUtil.getConn();    		   
               String updatesql = "UPDATE customerreport SET contactPercent=IFNULL(100*contactCount/peopleCount,0),salePercent=IFNULL(100*saleCount/contactCount,0),rebatePercent=IFNULL(100*rebateCount/saleCount,0)  WHERE daytime='"+daytime+"'";
               pstmt = conn.prepareStatement(updatesql);
               pstmt.execute();
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(pstmt !=null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }    		   
    	   }   	   
       }
       
       
       private static void deleteCustomerReporttmp(){
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    	   
    	   try{
    		   conn = ConnUtil.getConn();    		   
               String deletesql = "delete from customerreporttmp  ";
               pstmt = conn.prepareStatement(deletesql);
               pstmt.execute();
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(pstmt !=null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }    		   
    	   }   	   
       }
       
       
       /**
        * 如果之前有数据，则删除后重新生成
        */
       private static void deleteCustomerReport(){
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    	   
    	   try{
    		   conn = ConnUtil.getConn();    		   
               String deletesql = "delete from customerreport WHERE daytime='"+daytime+"' ";
               pstmt = conn.prepareStatement(deletesql);
               pstmt.execute();
               deletesql = "delete from customerreporttmp WHERE daytime='"+daytime+"' ";
               pstmt = conn.prepareStatement(deletesql);
               pstmt.execute();
               
               deletesql = "delete from customerreportcount WHERE daytime='"+daytime+"' ";
               pstmt = conn.prepareStatement(deletesql);
               pstmt.execute();
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(pstmt !=null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }    		   
    	   }   	   
       }
       
       private static void deleteCustomerReportTmp(){
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    	   
    	   try{
    		   conn = ConnUtil.getConn();    		   
               String deletesql = "delete from customerreporttmp WHERE daytime='"+daytime+"' ";
               pstmt = conn.prepareStatement(deletesql);
               pstmt.execute();
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(pstmt !=null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }    		   
    	   }   	   
       }
       
       
       /**
        * 更新vip等级
        */
       private static void updateVipGrade(){
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    	   
    	   try{
    		   conn = ConnUtil.getConn();    		   
               String updatesql = "UPDATE customerreporttmp s1 INNER JOIN customerdetailquery s2 ON s1.uid = s2.uid SET s1.vipgrade=s2.vipgrade WHERE s1.daytime='"+daytime+"' ";
               pstmt = conn.prepareStatement(updatesql);
               pstmt.execute();
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(pstmt !=null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }    		   
    	   }   	   
       }
       
       public static String formatBeforeDay(String daytime){
	   		if(daytime==null||"".equals(daytime))return null;
	   		Calendar cal = Calendar.getInstance();
	   		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	   		Date date = null;
	   		try {
	   			date = sdf.parse(daytime);
	   		} catch (ParseException e) {
	   			e.printStackTrace();
	   		}
	   		cal.setTime(date);
	   		cal.add(Calendar.DAY_OF_MONTH, -1);	
	   		String now = sdf.format(cal.getTime());		
	   		return now;
   	}
       
       /**
        * 插入读取文件中数据，生成临时数据
        */
       private static void insertTmpData(){
    	   FileInputStream fis = null;
    	   BufferedReader br = null;
    	   Connection conn = null;
    	   PreparedStatement pstmt = null;    	   
    	   try{
    		   conn = ConnUtil.getConn();    		   
        	   String dateDir = getFormatDate(daytime);
    		   String url = BASEURL +dateDir+".txt";
    		   File file = new File(url);
    		   fis = new FileInputStream(file);
    		   br = new BufferedReader(new InputStreamReader(fis));
    		   String readline = br.readLine();
    		   while(readline != null){
    			   readline = readline.trim();
    			   String datas[] = readline.split("\t");
    			   String uid = datas[0].trim();
    			   String gameids = datas[2].trim();//前一天登录过的所有游戏
    			   if(StringTools.isEmpty(gameids))continue;
    			   String sql = "insert into customerreporttmp value(null,?,?,?,?)";
    			   pstmt = conn.prepareStatement(sql);
    			   if(gameids.indexOf(",")==-1){//如果只登陆过一款游戏
    				   pstmt.setString(1,gameids);
    				   pstmt.setString(2, uid);
    				   pstmt.setInt(3,0);
    				   pstmt.setString(4, daytime);
    				   pstmt.execute();
    			   }else{
    				   String mygameids[] = gameids.split(",");
    				   for(String gameid:mygameids){
        				   pstmt.setString(1,gameid);
        				   pstmt.setString(2, uid);
        				   pstmt.setInt(3,0);
        				   pstmt.setString(4, daytime);
        				   pstmt.execute();
    				   }
    			   }
    			   readline = br.readLine();
    		   }   		   	   
    	   }catch(Exception e){
    		   e.printStackTrace();
    	   }finally{
    		   try{
    			   if(pstmt !=null){
    				   pstmt.close();
    				   pstmt = null;
    			   }
    			   if(conn != null){
    				   conn.close();
    				   conn = null;
    			   }
    		   }catch(Exception e){
    			   e.printStackTrace();
    		   }    		   
    	   }   	   
       }
       
       
       private static void vipGradeCount(){
    	   Connection conn = null;
    	   Connection sconn = null;
    	   Statement stmt = null;  
    	   PreparedStatement pstmt = null;    
    	   ResultSet rs = null;
    	   String querysql = "SELECT  vipGrade,SUM(peopleCount) ,SUM(contactCount),SUM(saleCount),SUM(rebateCount),SUM(addCount),SUM(addContactCount),SUM(addSaleCount),SUM(addRebateCount)  FROM customerreport WHERE daytime='"+daytime+"' and vipGrade<=10  group by vipGrade";
    		try{
    			conn = ConnUtil.getConn();
    			sconn = ConnUtil.getConn();
    			stmt = conn.createStatement();
    			rs = stmt.executeQuery(querysql);
    			String insertsql = "insert into customerreport values(null,?,?,?,?,'0',?,'0',?,'0',?,?,?,?,?)";
    			pstmt = sconn.prepareStatement(insertsql);
    			while(rs.next()){
    				int vipgrade = rs.getInt(1);
    				long peopleCount = rs.getLong(2);
    				long contactCount = rs.getLong(3);
    				long saleCount = rs.getLong(4);
    				long rebateCount = rs.getLong(5);
    				long addCount = rs.getLong(6);
    				long addContactCount = rs.getLong(7);
    				long addSaleCount = rs.getLong(8);
    				long addRebateCount = rs.getLong(9);
    				pstmt.setString(1, "00");
    				pstmt.setInt(2, vipgrade);
    				pstmt.setLong(3, peopleCount);
    				pstmt.setLong(4, contactCount);
    				pstmt.setLong(5, saleCount);
    				pstmt.setLong(6, rebateCount);
    				pstmt.setLong(7, addCount);
    				pstmt.setLong(8, addContactCount);
    				pstmt.setLong(9, addSaleCount);
    				pstmt.setLong(10, addRebateCount);
    				pstmt.setString(11, daytime);
    				pstmt.execute();
    				addLog("daytime:"+daytime+",vipGradeCount insertsql:"+insertsql);
    			}    	   		
    		}catch(Exception e){
    			e.printStackTrace();
    		}finally{
    			try{
    				if(pstmt != null){
    					pstmt.close();
    					pstmt = null;
    				}
    				if(sconn != null){
    					sconn.close();
    					sconn = null;
    				}
    				if(rs != null){
    					rs.close();
    					rs = null;
    				}
    				if(stmt != null){
    					stmt.close();
    					stmt = null;
    				}
    				if(conn != null){
    					conn.close();
    					conn = null;
    				}
    			}catch(Exception e){
    				e.printStackTrace();
    			}   			
    		}    	       	       	   
       }
   
}
