package com.xunlei.niux.manager.web.task.business;

import com.xunlei.niux.data.vipgame.bo.businesss.IncomeBo;
import com.xunlei.niux.data.vipgame.facade.JdbcFacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.Income;
import com.xunlei.niux.data.vipgame.vo.business.IntoSystem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 计算页游收益查询的定时任务
 * Created by lizeyu on 2015/11/17.
 */
public class IncomeTask{

    public static void main(String[] args){
        checkData();
    }

    private static void checkData(){
        String findUnllSql = "select * from income where gameid not like '05%' and gameid not in ('000150','000149','000148') and secondprincipal is null";

        List<Income> list = JdbcFacadeFactory.INSTANCE.getIncomeBo().findSql(findUnllSql);

        if(list.size() > 0) {
            for(Income income : list) {
                //计算收益
                countIncome(income);
            }

            //计算全部收益
            countTotalIcome();
        }
    }

    /**
     * 计算全部游戏收益
     */
    private static void countTotalIcome() {
        String deleteSql = "delete from income where gameid = 000000";

        IncomeBo incomeBo = JdbcFacadeFactory.INSTANCE.getIncomeBo();
        incomeBo.execute(deleteSql, new ArrayList<Object>());

        String insertSql = "insert into income (" +
                "  gameid," +
                "  incomemonth," +
                "  total," +
                "  secondprincipal," +
                "  firstprincipal," +
                "  money" +
                ") " +
                "SELECT " +
                "  '000000'," +
                "  incomemonth," +
                "  SUM(total)," +
                "  SUM(secondprincipal)," +
                "  SUM(firstprincipal)," +
                "  SUM(money) " +
                "FROM" +
                "  income " +
                "GROUP BY incomemonth ";
        incomeBo.execute(insertSql, new ArrayList<Object>());

    }

    private static void countIncome(Income income) {
        String gameId = income.getGameid();
        IntoSystem tempIntoSys = new IntoSystem();
        tempIntoSys.setGameid(gameId);

        List<IntoSystem> list =  JdbcFacadeFactory.INSTANCE.getIntoSystemBo().find(tempIntoSys, 0, 0);
        if(list.size() > 0) {
            IntoSystem intoSystem = list.get(0);

            //固定分成
            if(intoSystem.getSystype().intValue()==0) {
                Integer ratios = intoSystem.getIntoratio();
                countByRadio(income, ratios);

            } else if(!intoSystem.getNoregulartype()) {
                //固定区间值

                Integer ratios = 0;
                for(IntoSystem temp : list) {
                    long beginMoney = temp.getBeginmoney() * 10000;
                    long endMoney = temp.getEndmoney() != 0 ? temp.getEndmoney() * 10000 : Long.MAX_VALUE;

                    long nowMoney = income.getTotal().longValue();
                    if(nowMoney > beginMoney && nowMoney<= endMoney) {
                        ratios = temp.getIntoratio();
                        break;
                    }
                }
                countByRadio(income, ratios);
            } else {
                //区间增量
                countByRadioAdd(list, income);
            }

        }
    }

    private static void countByRadioAdd(final List<IntoSystem> list, Income income) {
        int num = 0;
        for(IntoSystem temp : list) {
            long beginMoney = temp.getBeginmoney() * 10000;
            long endMoney = temp.getEndmoney() != 0 ? temp.getEndmoney() * 10000 : Long.MAX_VALUE;

            long nowMoney = income.getTotal().longValue();
            if(nowMoney > beginMoney && nowMoney<= endMoney) {
                break;
            }
            num++;
        }


        if (num > list.size() - 1) return;
        IntoSystem temp = (IntoSystem)list.get(num);

        BigDecimal secondprincipal = (income.getTotal().subtract(BigDecimal.valueOf(temp.getBeginmoney() * 10000)))
                .multiply(BigDecimal.valueOf(temp.getIntoratio()))
                .divide(BigDecimal.valueOf(100L));


        if(num > 0) {
            for(int i = num - 1; i >=0; i--) {
                IntoSystem is = list.get(i);

                long beginMoney = is.getBeginmoney() * 10000;
                long endMoney = is.getEndmoney() * 10000;

                long value = (endMoney - beginMoney) * is.getIntoratio() / 100 ;

                secondprincipal = secondprincipal.add(BigDecimal.valueOf(value));
            }
        }

        countFirstprincipal(income, secondprincipal);


    }

    private static void countByRadio(Income income, Integer ratios) {
        BigDecimal secondprincipal = income.getTotal().multiply(BigDecimal.valueOf(ratios))
                .divide(BigDecimal.valueOf(100L));

        countFirstprincipal(income, secondprincipal);
    }

    private static void countFirstprincipal(Income income, BigDecimal secondprincipal) {
        secondprincipal = secondprincipal.setScale(2);

        BigDecimal firstprincipal = income.getTotal().subtract(secondprincipal);

        income.setSecondprincipal(secondprincipal);
        income.setFirstprincipal(firstprincipal);
        income.setMoney(firstprincipal);

        JdbcFacadeFactory.INSTANCE.getIncomeBo().update(income);
    }


}
