package com.xunlei.niux.manager.web.task.business;

import com.xunlei.niux.data.vipgame.bo.businesss.IncomeAppBo;
import com.xunlei.niux.data.vipgame.facade.JdbcFacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.IncomeApp;
import com.xunlei.niux.data.vipgame.vo.business.IntoSystem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 计算手游收益查询的定时任务
 * Created by lizeyu on 2015/11/17.
 */
public class IncomeAppTask{

    public static void main(String[] args){
        checkData();
    }

    private static void checkData(){
        String findUnllSql = "select * from incomeapp where secondprincipal is null";

        List<IncomeApp> list =  JdbcFacadeFactory.INSTANCE.getIncomeAppBo().findSql(findUnllSql);

        if(list.size() > 0) {
            for(IncomeApp incomeapp : list) {
                //计算收益
                countIncome(incomeapp);
            }

            //计算全部收益
            countTotalIcome();
        }
    }

    /**
     * 计算全部游戏收益
     */
    private static void countTotalIcome() {
        String deleteSql = "delete from incomeapp where gameid = '000000'";

        IncomeAppBo incomeAppBo = JdbcFacadeFactory.INSTANCE.getIncomeAppBo();
        incomeAppBo.execute(deleteSql, new ArrayList<Object>());

        String insertSql = "insert into incomeapp (" +
                "  gameid," +
                "  incomemonth," +
                "  total," +
                "  qudaoCost," +
                "  secondprincipal," +
                "  firstprincipal," +
                "  money" +
                ") " +
                "SELECT " +
                "  '000000'," +
                "  incomemonth," +
                "  SUM(total)," +
                "  SUM(qudaoCost)," +
                "  SUM(secondprincipal)," +
                "  SUM(firstprincipal)," +
                "  SUM(money) " +
                "FROM" +
                "  incomeapp " +
                "GROUP BY incomemonth ";
        incomeAppBo.execute(insertSql, new ArrayList<Object>());

    }

    private static void countIncome(IncomeApp income) {
        String gameId = income.getGameid();
        IntoSystem tempIntoSys = new IntoSystem();
        tempIntoSys.setGameid(gameId);

        List<IntoSystem> list =  JdbcFacadeFactory.INSTANCE.getIntoSystemBo().find(tempIntoSys, 0, 0);
        if(list.size() > 0) {
            IntoSystem intoSystem = list.get(0);
            int systype = intoSystem.getSystype().intValue();
            Integer qudao = intoSystem.getQudao();
            //固定分成
            if(systype==0) {
                Integer ratios = intoSystem.getIntoratio();
                countByRadio(income, ratios,systype,qudao);
            }else if(systype==2){//固定分成去除渠道
                Integer ratios = intoSystem.getIntoratio();
                countByRadio(income, ratios,qudao);
            } else if(!intoSystem.getNoregulartype()) {
                //固定区间值

                Integer ratios = 0;
                for(IntoSystem temp : list) {
                    long beginMoney = temp.getBeginmoney() * 10000;
                    long endMoney = temp.getEndmoney() != 0 ? temp.getEndmoney() * 10000 : Long.MAX_VALUE;

                    long nowMoney = income.getTotal().longValue();
                    if(nowMoney > beginMoney && nowMoney<= endMoney) {
                        ratios = temp.getIntoratio();
                        break;
                    }
                }
                countByRadio(income, ratios,systype,qudao);
            } else {
                //区间增量
                countByRadioAdd(list, income,systype,qudao);
            }
        }
    }

    private static void countByRadioAdd(final List<IntoSystem> list, IncomeApp income,int systype,Integer qudao) {
        int num = 0;
        for(IntoSystem temp : list) {
            long beginMoney = temp.getBeginmoney() * 10000;
            long endMoney = temp.getEndmoney() != 0 ? temp.getEndmoney() * 10000 : Long.MAX_VALUE;

            long nowMoney = income.getTotal().longValue();
            if(nowMoney > beginMoney && nowMoney<= endMoney) {
                break;
            }
            num++;
        }

        IntoSystem temp = list.get(num);
        BigDecimal secondprincipal = null;
        BigDecimal qudaocipal = null;
        if(systype==3){
            qudaocipal = income.getTotal().multiply(BigDecimal.valueOf(qudao)) .divide(BigDecimal.valueOf(100L));
            qudaocipal = qudaocipal.setScale(2,BigDecimal.ROUND_HALF_UP);
            BigDecimal firstqudaocipal = income.getTotal().subtract(qudaocipal);//总收益 - 渠道成本
            secondprincipal = (firstqudaocipal.subtract(BigDecimal.valueOf(temp.getBeginmoney() * 10000)))
                    .multiply(BigDecimal.valueOf(temp.getIntoratio()))
                    .divide(BigDecimal.valueOf(100L));
        }else{
            secondprincipal = (income.getTotal().subtract(BigDecimal.valueOf(temp.getBeginmoney() * 10000)))
                    .multiply(BigDecimal.valueOf(temp.getIntoratio()))
                    .divide(BigDecimal.valueOf(100L));
        }

        if(num > 0) {
            for(int i = num - 1; i >=0; i--) {
                IntoSystem is = list.get(i);

                long beginMoney = is.getBeginmoney() * 10000;
                long endMoney = is.getEndmoney() * 10000;

                long value = (endMoney - beginMoney) * is.getIntoratio() / 100 ;

                secondprincipal = secondprincipal.add(BigDecimal.valueOf(value));
            }
        }
        if(systype==3){
            countFirstprincipal(income, secondprincipal,qudaocipal);
        }else{
            countFirstprincipal(income, secondprincipal);
        }
    }

    private static void countByRadio(IncomeApp income, Integer ratios,int systype,Integer qudao) {
        BigDecimal secondprincipal = null;
        if(systype==3){
            BigDecimal qudaocipal = income.getTotal().multiply(BigDecimal.valueOf(qudao)) .divide(BigDecimal.valueOf(100L));
            qudaocipal = qudaocipal.setScale(2,BigDecimal.ROUND_HALF_UP);
            BigDecimal firstqudaocipal = income.getTotal().subtract(qudaocipal);//总收益 - 渠道成本
            secondprincipal = firstqudaocipal.multiply(BigDecimal.valueOf(ratios)) .divide(BigDecimal.valueOf(100L));
            countFirstprincipal(income, secondprincipal,qudaocipal);
        }else{
            secondprincipal = income.getTotal().multiply(BigDecimal.valueOf(ratios))
                    .divide(BigDecimal.valueOf(100L));
            countFirstprincipal(income, secondprincipal);
        }
    }

    private static void countByRadio(IncomeApp income, Integer ratios,Integer qudao) {
        countFirstprincipal(income, ratios,qudao);
    }

    private static void countFirstprincipal(IncomeApp income, BigDecimal secondprincipal, BigDecimal qudaocipal) {

        BigDecimal newqudaocipal = qudaocipal.setScale(2,BigDecimal.ROUND_HALF_UP);
        BigDecimal newfirstprincipal = income.getTotal().subtract(newqudaocipal);
        secondprincipal = secondprincipal.setScale(2,BigDecimal.ROUND_HALF_UP);
        BigDecimal firstprincipal = newfirstprincipal.subtract(secondprincipal);
        income.setQudaoCost(qudaocipal);
        income.setSecondprincipal(secondprincipal);
        income.setFirstprincipal(firstprincipal);
        income.setMoney(firstprincipal);
        JdbcFacadeFactory.INSTANCE.getIncomeAppBo().update(income);
    }


    private static void countFirstprincipal(IncomeApp income, BigDecimal secondprincipal) {

        secondprincipal = secondprincipal.setScale(2,BigDecimal.ROUND_HALF_UP);

        BigDecimal firstprincipal = income.getTotal().subtract(secondprincipal);

        income.setSecondprincipal(secondprincipal);
        income.setFirstprincipal(firstprincipal);
        income.setMoney(firstprincipal);

        JdbcFacadeFactory.INSTANCE.getIncomeAppBo().update(income);
    }

    private static void countFirstprincipal(IncomeApp income, Integer ratios,Integer qudao) {
        BigDecimal qudaocipal = income.getTotal().multiply(BigDecimal.valueOf(qudao))
                .divide(BigDecimal.valueOf(100L));
        qudaocipal = qudaocipal.setScale(2,BigDecimal.ROUND_HALF_UP);
        BigDecimal firstqudaocipal = income.getTotal().subtract(qudaocipal);//总收益 - 渠道成本

        BigDecimal secondprincipal = firstqudaocipal.multiply(BigDecimal.valueOf(ratios))
                .divide(BigDecimal.valueOf(100L));
        secondprincipal = secondprincipal.setScale(2,BigDecimal.ROUND_HALF_UP);

        income.setQudaoCost(qudaocipal);
        BigDecimal firstprincipal = firstqudaocipal.subtract(secondprincipal);

        income.setSecondprincipal(secondprincipal);
        income.setFirstprincipal(firstprincipal);
        income.setMoney(firstprincipal);

        JdbcFacadeFactory.INSTANCE.getIncomeAppBo().update(income);
    }
}
