package com.xunlei.niux.manager.web.task.business;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import com.xunlei.niux.manager.web.vo.ConnUtil;

public class BusinessTask {


	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
	private static String month = "";
	
	static {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.MONTH, -1);
		month = sdf.format(cal.getTime());	
	}
	
	public static void main(String[] args) {
		if(args != null&&args.length>0){
			month = args[0];
		}
		System.out.println("month:"+month+",deleteIncomeApp start");
		deleteIncomeApp();
		System.out.println("month:"+month+", make business start");
		make();
		System.out.println("month:"+month+", make business end");
	}

	 private static void deleteIncomeApp(){
  	   Connection conn = null;
  	   PreparedStatement pstmt = null;    	   
  	   try{
  		   conn = ConnUtil.getConn();    		   
             String deletesql = "delete from incomeapp WHERE incomemonth='"+month+"' ";
             pstmt = conn.prepareStatement(deletesql);
             pstmt.execute();
  	   }catch(Exception e){
  		   e.printStackTrace();
  	   }finally{
  		   try{
  			   if(pstmt !=null){
  				   pstmt.close();
  				   pstmt = null;
  			   }
  			   if(conn != null){
  				   conn.close();
  				   conn = null;
  			   }
  		   }catch(Exception e){
  			   e.printStackTrace();
  		   }    		   
  	   }   	   
     }
	private static void make(){
		Connection conn = null;
		Connection sconn = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;   
		ResultSet rs = null;
		try{
			conn = ConnUtil.getConn();
			sconn = ConnUtil.getConn();
			stmt = conn.createStatement();
			String sql = "SELECT s1.gameid,s1.total FROM (SELECT * FROM income WHERE incomemonth='"+month+"') s1 INNER JOIN  (SELECT gameid FROM games WHERE clientType=3) s2 ON s1.gameid = s2.gameid";
			rs = stmt.executeQuery(sql);
			String insertsql = "insert into incomeapp(seqid,gameid,incomemonth,total) values(null,?,?,?)";
			
			while(rs.next()){
				pstmt = sconn.prepareStatement(insertsql);
				String gameid =rs.getString(1);
				String total = rs.getString(2);
				pstmt.setString(1, gameid);
				pstmt.setString(2, month);
				pstmt.setString(3, total);
				pstmt.execute();
				System.out.println("month:"+month+", business  gameid:"+gameid+",total:"+total);
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(sconn != null){
					sconn.close();
					sconn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn =null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}			
		}
	}
	
	
}
